/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.events;

import io.github.sluggly.timemercenaries.capability.PlayerCapability;
import io.github.sluggly.timemercenaries.config.ServerConfig;
import io.github.sluggly.timemercenaries.entity.BattleChicken;
import io.github.sluggly.timemercenaries.init.EntityInit;
import io.github.sluggly.timemercenaries.mercenary.MercenaryManager;
import io.github.sluggly.timemercenaries.missions.MissionManager;
import io.github.sluggly.timemercenaries.network.PacketHandler;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@Mod.EventBusSubscriber(modid="timemercenaries", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonModEvents {
    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(PacketHandler::register);
    }

    @SubscribeEvent
    public static void entityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)EntityInit.NOMADIC_LLAMA.get(), Llama.m_30824_().m_22265_());
        event.put((EntityType)EntityInit.BATTLE_CHICKEN.get(), BattleChicken.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        PlayerCapability.register(event);
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == ServerConfig.SPEC) {
            ServerConfig.markLoaded();
            MercenaryManager.getMercenaryManager().tryProcess();
            MissionManager.getMissionManager().tryProcess();
        }
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == ServerConfig.SPEC) {
            MercenaryManager.getMercenaryManager().resetProcessedFlag();
            MissionManager.getMissionManager().resetProcessedFlag();
            MercenaryManager.getMercenaryManager().tryProcess();
            MissionManager.getMissionManager().tryProcess();
        }
    }
}

