/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.init;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.sluggly.timemercenaries.TimeMercenaries;
import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.config.ClientConfig;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.missions.Mission;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="timemercenaries", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SoundInit {
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"timemercenaries");
    public static final RegistryObject<SoundEvent> mission_finished = SOUNDS.register("mission_finished", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("timemercenaries", "mission_finished")));
    public static final RegistryObject<SoundEvent> blue_portal_spawn = SOUNDS.register("blue_portal_spawn", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("timemercenaries", "blue_portal_spawn")));

    public static void playMissionFinishedSound(float volume, float pitch) {
        SoundInit.playSoundEffect((SoundEvent)mission_finished.get(), volume, pitch);
    }

    public static void playLevelUpSound(float volume, float pitch) {
        SoundInit.playSoundEffect(SoundEvents.f_12275_, volume, pitch);
    }

    public static void playLevelDownSound(float volume, float pitch) {
        SoundInit.playSoundEffect(SoundEvents.f_12018_, volume, pitch);
    }

    public static void playXpTickSound(float volume, float pitch) {
        SoundInit.playSoundEffect(SoundEvents.f_11871_, volume, pitch);
    }

    private static void playSoundEffect(SoundEvent event, float volume, float pitch) {
        if (!((Boolean)ClientConfig.MUTE_ALL_SOUNDS.get()).booleanValue()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            assert (player != null);
            player.m_5496_(event, volume, pitch);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<ResourceLocation> discoverMercenarySoundEventIds() {
        LinkedHashSet<ResourceLocation> ids = new LinkedHashSet<ResourceLocation>();
        String path = "/assets/timemercenaries/sounds.json";
        try (InputStream in = TimeMercenaries.class.getResourceAsStream(path);){
            if (in == null) {
                System.err.println("sounds.json not found at {}" + path);
                LinkedHashSet<ResourceLocation> linkedHashSet = ids;
                return linkedHashSet;
            }
            JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(in, StandardCharsets.UTF_8)).getAsJsonObject();
            Iterator iterator = json.keySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (!key.startsWith("mercenary.")) continue;
                ids.add(new ResourceLocation("timemercenaries", key));
            }
            return ids;
        }
        catch (Exception e) {
            System.err.println("Failed to read sounds.json for dynamic voicelines" + String.valueOf(e));
        }
        return ids;
    }

    @SubscribeEvent
    public static void onRegister(RegisterEvent event) {
        if (!event.getRegistryKey().equals((Object)ForgeRegistries.Keys.SOUND_EVENTS)) {
            return;
        }
        for (ResourceLocation id : SoundInit.discoverMercenarySoundEventIds()) {
            event.register(ForgeRegistries.Keys.SOUND_EVENTS, id, () -> SoundEvent.m_262824_((ResourceLocation)id));
        }
    }

    public static void playMercenaryVoiceline(String mercenaryName, String action) {
        if (((Boolean)ClientConfig.PLAY_MERCENARY_VOICELINES.get()).booleanValue() || ((Boolean)ClientConfig.SHOW_MERCENARY_VOICELINE_TRANSCRIPTS.get()).booleanValue()) {
            String cleanAction = action.toLowerCase();
            String cleanName = mercenaryName.toLowerCase();
            Mercenary mercenary = Mercenary.getMercenary(mercenaryName);
            if (((Boolean)ClientConfig.PLAY_MERCENARY_VOICELINES.get()).booleanValue()) {
                ResourceLocation id;
                SoundEvent evt;
                if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                    System.out.println("Playing Mercenary Sound: " + cleanAction + " for " + cleanName);
                }
                if ((evt = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(id = new ResourceLocation("timemercenaries", "mercenary." + Mission.sanitize(mercenaryName) + "." + action.toLowerCase(Locale.ROOT)))) != null) {
                    SoundInit.playSoundEffect(evt, 1.0f, 1.0f);
                }
            }
            if (((Boolean)ClientConfig.SHOW_MERCENARY_VOICELINE_TRANSCRIPTS.get()).booleanValue()) {
                if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                    System.out.println("Sending Mercenary Transcript: " + cleanAction + " for " + cleanName);
                }
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                assert (player != null);
                String transcript = mercenary.getVoicelineTranscript(action);
                if (transcript != null) {
                    MutableComponent message = Component.m_237113_((String)"<").m_7220_((Component)Component.m_237113_((String)mercenaryName).m_130948_(Style.f_131099_.m_178520_(mercenary.color))).m_7220_((Component)Component.m_237113_((String)"> ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)transcript).m_130940_(ChatFormatting.ITALIC));
                    player.m_213846_((Component)message);
                }
            }
        }
    }
}

