/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item;

import io.github.sluggly.timemercenaries.capability.PlayerCapability;
import io.github.sluggly.timemercenaries.client.KeyBindings;
import io.github.sluggly.timemercenaries.client.handler.ClientHooks;
import io.github.sluggly.timemercenaries.client.screen.dtc.AbstractDimensionalTimeClockScreen;
import io.github.sluggly.timemercenaries.compat.CuriosCompat;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.init.ItemInit;
import io.github.sluggly.timemercenaries.lore.Lore;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.network.PacketHandler;
import io.github.sluggly.timemercenaries.utils.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class DimensionalTimeClock
extends Item {
    public static HashMap<String, Integer> mapMercenaryTotalTime = new HashMap();
    public static HashMap<String, Integer> mapMercenaryTimeLeft = new HashMap();
    public static long lastUpdate = 0L;
    public static float itemPhase = 0.0f;
    public static long lastSentTick = 0L;

    public DimensionalTimeClock() {
        super(new Item.Properties().m_41487_(1));
    }

    public static float getTimeDisplay() {
        return itemPhase;
    }

    @NotNull
    public static InteractionResultHolder<ItemStack> useDimensionalTimeClock(@NotNull Player player, @NotNull InteractionHand hand) {
        PlayerData playerData = PlayerData.getPlayerData(player);
        float loreProgress = Lore.getPlayerLoreProgress(playerData);
        if (loreProgress < 1.0f) {
            PacketHandler.sendToPlayer("OpenTutorialScreen", playerData, (ServerPlayer)player);
        } else {
            String state;
            switch (state = playerData.getCurrentState()) {
                case "Recruiting": {
                    PacketHandler.sendToPlayer("OpenRecruitScreen", playerData, (ServerPlayer)player);
                    break;
                }
                case "SendingMission": {
                    PacketHandler.sendToPlayer("OpenMissionsScreen", playerData, (ServerPlayer)player);
                    break;
                }
                case "WaitingMission": {
                    PacketHandler.sendToPlayer("OpenWaitingMissionScreen", playerData, (ServerPlayer)player);
                    break;
                }
                case "EndMission": {
                    PacketHandler.sendToPlayer("OpenEndMissionScreen", playerData, (ServerPlayer)player);
                }
            }
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public static boolean playerHasClock(Player player) {
        if (Utils.hasEnoughItems((Item)ItemInit.DIMENSIONAL_TIME_CLOCK.get(), player, 1)) {
            return true;
        }
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.hasItemEquippedAsCurio(player, (Item)ItemInit.DIMENSIONAL_TIME_CLOCK.get());
        }
        return false;
    }

    public static void checkIfPlayerCanUseClock(Player player) {
        if (DimensionalTimeClock.playerHasClock(player)) {
            DimensionalTimeClock.useDimensionalTimeClock(player, player.f_20912_);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        AtomicReference resultHolder = new AtomicReference();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> resultHolder.set(DimensionalTimeClock.useDimensionalTimeClock(player, hand)));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (!level.f_46443_) {
                resultHolder.set(DimensionalTimeClock.useDimensionalTimeClock(player, hand));
            } else {
                resultHolder.set(InteractionResultHolder.m_19098_((Object)player.m_21120_(hand)));
            }
        });
        return (InteractionResultHolder)resultHolder.get();
    }

    public static void addMercenaryTimeClient(String mercenaryName, int timeLeft, int timeTotal) {
        if (!mapMercenaryTimeLeft.containsKey(mercenaryName)) {
            mapMercenaryTimeLeft.put(mercenaryName, timeLeft);
            mapMercenaryTotalTime.put(mercenaryName, timeTotal);
        }
    }

    public static void clearMercenaryTimeClient() {
        mapMercenaryTimeLeft.clear();
        mapMercenaryTotalTime.clear();
    }

    public static void addMercenaryTimeServer(Player player, String mercenaryName, int timeLeft) {
        player.getCapability(PlayerCapability.PLAYER_DATA).ifPresent(cap -> cap.getPlayerData().missionTimeLeft.put(mercenaryName, timeLeft));
    }

    private void clientTick(Level level) {
        PlayerData playerData;
        long currentTime = level.m_46467_();
        if (currentTime % 20L == 0L && (playerData = PlayerData.getPlayerData(null)) != null && !mapMercenaryTimeLeft.isEmpty() && currentTime - lastUpdate >= 20L) {
            lastUpdate = currentTime;
            int lowestTime = 9999999;
            int totalTime = 0;
            Iterator<Map.Entry<String, Integer>> iterator = mapMercenaryTimeLeft.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Integer> entry = iterator.next();
                String key = entry.getKey();
                int timeLeft = entry.getValue() - 1;
                if (timeLeft > 0) {
                    entry.setValue(timeLeft);
                    if (timeLeft >= lowestTime) continue;
                    lowestTime = timeLeft;
                    totalTime = mapMercenaryTotalTime.get(key);
                    continue;
                }
                iterator.remove();
                mapMercenaryTotalTime.remove(key);
            }
            itemPhase = (float)lowestTime / (float)totalTime;
        }
    }

    private void serverTick(Level level, Entity entity) {
        long currentTime = level.m_46467_();
        if (currentTime % 20L == 0L && entity instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(PlayerCapability.PLAYER_DATA).ifPresent(cap -> {
                PlayerData playerData = cap.getPlayerData();
                if (!playerData.missionTimeLeft.isEmpty() && currentTime - playerData.lastUpdate >= 20L) {
                    playerData.lastUpdate = currentTime;
                    boolean playFinishSound = false;
                    Iterator<Map.Entry<String, Integer>> iterator = playerData.missionTimeLeft.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<String, Integer> entry = iterator.next();
                        String mercenaryName = entry.getKey();
                        int timeLeft = entry.getValue() - 1;
                        if (timeLeft == 1) {
                            playFinishSound = true;
                        }
                        if (timeLeft > 0) {
                            entry.setValue(timeLeft);
                            MercenaryPlayerData.setMercenaryMissionTimeLeft(playerData, mercenaryName, timeLeft);
                            continue;
                        }
                        iterator.remove();
                        MercenaryPlayerData.setMercenaryMissionTimerFinish(playerData, mercenaryName);
                    }
                    if (playFinishSound) {
                        PacketHandler.sendToPlayer("PlaySoundMissionFinished", playerData, (ServerPlayer)player);
                    }
                }
            });
        }
    }

    public void m_6883_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(itemStack, level, entity, itemSlot, isSelected);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> this.serverTick(level, entity));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (level.f_46443_) {
                this.clientTick(level);
            } else {
                this.serverTick(level, entity);
            }
        });
    }

    public static void handleDimensionalTimeClockKeybind(Minecraft mc) {
        if (KeyBindings.INSTANCE.useDimensionalTimeClockKey.m_90857_()) {
            Screen currentScreen = mc.f_91080_;
            if (currentScreen instanceof AbstractDimensionalTimeClockScreen) {
                ClientHooks.closeCurrentScreen();
            } else {
                assert (mc.f_91073_ != null);
                long currentTick = mc.f_91073_.m_46467_();
                if (currentTick - lastSentTick > 30L) {
                    lastSentTick = currentTick;
                    PacketHandler.sendToServer("UseDimensionalTimeClock");
                    KeyBindings.INSTANCE.useDimensionalTimeClockKey.m_90859_();
                }
            }
        }
    }
}

