/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item;

import io.github.sluggly.timemercenaries.item.PrimalInfusion;
import io.github.sluggly.timemercenaries.item.artefacts.BeastbinderWand;
import io.github.sluggly.timemercenaries.utils.Utils;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrimalHeartwood
extends Item {
    public PrimalHeartwood(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack pStack, @NotNull Player pPlayer, @NotNull LivingEntity pInteractionTarget, @NotNull InteractionHand pUsedHand) {
        TamableAnimal tamable;
        if (pInteractionTarget.m_9236_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (pInteractionTarget instanceof TamableAnimal && (tamable = (TamableAnimal)pInteractionTarget).m_21830_((LivingEntity)pPlayer) || BeastbinderWand.isMobBound(pPlayer, (Mob)pInteractionTarget)) {
            if (Utils.removeCustomAttribute((Mob)pInteractionTarget) || this.hasPrimalInfusion(pInteractionTarget)) {
                PrimalInfusion.clearAll(pInteractionTarget);
                pInteractionTarget.m_9236_().m_5594_(null, pInteractionTarget.m_20183_(), SoundEvents.f_11998_, SoundSource.PLAYERS, 1.0f, 1.2f);
                pInteractionTarget.m_9236_().m_5594_(null, pInteractionTarget.m_20183_(), SoundEvents.f_11697_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!pPlayer.m_150110_().f_35937_) {
                    pStack.m_41774_(1);
                }
                pPlayer.m_213846_((Component)Component.m_237113_((String)("The Primal Infusion has been cleansed from " + pInteractionTarget.m_7755_().getString())).m_130940_(ChatFormatting.GREEN));
                return InteractionResult.CONSUME;
            }
            pPlayer.m_213846_((Component)Component.m_237113_((String)(pInteractionTarget.m_7755_().getString() + " does not have a Primal Infusion to cleanse.")).m_130940_(ChatFormatting.RED));
            return InteractionResult.FAIL;
        }
        pPlayer.m_213846_((Component)Component.m_237113_((String)"This can only be used on your own pets.").m_130940_(ChatFormatting.YELLOW));
        return InteractionResult.PASS;
    }

    private boolean hasPrimalInfusion(LivingEntity entity) {
        return Objects.requireNonNull(entity.m_21051_(Attributes.f_22276_)).m_22111_(PrimalInfusion.PRIMAL_INFUSION_UPGRADE_UUID) != null || Objects.requireNonNull(entity.m_21051_(Attributes.f_22281_)).m_22111_(PrimalInfusion.PRIMAL_INFUSION_UPGRADE_UUID) != null || Objects.requireNonNull(entity.m_21051_(Attributes.f_22284_)).m_22111_(PrimalInfusion.PRIMAL_INFUSION_UPGRADE_UUID) != null || Objects.requireNonNull(entity.m_21051_(Attributes.f_22285_)).m_22111_(PrimalInfusion.PRIMAL_INFUSION_UPGRADE_UUID) != null || Objects.requireNonNull(entity.m_21051_(Attributes.f_22279_)).m_22111_(PrimalInfusion.PRIMAL_INFUSION_UPGRADE_UUID) != null || Objects.requireNonNull(entity.m_21051_(Attributes.f_22283_)).m_22111_(PrimalInfusion.PRIMAL_INFUSION_UPGRADE_UUID) != null || Objects.requireNonNull(entity.m_21051_(Attributes.f_22278_)).m_22111_(PrimalInfusion.PRIMAL_INFUSION_UPGRADE_UUID) != null || Objects.requireNonNull(entity.m_21051_(Attributes.f_22282_)).m_22111_(PrimalInfusion.PRIMAL_INFUSION_UPGRADE_UUID) != null || ForgeMod.STEP_HEIGHT_ADDITION.isPresent() && Objects.requireNonNull(entity.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get())).m_22111_(PrimalInfusion.PRIMAL_INFUSION_UPGRADE_UUID) != null;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.primal_heartwood.effect").m_130940_(ChatFormatting.GOLD));
    }
}

