/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item;

import com.google.common.collect.Multimap;
import io.github.sluggly.timemercenaries.item.artefacts.GolemancersCore;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefiningStone
extends Item {
    public static final UUID BLACKSMITH_UPGRADE_UUID = UUID.fromString("115e6b2a-8432-42eb-9cb4-123d797da100");
    public static final String BLACKSMITH_UPGRADE_NAME = "Hestra Infusion";

    public RefiningStone(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        return this.m_7203_(pContext.m_43725_(), Objects.requireNonNull(pContext.m_43723_()), pContext.m_43724_()).m_19089_();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack stoneStack = pPlayer.m_21120_(pUsedHand);
        ItemStack targetStack = pPlayer.m_21120_(pUsedHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        if (targetStack.m_41613_() > 1) {
            if (!pLevel.f_46443_) {
                pPlayer.m_213846_((Component)Component.m_237113_((String)"The Refining Stone can only be used on a single item, not a stack.").m_130940_(ChatFormatting.RED));
            }
            return InteractionResultHolder.m_19100_((Object)stoneStack);
        }
        if (targetStack.m_41619_()) {
            if (!pLevel.f_46443_) {
                pPlayer.m_213846_((Component)Component.m_237113_((String)"You must hold the item to upgrade in your main or off-hand.").m_130940_(ChatFormatting.RED));
            }
            return InteractionResultHolder.m_19100_((Object)stoneStack);
        }
        if (targetStack.m_41720_() instanceof RefiningStone) {
            if (!pLevel.f_46443_) {
                pPlayer.m_213846_((Component)Component.m_237113_((String)"You can't refine this item.").m_130940_(ChatFormatting.RED));
            }
            return InteractionResultHolder.m_19100_((Object)stoneStack);
        }
        if (targetStack.m_41720_() instanceof GolemancersCore) {
            if (!pLevel.f_46443_) {
                int currentInfusions = GolemancersCore.getInfusionCount(targetStack);
                GolemancersCore.setInfusionCount(targetStack, currentInfusions + 1);
                pLevel.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_11671_, SoundSource.PLAYERS, 1.0f, 0.8f);
                pLevel.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_144243_, SoundSource.PLAYERS, 1.0f, 1.5f);
                if (!pPlayer.m_7500_()) {
                    stoneStack.m_41774_(1);
                }
                pPlayer.m_213846_((Component)Component.m_237113_((String)("The Golemancer's Core resonates with power! Infusion Level: " + (currentInfusions + 1))).m_130940_(ChatFormatting.GREEN));
            }
            return InteractionResultHolder.m_19092_((Object)stoneStack, (boolean)pLevel.m_5776_());
        }
        if (!pLevel.f_46443_) {
            EquipmentSlot slot;
            Item item = targetStack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armor = (ArmorItem)item;
                slot = armor.m_40402_();
            } else {
                slot = pUsedHand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            }
            CompoundTag stoneTag = stoneStack.m_41783_();
            if (stoneTag == null || !stoneTag.m_128425_("AttributeModifiers", 9)) {
                pPlayer.m_213846_((Component)Component.m_237113_((String)"This refining stone is inert.").m_130940_(ChatFormatting.RED));
                return InteractionResultHolder.m_19100_((Object)stoneStack);
            }
            this.clearAllUpgrades(targetStack);
            if (!RefiningStone.hasAttrList(targetStack)) {
                Multimap base = targetStack.m_41638_(slot);
                for (Map.Entry e : base.entries()) {
                    targetStack.m_41643_((Attribute)e.getKey(), (AttributeModifier)e.getValue(), slot);
                }
            }
            this.addInfusionTooltip(targetStack);
            Multimap modifiers = stoneStack.m_41638_(EquipmentSlot.OFFHAND);
            for (Map.Entry entry : modifiers.entries()) {
                AttributeModifier.Operation operation = ((AttributeModifier)entry.getValue()).m_22217_();
                AttributeModifier modifier = new AttributeModifier(BLACKSMITH_UPGRADE_UUID, BLACKSMITH_UPGRADE_NAME, ((AttributeModifier)entry.getValue()).m_22218_(), operation);
                targetStack.m_41643_((Attribute)entry.getKey(), modifier, slot);
            }
            pLevel.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_11671_, SoundSource.PLAYERS, 1.0f, 1.2f);
            if (!pPlayer.m_150110_().f_35937_) {
                stoneStack.m_41774_(1);
            }
        }
        return InteractionResultHolder.m_19092_((Object)stoneStack, (boolean)pLevel.m_5776_());
    }

    private void clearAllUpgrades(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_("AttributeModifiers", 9)) {
            return;
        }
        ListTag oldList = tag.m_128437_("AttributeModifiers", 10);
        ListTag newList = new ListTag();
        for (int i = 0; i < oldList.size(); ++i) {
            CompoundTag modifierTag = oldList.m_128728_(i);
            UUID uuid = NbtUtils.m_129233_((Tag)Objects.requireNonNull(modifierTag.m_128423_("UUID")));
            if (BLACKSMITH_UPGRADE_UUID.equals(uuid)) continue;
            newList.add((Object)modifierTag);
        }
        if (newList.isEmpty()) {
            tag.m_128473_("AttributeModifiers");
            if (tag.m_128456_()) {
                stack.m_41751_(null);
            }
        } else {
            tag.m_128365_("AttributeModifiers", (Tag)newList);
        }
    }

    private static boolean hasAttrList(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128425_("AttributeModifiers", 9);
    }

    private void addInfusionTooltip(ItemStack stack) {
        this.clearInfusionTooltip(stack);
        CompoundTag displayTag = stack.m_41698_("display");
        ListTag loreList = displayTag.m_128437_("Lore", 8);
        MutableComponent loreComponent = Component.m_237113_((String)BLACKSMITH_UPGRADE_NAME).m_130940_(ChatFormatting.GOLD);
        String loreJson = Component.Serializer.m_130703_((Component)loreComponent);
        loreList.add((Object)StringTag.m_129297_((String)loreJson));
        displayTag.m_128365_("Lore", (Tag)loreList);
    }

    private void clearInfusionTooltip(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41784_().m_128441_("display")) {
            return;
        }
        CompoundTag displayTag = stack.m_41737_("display");
        assert (displayTag != null);
        if (!displayTag.m_128425_("Lore", 9)) {
            return;
        }
        ListTag oldLore = displayTag.m_128437_("Lore", 8);
        ListTag newLore = new ListTag();
        MutableComponent infusionComponent = Component.m_237113_((String)BLACKSMITH_UPGRADE_NAME).m_130940_(ChatFormatting.GOLD);
        String infusionJson = Component.Serializer.m_130703_((Component)infusionComponent);
        for (int i = 0; i < oldLore.size(); ++i) {
            if (oldLore.m_128778_(i).equals(infusionJson)) continue;
            newLore.add((Object)oldLore.get(i));
        }
        if (newLore.isEmpty()) {
            displayTag.m_128473_("Lore");
            if (displayTag.m_128456_()) {
                stack.m_41749_("display");
            }
        } else {
            displayTag.m_128365_("Lore", (Tag)newLore);
        }
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.refining_stone").m_130940_(ChatFormatting.GOLD));
    }
}

