/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item;

import io.github.sluggly.timemercenaries.item.RefiningStone;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StoneOfCleansing
extends Item {
    public StoneOfCleansing(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack cleansingStoneStack = pPlayer.m_21120_(pUsedHand);
        ItemStack targetStack = pPlayer.m_21120_(pUsedHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        if (targetStack.m_41619_()) {
            if (!pLevel.f_46443_) {
                pPlayer.m_213846_((Component)Component.m_237113_((String)"Hold the item to cleanse in your other hand.").m_130940_(ChatFormatting.YELLOW));
            }
            return InteractionResultHolder.m_19100_((Object)cleansingStoneStack);
        }
        if (!pLevel.f_46443_) {
            if (this.hasInfusion(targetStack)) {
                this.clearAllUpgrades(targetStack);
                this.clearInfusionTooltip(targetStack);
                pLevel.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_11998_, SoundSource.PLAYERS, 1.0f, 0.8f);
                pLevel.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_144243_, SoundSource.PLAYERS, 0.7f, 1.5f);
                if (!pPlayer.m_150110_().f_35937_) {
                    cleansingStoneStack.m_41774_(1);
                }
                pPlayer.m_213846_((Component)Component.m_237113_((String)"The Hestra Infusion has been cleansed from your item!").m_130940_(ChatFormatting.GREEN));
                return InteractionResultHolder.m_19090_((Object)cleansingStoneStack);
            }
            pPlayer.m_213846_((Component)Component.m_237113_((String)"This item has no Hestra Infusion to cleanse.").m_130940_(ChatFormatting.RED));
            return InteractionResultHolder.m_19100_((Object)cleansingStoneStack);
        }
        return InteractionResultHolder.m_19092_((Object)cleansingStoneStack, (boolean)pLevel.m_5776_());
    }

    private boolean hasInfusion(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_("AttributeModifiers", 9)) {
            return false;
        }
        ListTag list = tag.m_128437_("AttributeModifiers", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag modifierTag = list.m_128728_(i);
            UUID uuid = NbtUtils.m_129233_((Tag)modifierTag.m_128423_("UUID"));
            if (!RefiningStone.BLACKSMITH_UPGRADE_UUID.equals(uuid)) continue;
            return true;
        }
        return false;
    }

    private void clearAllUpgrades(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128425_("AttributeModifiers", 9)) {
            return;
        }
        ListTag oldList = tag.m_128437_("AttributeModifiers", 10);
        ListTag newList = new ListTag();
        for (int i = 0; i < oldList.size(); ++i) {
            CompoundTag modifierTag = oldList.m_128728_(i);
            UUID uuid = NbtUtils.m_129233_((Tag)Objects.requireNonNull(modifierTag.m_128423_("UUID")));
            if (RefiningStone.BLACKSMITH_UPGRADE_UUID.equals(uuid)) continue;
            newList.add((Object)modifierTag);
        }
        if (newList.isEmpty()) {
            tag.m_128473_("AttributeModifiers");
            if (tag.m_128456_()) {
                stack.m_41751_(null);
            }
        } else {
            tag.m_128365_("AttributeModifiers", (Tag)newList);
        }
    }

    private void clearInfusionTooltip(ItemStack stack) {
        if (!stack.m_41782_() || !stack.m_41784_().m_128441_("display")) {
            return;
        }
        CompoundTag displayTag = stack.m_41737_("display");
        if (displayTag == null || !displayTag.m_128425_("Lore", 9)) {
            return;
        }
        ListTag oldLore = displayTag.m_128437_("Lore", 8);
        ListTag newLore = new ListTag();
        MutableComponent infusionComponent = Component.m_237113_((String)"Hestra Infusion").m_130940_(ChatFormatting.GOLD);
        String infusionJson = Component.Serializer.m_130703_((Component)infusionComponent);
        for (int i = 0; i < oldLore.size(); ++i) {
            if (oldLore.m_128778_(i).equals(infusionJson)) continue;
            newLore.add((Object)oldLore.get(i));
        }
        if (newLore.isEmpty()) {
            displayTag.m_128473_("Lore");
            if (displayTag.m_128456_()) {
                stack.m_41749_("display");
            }
        } else {
            displayTag.m_128365_("Lore", (Tag)newLore);
        }
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.stone_of_cleansing.effect").m_130940_(ChatFormatting.GOLD));
    }
}

