/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import io.github.sluggly.timemercenaries.capability.PetCompanionCapability;
import io.github.sluggly.timemercenaries.entity.goal.PetGoal;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeastbinderWand
extends Item {
    public BeastbinderWand(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack stack, @NotNull Player player, @NotNull LivingEntity target, @NotNull InteractionHand hand) {
        if (!(target instanceof Mob)) {
            return InteractionResult.PASS;
        }
        Mob mob = (Mob)target;
        if (!(mob instanceof Animal)) {
            return InteractionResult.PASS;
        }
        if (player.m_9236_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        PetCompanionCapability.IPetCompanion cap = PetCompanionCapability.get((Entity)mob).orElse(null);
        if (cap == null) {
            return InteractionResult.PASS;
        }
        if (cap.isPet() && player.m_20148_().equals(cap.getOwner())) {
            boolean sit = !cap.isSitting();
            cap.setSitting(sit);
            mob.m_21573_().m_26573_();
            player.m_9236_().m_5594_(null, mob.m_20183_(), sit ? SoundEvents.f_12625_ : SoundEvents.f_12623_, SoundSource.PLAYERS, 0.7f, 1.0f);
            player.m_5661_((Component)Component.m_237113_((String)(sit ? "Sit." : "Follow!")).m_130940_(ChatFormatting.GRAY), true);
            return InteractionResult.CONSUME;
        }
        if (!cap.isPet()) {
            cap.setPet(true);
            cap.setOwner(player.m_20148_());
            cap.setSitting(false);
            mob.m_21530_();
            PetGoal.attachPetGoals(mob);
            player.m_9236_().m_5594_(null, mob.m_20183_(), SoundEvents.f_144243_, SoundSource.PLAYERS, 0.8f, 1.2f);
            player.m_5661_((Component)Component.m_237113_((String)"You have bonded with this creature.").m_130940_(ChatFormatting.AQUA), true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public static Player getBoundPetOwner(Entity entity) {
        return PetCompanionCapability.get(entity).map(p -> p.getOwner() == null ? null : entity.m_9236_().m_46003_(p.getOwner())).orElse(null);
    }

    public static boolean isMobBound(Player player, Mob mob) {
        UUID pid = player.m_20148_();
        Optional<PetCompanionCapability.IPetCompanion> cap = PetCompanionCapability.get((Entity)mob);
        if (cap.isPresent()) {
            UUID owner = cap.orElseThrow().getOwner();
            return owner != null && owner.equals(pid);
        }
        return false;
    }

    public static void handleBeastbinderWandSitClick(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        PetCompanionCapability.get((Entity)mob).ifPresent(cap -> {
            if (cap.isPet() && event.getEntity().m_20148_().equals(cap.getOwner()) && event.getItemStack().m_41619_()) {
                cap.setSitting(!cap.isSitting());
                mob.m_21573_().m_26573_();
                event.getLevel().m_5594_(null, mob.m_20183_(), cap.isSitting() ? SoundEvents.f_12625_ : SoundEvents.f_12623_, SoundSource.PLAYERS, 0.7f, 1.0f);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.CONSUME);
            }
        });
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.beastbinder_wand.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.beastbinder_wand.flavor").m_130940_(ChatFormatting.RED));
    }
}

