/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import io.github.sluggly.timemercenaries.capability.PlayerCapability;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.item.ModArmorMaterials;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.network.PacketHandler;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.TradeWithVillagerEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CapOfCommerce
extends ArmorItem {
    public static final int MAX_COINS_PER_DAY = 10;

    public CapOfCommerce(Item.Properties pProperties) {
        super((ArmorMaterial)ModArmorMaterials.TRADER, ArmorItem.Type.HELMET, pProperties);
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        PlayerData playerData;
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.cap_of_commerce.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.cap_of_commerce.flavor").m_130940_(ChatFormatting.GOLD));
        if (pLevel != null && pLevel.m_5776_() && (playerData = PlayerData.getPlayerData(null)) != null) {
            long currentDay = pLevel.m_46468_() / 24000L;
            long lastTradeDay = playerData.getPlayerInformation().m_128454_("HatLastTradeDay");
            int coinCount = playerData.getPlayerInformation().m_128451_("HatCoinCount");
            int coinsEarnedToday = currentDay == lastTradeDay ? coinCount : 0;
            ChatFormatting color = coinsEarnedToday >= 10 ? ChatFormatting.RED : ChatFormatting.GREEN;
            pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.timemercenaries.cap_of_commerce.progress", (Object[])new Object[]{coinsEarnedToday, 10}).m_130940_(color));
        }
    }

    public static void handleCapOfCommerceEffect(TradeWithVillagerEvent event) {
        Player player = event.getEntity();
        ItemStack headSlotItem = player.m_6844_(EquipmentSlot.HEAD);
        if (!(headSlotItem.m_41720_() instanceof CapOfCommerce)) {
            return;
        }
        player.getCapability(PlayerCapability.PLAYER_DATA).ifPresent(cap -> {
            PlayerData playerData = cap.getPlayerData();
            CompoundTag playerInfo = playerData.getPlayerInformation();
            long currentDay = player.m_9236_().m_46468_() / 24000L;
            long lastTradeDay = playerInfo.m_128454_("HatLastTradeDay");
            int coinCount = playerInfo.m_128451_("HatCoinCount");
            if (currentDay > lastTradeDay) {
                coinCount = 0;
            }
            if (coinCount < 10) {
                MercenaryPlayerData.addMercenaryCoins(playerData, "Vael", 1);
                playerInfo.m_128356_("HatLastTradeDay", currentDay);
                playerInfo.m_128405_("HatCoinCount", ++coinCount);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.m_6330_(SoundEvents.f_11871_, SoundSource.PLAYERS, 0.5f, 1.0f);
                    serverPlayer.m_240418_((Component)Component.m_237110_((String)"feedback.timemercenaries.cap_of_commerce.progress", (Object[])new Object[]{coinCount, 10}).m_130940_(ChatFormatting.GOLD), true);
                    PacketHandler.sendToPlayer("RefreshData", playerData, serverPlayer);
                }
            }
        });
    }
}

