/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import io.github.sluggly.timemercenaries.entity.projectile.ChainProjectile;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChainsOfSupremacy
extends Item {
    private static final String TAG_CAPTURED_DATA = "CapturedEntityData";
    private static final String TAG_CAPTURED_ID = "CapturedEntityID";

    public ChainsOfSupremacy(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack heldStack = pPlayer.m_21120_(pUsedHand);
        if (heldStack.m_41782_() && Objects.requireNonNull(heldStack.m_41783_()).m_128441_(TAG_CAPTURED_DATA)) {
            if (!pLevel.f_46443_) {
                this.releaseEntity(pLevel, pPlayer, heldStack);
            }
            pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11794_, SoundSource.PLAYERS, 0.7f, 1.0f);
            pPlayer.m_36335_().m_41524_((Item)this, 20);
        } else {
            if (!pLevel.f_46443_) {
                ChainProjectile projectile = new ChainProjectile(pLevel, (LivingEntity)pPlayer);
                projectile.m_37251_((Entity)pPlayer, pPlayer.m_146909_(), pPlayer.m_146908_(), 0.0f, 1.5f, 1.0f);
                pLevel.m_7967_((Entity)projectile);
            }
            pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11745_, SoundSource.PLAYERS, 1.0f, 1.0f);
            pPlayer.m_36335_().m_41524_((Item)this, 200);
        }
        return InteractionResultHolder.m_19090_((Object)heldStack);
    }

    public static void captureEntity(ItemStack stack, LivingEntity entity) {
        if (!(stack.m_41720_() instanceof ChainsOfSupremacy)) {
            return;
        }
        CompoundTag itemTag = stack.m_41784_();
        CompoundTag entityData = entity.m_20240_(new CompoundTag());
        entityData.m_128350_("Health", entity.m_21233_());
        if (entityData.m_128441_("Removed")) {
            entityData.m_128473_("Removed");
        }
        itemTag.m_128365_(TAG_CAPTURED_DATA, (Tag)entityData);
        ResourceLocation entityId = EntityType.m_20613_((EntityType)entity.m_6095_());
        itemTag.m_128359_(TAG_CAPTURED_ID, entityId.toString());
    }

    private void releaseEntity(Level level, Player player, ItemStack stack) {
        CompoundTag itemTag = stack.m_41783_();
        if (itemTag == null || !itemTag.m_128441_(TAG_CAPTURED_ID)) {
            return;
        }
        Optional entityTypeOptional = EntityType.m_20632_((String)itemTag.m_128461_(TAG_CAPTURED_ID));
        if (entityTypeOptional.isPresent()) {
            EntityType entityType = (EntityType)entityTypeOptional.get();
            CompoundTag entityData = itemTag.m_128469_(TAG_CAPTURED_DATA);
            Entity spawnedEntity = entityType.m_20615_(level);
            if (spawnedEntity != null) {
                spawnedEntity.m_20258_(entityData);
                Vec3 pos = player.m_146892_().m_82549_(player.m_20154_().m_82490_(1.5));
                spawnedEntity.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                level.m_7967_(spawnedEntity);
            }
        }
        itemTag.m_128473_(TAG_CAPTURED_DATA);
        itemTag.m_128473_(TAG_CAPTURED_ID);
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        if (!pStack.m_41782_()) {
            return false;
        }
        assert (pStack.m_41783_() != null);
        return pStack.m_41783_().m_128441_(TAG_CAPTURED_DATA);
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.chains_of_supremacy.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.chains_of_supremacy.flavor").m_130940_(ChatFormatting.GOLD));
        if (pStack.m_41782_()) {
            assert (pStack.m_41783_() != null);
            if (pStack.m_41783_().m_128441_(TAG_CAPTURED_ID)) {
                String entityId = pStack.m_41783_().m_128461_(TAG_CAPTURED_ID);
                Optional entityType = EntityType.m_20632_((String)entityId);
                entityType.ifPresent(type -> pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.timemercenaries.chains_of_supremacy.captured", (Object[])new Object[]{type.m_20676_()}).m_130940_(ChatFormatting.GREEN)));
            }
        }
    }
}

