/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.sluggly.timemercenaries.init.ItemInit;
import io.github.sluggly.timemercenaries.item.ModArmorMaterials;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.OptionalDouble;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HelmOfTheFirstExplorer
extends ArmorItem {
    private static final int SCAN_RADIUS = 20;
    private static final int CHECK_INTERVAL_TICKS = 300;
    private static final int HIGHLIGHT_DURATION_TICKS = 60;
    public static List<BlockPos> positionsToHighlight = Collections.emptyList();
    private static long highlightStartTime = -1L;

    public HelmOfTheFirstExplorer(Item.Properties pProperties) {
        super((ArmorMaterial)ModArmorMaterials.TRADER, ArmorItem.Type.HELMET, pProperties);
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.helm_of_the_first_explorer.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.helm_of_the_first_explorer.flavor").m_130940_(ChatFormatting.GOLD));
    }

    public static void handleClientHelmOfTheFirstExplorerHighlight(Minecraft mc) {
        assert (mc.f_91073_ != null);
        if (highlightStartTime != -1L && mc.f_91073_.m_46467_() > highlightStartTime + 60L) {
            positionsToHighlight = Collections.emptyList();
            highlightStartTime = -1L;
        }
        assert (mc.f_91074_ != null);
        if (mc.f_91074_.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ItemInit.HELM_OF_THE_FIRST_EXPLORER.get())) {
            if (mc.f_91074_.f_19797_ % 300 == 0) {
                ArrayList<BlockPos> foundChests = new ArrayList<BlockPos>();
                BlockPos playerPos = mc.f_91074_.m_20183_();
                for (BlockPos pos : BlockPos.m_121940_((BlockPos)playerPos.m_7918_(-20, -20, -20), (BlockPos)playerPos.m_7918_(20, 20, 20))) {
                    if (!(mc.f_91073_.m_7702_(pos) instanceof RandomizableContainerBlockEntity)) continue;
                    foundChests.add(pos.m_7949_());
                }
                if (!foundChests.isEmpty()) {
                    positionsToHighlight = foundChests;
                    highlightStartTime = mc.f_91073_.m_46467_();
                }
            }
        } else {
            positionsToHighlight = Collections.emptyList();
            highlightStartTime = -1L;
        }
    }

    public static void handleHelmOfTheFirstExplorerRendering(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && !positionsToHighlight.isEmpty()) {
            Minecraft mc = Minecraft.m_91087_();
            PoseStack poseStack = event.getPoseStack();
            Vec3 camera = mc.f_91063_.m_109153_().m_90583_();
            MultiBufferSource.BufferSource bufferSource = mc.m_91269_().m_110104_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            VertexConsumer consumer = bufferSource.m_6299_(CustomRenderTypes.BOX_LINES);
            RenderSystem.disableDepthTest();
            poseStack.m_85836_();
            poseStack.m_85837_(-camera.f_82479_, -camera.f_82480_, -camera.f_82481_);
            for (BlockPos pos : positionsToHighlight) {
                LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1), (float)0.9f, (float)0.7f, (float)0.2f, (float)1.0f);
            }
            poseStack.m_85849_();
            bufferSource.m_109912_(CustomRenderTypes.BOX_LINES);
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
        }
    }

    private static class CustomRenderTypes
    extends RenderType {
        private static final RenderStateShard.LineStateShard THICK_LINES = new RenderStateShard.LineStateShard(OptionalDouble.of(2.5));
        public static final RenderType BOX_LINES = CustomRenderTypes.m_173215_((String)"tm_box_lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(THICK_LINES).m_110669_(f_110119_).m_110685_(f_110139_).m_110675_(f_110129_).m_110687_(f_110115_).m_110661_(f_110110_).m_110663_(f_110111_).m_110691_(false));

        private CustomRenderTypes(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, Runnable pSetupState, Runnable pClearState) {
            super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, pSetupState, pClearState);
        }
    }
}

