/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HydroGemOfEvergrowth
extends Item {
    private static final int EFFECT_RADIUS = 4;
    private static final int COOLDOWN_TICKS = 400;

    public HydroGemOfEvergrowth(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack heldStack = pPlayer.m_21120_(pUsedHand);
        if (!pLevel.f_46443_ && pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            BlockPos centerPos = pPlayer.m_20183_();
            int blocksAffected = 0;
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)centerPos.m_7918_(-4, -1, -4), (BlockPos)centerPos.m_7918_(4, 1, 4))) {
                BonemealableBlock growable;
                BlockState blockState = serverLevel.m_8055_(pos);
                Block block = blockState.m_60734_();
                if (!(block instanceof BonemealableBlock) || !(growable = (BonemealableBlock)block).m_7370_((LevelReader)serverLevel, pos, blockState, false)) continue;
                growable.m_214148_(serverLevel, serverLevel.f_46441_, pos, blockState);
                ++blocksAffected;
            }
            if (blocksAffected > 0) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, pPlayer.m_20185_(), pPlayer.m_20186_() + 1.0, pPlayer.m_20189_(), blocksAffected, 4.0, 1.0, 4.0, 0.1);
                pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_12275_, SoundSource.PLAYERS, 0.5f, 1.5f);
                pPlayer.m_36335_().m_41524_((Item)this, 400);
                return InteractionResultHolder.m_19090_((Object)heldStack);
            }
            pLevel.m_6263_(null, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), SoundEvents.f_11797_, SoundSource.PLAYERS, 0.5f, 1.5f);
            return InteractionResultHolder.m_19100_((Object)heldStack);
        }
        return InteractionResultHolder.m_19098_((Object)heldStack);
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.hydro_gem_of_evergrowth.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.hydro_gem_of_evergrowth.flavor").m_130940_(ChatFormatting.AQUA));
    }
}

