/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OceanSoul
extends Item {
    private static final int COOLDOWN = 2;

    public OceanSoul(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack heldStack = pPlayer.m_21120_(pUsedHand);
        BlockHitResult hitResult = OceanSoul.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)heldStack);
        }
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            Direction targetDirection;
            BlockPos targetPos = hitResult.m_82425_();
            BlockPos placePos = targetPos.m_121945_(targetDirection = hitResult.m_82434_());
            if (!pLevel.m_7966_(pPlayer, placePos) || !pPlayer.m_36204_(placePos, targetDirection, heldStack)) {
                return InteractionResultHolder.m_19100_((Object)heldStack);
            }
            if (!pLevel.f_46443_) {
                pLevel.m_7731_(placePos, Blocks.f_49990_.m_49966_(), 11);
                pLevel.m_5594_(null, placePos, SoundEvents.f_11778_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (pLevel.f_46441_.m_188503_(15) == 0) {
                    this.spawnRandomOceanMob((ServerLevel)pLevel, placePos);
                }
            }
            pPlayer.m_36335_().m_41524_((Item)this, 2);
            return InteractionResultHolder.m_19090_((Object)heldStack);
        }
        return InteractionResultHolder.m_19098_((Object)heldStack);
    }

    private void spawnRandomOceanMob(ServerLevel pLevel, BlockPos pPos) {
        List<EntityType> oceanMobs = List.of(EntityType.f_20480_, EntityType.f_147034_, EntityType.f_20556_, EntityType.f_20519_, EntityType.f_20489_, EntityType.f_20516_, EntityType.f_20490_, EntityType.f_20559_, EntityType.f_217013_, EntityType.f_147039_);
        EntityType toSpawn = oceanMobs.get(pLevel.f_46441_.m_188503_(oceanMobs.size()));
        toSpawn.m_262496_(pLevel, pPos, MobSpawnType.BUCKET);
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.ocean_soul.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.ocean_soul.flavor").m_130940_(ChatFormatting.AQUA));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

