/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrimordialGrowthMoss
extends Item {
    private static final int COOLDOWN = 20;
    private static final List<WeightedOre> ORE_CHOICES = List.of(new WeightedOre(Blocks.f_49997_, 40), new WeightedOre(Blocks.f_49996_, 35), new WeightedOre(Blocks.f_152505_, 30), new WeightedOre(Blocks.f_50059_, 15), new WeightedOre(Blocks.f_50173_, 15), new WeightedOre(Blocks.f_49995_, 10), new WeightedOre(Blocks.f_50264_, 4), new WeightedOre(Blocks.f_50089_, 2));

    public PrimordialGrowthMoss(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        BlockPos clickedPos = pContext.m_8083_();
        BlockState clickedState = level.m_8055_(clickedPos);
        Player player = pContext.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (clickedState.m_204336_(BlockTags.f_144266_) || clickedState.m_204336_(BlockTags.f_144267_)) {
            if (!level.f_46443_) {
                Block oreToPlace = this.getRandomOre();
                level.m_7731_(clickedPos, oreToPlace.m_49966_(), 11);
                level.m_5594_(null, clickedPos, SoundEvents.f_144243_, SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
                player.m_36335_().m_41524_((Item)this, 20);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private Block getRandomOre() {
        Random random = new Random();
        int totalWeight = ORE_CHOICES.stream().mapToInt(o -> o.weight).sum();
        int randomWeight = random.nextInt(totalWeight);
        int currentWeight = 0;
        for (WeightedOre ore : ORE_CHOICES) {
            if (randomWeight >= (currentWeight += ore.weight)) continue;
            return ore.block;
        }
        return Blocks.f_49997_;
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.primordial_growth_moss.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.primordial_growth_moss.flavor").m_130940_(ChatFormatting.GRAY));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    private record WeightedOre(Block block, int weight) {
    }
}

