/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TomeOfSynthesis
extends Item {
    private static final int XP_COST = 10;
    private static final int COOLDOWN_TICKS = 100;
    private static final String TAG_STORED_ENCHANTS = "StoredEnchantments";

    public TomeOfSynthesis(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack tomeStack = pPlayer.m_21120_(pUsedHand);
        InteractionHand otherHand = pUsedHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack otherStack = pPlayer.m_21120_(otherHand);
        if (otherStack.m_41619_()) {
            if (!pLevel.f_46443_) {
                pPlayer.m_213846_((Component)Component.m_237113_((String)"The other hand must hold an item.").m_130940_(ChatFormatting.RED));
            }
            return InteractionResultHolder.m_19100_((Object)tomeStack);
        }
        if (!pPlayer.m_7500_() && pPlayer.f_36078_ < 10) {
            if (!pLevel.f_46443_) {
                pPlayer.m_213846_((Component)Component.m_237113_((String)"Not enough experience levels.").m_130940_(ChatFormatting.RED));
            }
            return InteractionResultHolder.m_19100_((Object)tomeStack);
        }
        boolean tomeHasEnchants = tomeStack.m_41782_() && tomeStack.m_41784_().m_128441_(TAG_STORED_ENCHANTS);
        boolean otherHasEnchants = otherStack.m_41793_();
        if (!tomeHasEnchants && otherHasEnchants) {
            if (!pLevel.f_46443_) {
                this.absorbEnchantments(pPlayer, tomeStack, otherStack);
            }
            this.playSuccessSound(pLevel, pPlayer);
            return InteractionResultHolder.m_19090_((Object)tomeStack);
        }
        if (tomeHasEnchants && !otherHasEnchants) {
            if (!pLevel.f_46443_) {
                this.applyEnchantments(pPlayer, tomeStack, otherStack);
            }
            this.playSuccessSound(pLevel, pPlayer);
            return InteractionResultHolder.m_19090_((Object)tomeStack);
        }
        if (!pLevel.f_46443_) {
            if (tomeHasEnchants) {
                pPlayer.m_213846_((Component)Component.m_237113_((String)"Both items are enchanted. Cannot synthesize.").m_130940_(ChatFormatting.RED));
            } else {
                pPlayer.m_213846_((Component)Component.m_237113_((String)"Neither item is enchanted.").m_130940_(ChatFormatting.RED));
            }
        }
        pLevel.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_11797_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResultHolder.m_19100_((Object)tomeStack);
    }

    private void absorbEnchantments(Player player, ItemStack tomeStack, ItemStack sourceStack) {
        ListTag enchantments = sourceStack.m_41785_();
        if (enchantments.isEmpty()) {
            return;
        }
        tomeStack.m_41784_().m_128365_(TAG_STORED_ENCHANTS, (Tag)enchantments.m_6426_());
        if (sourceStack.m_41783_() != null) {
            sourceStack.m_41783_().m_128365_("Enchantments", (Tag)new ListTag());
        }
        if (!player.m_7500_()) {
            player.m_6749_(-10);
        }
        player.m_36335_().m_41524_((Item)this, 100);
    }

    private void applyEnchantments(Player player, ItemStack tomeStack, ItemStack targetStack) {
        CompoundTag tomeTag = tomeStack.m_41783_();
        if (tomeTag == null || !tomeTag.m_128441_(TAG_STORED_ENCHANTS)) {
            return;
        }
        if (!targetStack.m_41792_()) {
            player.m_213846_((Component)Component.m_237113_((String)"This item cannot be enchanted.").m_130940_(ChatFormatting.RED));
            player.m_6330_(SoundEvents.f_11797_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return;
        }
        ListTag storedEnchants = tomeTag.m_128437_(TAG_STORED_ENCHANTS, 10);
        Map enchantsToApply = EnchantmentHelper.m_44882_((ListTag)storedEnchants);
        for (Enchantment enchant : enchantsToApply.keySet()) {
            if (enchant.m_6081_(targetStack)) continue;
            player.m_213846_((Component)Component.m_237113_((String)("Cannot apply " + enchant.m_44700_(1).getString() + " to this item.")).m_130940_(ChatFormatting.RED));
            player.m_6330_(SoundEvents.f_11797_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return;
        }
        EnchantmentHelper.m_44865_((Map)enchantsToApply, (ItemStack)targetStack);
        tomeTag.m_128473_(TAG_STORED_ENCHANTS);
        if (!player.m_7500_()) {
            player.m_6749_(-10);
        }
        player.m_36335_().m_41524_((Item)this, 100);
    }

    private void playSuccessSound(Level level, Player player) {
        level.m_5594_(null, player.m_20183_(), SoundEvents.f_11887_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        if (!pStack.m_41782_()) {
            return false;
        }
        assert (pStack.m_41783_() != null);
        return pStack.m_41783_().m_128441_(TAG_STORED_ENCHANTS);
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.tome_of_synthesis.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.tome_of_synthesis.flavor").m_130940_(ChatFormatting.DARK_PURPLE));
        pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.timemercenaries.tome_of_synthesis.cost", (Object[])new Object[]{10}).m_130940_(ChatFormatting.RED));
        if (pStack.m_41782_() && Objects.requireNonNull(pStack.m_41783_()).m_128441_(TAG_STORED_ENCHANTS)) {
            ListTag enchants = pStack.m_41783_().m_128437_(TAG_STORED_ENCHANTS, 10);
            for (int i = 0; i < enchants.size(); ++i) {
                CompoundTag enchantTag = enchants.m_128728_(i);
                Enchantment enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)enchantTag.m_128461_("id")));
                if (enchant == null) continue;
                int level = enchantTag.m_128451_("lvl");
                MutableComponent component = enchant.m_44700_(level).m_6881_();
                pTooltipComponents.add((Component)component.m_130940_(enchant.m_6589_() ? ChatFormatting.RED : ChatFormatting.GRAY));
            }
        }
    }
}

