/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransmutersGizzard
extends Item {
    private static final String TAG_STATE = "GizzardState";
    private static final String TAG_RESULT_ID = "GizzardResultID";
    private static final String TAG_COOLDOWN_END = "GizzardCooldownEnd";
    private static final int STATE_EMPTY = 0;
    private static final int STATE_PROCESSING = 1;
    private static final int STATE_READY = 2;
    private static final List<Block> TRANSMUTATION_PATH = List.of(Blocks.f_50652_, Blocks.f_50080_, Blocks.f_50060_, Blocks.f_50330_, Blocks.f_152504_, Blocks.f_50075_, Blocks.f_50074_, Blocks.f_50268_, Blocks.f_50090_, Blocks.f_50721_);

    public TransmutersGizzard(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack gizzardStack = pPlayer.m_21120_(pUsedHand);
        int currentState = this.getState(gizzardStack);
        if (pLevel.f_46443_) {
            return InteractionResultHolder.m_19098_((Object)gizzardStack);
        }
        switch (currentState) {
            case 0: {
                return this.handleAbsorb(pLevel, pPlayer, pUsedHand, gizzardStack);
            }
            case 1: {
                pPlayer.m_213846_((Component)Component.m_237113_((String)"The gizzard is still digesting...").m_130940_(ChatFormatting.YELLOW));
                return InteractionResultHolder.m_19098_((Object)gizzardStack);
            }
            case 2: {
                return this.handleEject(pLevel, pPlayer, gizzardStack);
            }
        }
        return InteractionResultHolder.m_19100_((Object)gizzardStack);
    }

    private InteractionResultHolder<ItemStack> handleAbsorb(Level pLevel, Player pPlayer, InteractionHand pUsedHand, ItemStack gizzardStack) {
        InteractionHand otherHand = pUsedHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack blockStack = pPlayer.m_21120_(otherHand);
        Item item = blockStack.m_41720_();
        if (!(item instanceof BlockItem)) {
            pPlayer.m_213846_((Component)Component.m_237113_((String)"The other hand must hold a valid block.").m_130940_(ChatFormatting.RED));
            return InteractionResultHolder.m_19100_((Object)gizzardStack);
        }
        BlockItem blockItem = (BlockItem)item;
        int index = TRANSMUTATION_PATH.indexOf(blockItem.m_40614_());
        if (index != -1 && index < TRANSMUTATION_PATH.size() - 1) {
            Block resultBlock = TRANSMUTATION_PATH.get(index + 1);
            int cooldownTicks = (30 + index * 30) * 20;
            if (!pPlayer.m_7500_()) {
                blockStack.m_41774_(1);
            }
            this.setState(gizzardStack, 1);
            this.setResult(gizzardStack, resultBlock);
            this.setCooldown(gizzardStack, pLevel.m_46467_() + (long)cooldownTicks);
            pLevel.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_12388_, SoundSource.PLAYERS, 1.0f, 0.8f);
            return InteractionResultHolder.m_19090_((Object)gizzardStack);
        }
        pPlayer.m_213846_((Component)Component.m_237113_((String)"This block cannot be transmuted further.").m_130940_(ChatFormatting.RED));
        pLevel.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_11797_, SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResultHolder.m_19100_((Object)gizzardStack);
    }

    private InteractionResultHolder<ItemStack> handleEject(Level pLevel, Player pPlayer, ItemStack gizzardStack) {
        Optional<Block> resultBlock = this.getResult(gizzardStack);
        if (resultBlock.isPresent()) {
            ItemEntity itemEntity = new ItemEntity(pLevel, pPlayer.m_20185_(), pPlayer.m_20188_(), pPlayer.m_20189_(), new ItemStack((ItemLike)resultBlock.get()));
            itemEntity.m_32010_(0);
            itemEntity.m_20256_(pPlayer.m_20154_().m_82490_(0.3));
            pLevel.m_7967_((Entity)itemEntity);
            this.resetState(gizzardStack);
            pLevel.m_5594_(null, pPlayer.m_20183_(), SoundEvents.f_12098_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.m_19090_((Object)gizzardStack);
        }
        return InteractionResultHolder.m_19100_((Object)gizzardStack);
    }

    public void m_6883_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pLevel.f_46443_) {
            return;
        }
        if (this.getState(pStack) == 1) {
            long cooldownEnd = this.getCooldown(pStack);
            if (pLevel.m_46467_() >= cooldownEnd) {
                this.setState(pStack, 2);
                if (pEntity instanceof Player) {
                    Player player = (Player)pEntity;
                    player.m_6330_((SoundEvent)SoundEvents.f_12216_.get(), SoundSource.PLAYERS, 1.0f, 1.5f);
                }
            }
        }
    }

    private int getState(ItemStack stack) {
        return stack.m_41784_().m_128451_(TAG_STATE);
    }

    private void setState(ItemStack stack, int state) {
        stack.m_41784_().m_128405_(TAG_STATE, state);
    }

    private void setResult(ItemStack stack, Block block) {
        stack.m_41784_().m_128359_(TAG_RESULT_ID, Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).toString());
    }

    private Optional<Block> getResult(ItemStack stack) {
        return Optional.ofNullable((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(stack.m_41784_().m_128461_(TAG_RESULT_ID))));
    }

    private void setCooldown(ItemStack stack, long time) {
        stack.m_41784_().m_128356_(TAG_COOLDOWN_END, time);
    }

    private long getCooldown(ItemStack stack) {
        return stack.m_41784_().m_128454_(TAG_COOLDOWN_END);
    }

    private void resetState(ItemStack stack) {
        if (stack.m_41782_()) {
            assert (stack.m_41783_() != null);
            stack.m_41783_().m_128473_(TAG_STATE);
            stack.m_41783_().m_128473_(TAG_RESULT_ID);
            stack.m_41783_().m_128473_(TAG_COOLDOWN_END);
        }
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return this.getState(pStack) == 2;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.transmuters_gizzard.effect").m_130940_(ChatFormatting.GOLD));
        MutableComponent progression = Component.m_237113_((String)"").m_7220_((Component)Component.m_237115_((String)Blocks.f_50652_.m_7705_())).m_130946_(" -> ").m_7220_((Component)Component.m_237115_((String)Blocks.f_50080_.m_7705_())).m_130946_(" -> ").m_7220_((Component)Component.m_237115_((String)Blocks.f_50060_.m_7705_())).m_130946_(" -> ").m_7220_((Component)Component.m_237115_((String)Blocks.f_50330_.m_7705_())).m_130946_(" -> ").m_7220_((Component)Component.m_237115_((String)Blocks.f_152504_.m_7705_())).m_130946_(" -> ").m_7220_((Component)Component.m_237115_((String)Blocks.f_50075_.m_7705_())).m_130946_(" -> ").m_7220_((Component)Component.m_237115_((String)Blocks.f_50074_.m_7705_())).m_130946_(" -> ").m_7220_((Component)Component.m_237115_((String)Blocks.f_50268_.m_7705_())).m_130946_(" -> ").m_7220_((Component)Component.m_237115_((String)Blocks.f_50090_.m_7705_())).m_130946_(" -> ").m_7220_((Component)Component.m_237115_((String)Blocks.f_50721_.m_7705_()));
        pTooltipComponents.add((Component)progression.m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.transmuters_gizzard.flavor").m_130940_(ChatFormatting.DARK_GREEN));
        if (pLevel == null) {
            return;
        }
        int state = this.getState(pStack);
        switch (state) {
            case 0: {
                pTooltipComponents.add((Component)Component.m_237113_((String)"State: Ready to Absorb").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 1: {
                long timeLeft = (this.getCooldown(pStack) - pLevel.m_46467_()) / 20L;
                pTooltipComponents.add((Component)Component.m_237113_((String)"State: Digesting...").m_130940_(ChatFormatting.YELLOW));
                pTooltipComponents.add((Component)Component.m_237113_((String)("Time remaining: " + timeLeft + "s")).m_130940_(ChatFormatting.YELLOW));
                break;
            }
            case 2: {
                this.getResult(pStack).ifPresent(block -> {
                    pTooltipComponents.add((Component)Component.m_237113_((String)"State: Ready to Eject").m_130940_(ChatFormatting.GREEN));
                    pTooltipComponents.add((Component)Component.m_237110_((String)"tooltip.timemercenaries.transmuters_gizzard.output", (Object[])new Object[]{block.m_49954_()}).m_130940_(ChatFormatting.AQUA));
                });
            }
        }
    }
}

