/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.item.artefacts;

import io.github.sluggly.timemercenaries.compat.CuriosCompat;
import io.github.sluggly.timemercenaries.init.ItemInit;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VolatileConcoctionCasing
extends Item {
    private static final List<MobEffect> POSITIVE_EFFECTS = List.of(MobEffects.f_19601_, MobEffects.f_19605_, MobEffects.f_19596_, MobEffects.f_19600_, MobEffects.f_19611_, MobEffects.f_19608_, MobEffects.f_19617_, MobEffects.f_19607_, MobEffects.f_19606_);

    public VolatileConcoctionCasing(Item.Properties pProperties) {
        super(pProperties);
    }

    public static void handleVolatileConcoctionCasingEffect(ServerPlayer player) {
        if (VolatileConcoctionCasing.isItemEquipped((Player)player) && player.m_217043_().m_188501_() < 0.1f) {
            VolatileConcoctionCasing.applyRandomBuff(player);
        }
    }

    private static boolean isItemEquipped(Player player) {
        if (player.m_21205_().m_150930_((Item)ItemInit.VOLATILE_CONCOCTION_CASING.get()) || player.m_21206_().m_150930_((Item)ItemInit.VOLATILE_CONCOCTION_CASING.get())) {
            return true;
        }
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.hasItemEquippedAsCurio(player, (Item)ItemInit.VOLATILE_CONCOCTION_CASING.get());
        }
        return false;
    }

    private static void applyRandomBuff(ServerPlayer player) {
        Random random = new Random();
        MobEffect chosenEffect = POSITIVE_EFFECTS.get(random.nextInt(POSITIVE_EFFECTS.size()));
        int duration = 200;
        int amplifier = 0;
        if (chosenEffect.m_8093_()) {
            duration = 1;
        }
        player.m_7292_(new MobEffectInstance(chosenEffect, duration, amplifier));
        player.m_6330_(SoundEvents.f_11772_, SoundSource.PLAYERS, 1.0f, 1.5f);
    }

    public boolean m_5812_(@NotNull ItemStack pStack) {
        return true;
    }

    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltipComponents, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.volatile_concoction_casing.effect").m_130940_(ChatFormatting.GOLD));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.timemercenaries.volatile_concoction_casing.flavor").m_130940_(ChatFormatting.LIGHT_PURPLE));
    }
}

