/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.mercenary;

import io.github.sluggly.timemercenaries.TimeMercenaryAdvancements;
import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.entity.Portal;
import io.github.sluggly.timemercenaries.item.DimensionalTimeClock;
import io.github.sluggly.timemercenaries.mercenary.MercenaryDefinition;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.missions.Mission;
import io.github.sluggly.timemercenaries.missions.MissionItem;
import io.github.sluggly.timemercenaries.network.PacketHandler;
import io.github.sluggly.timemercenaries.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class Mercenary {
    public final String name;
    public final String job;
    public final String description;
    public final int health;
    public final ArrayList<ArrayList<ResourceLocation>> missionRarityList;
    public final HashMap<String, Integer> mapRarityIndex;
    public final ResourceLocation texture;
    public final ResourceLocation backgroundTexture;
    public final ResourceLocation walkingTexture;
    public final int color;
    public final List<MissionItem> bribeItems;
    public static final MissionItem totemItem = new MissionItem(1, Items.f_42747_);
    public static final MissionItem resetTraitsItem = new MissionItem(1, Items.f_42718_);
    public final String moduleRequirement;
    private final Random random;
    private final Map<String, String> voicelineTranscripts;
    private static final ArrayList<String> mercenaryNames = new ArrayList();
    private static final Map<String, Mercenary> mercenaryMap = new HashMap<String, Mercenary>();
    public static final String MERCENARY_TYPE = "timemercenaries:mercenary";
    public static final String SHOPKEEPER_TYPE = "timemercenaries:shopkeeper";

    public Mercenary(MercenaryDefinition definition) {
        this.name = definition.name();
        this.color = definition.color();
        this.job = definition.job();
        this.health = definition.health().orElse(-1);
        this.bribeItems = definition.bribe();
        this.texture = new ResourceLocation("timemercenaries", "textures/gui/" + Utils.unformatMercenaryString(this.job) + ".png");
        this.backgroundTexture = new ResourceLocation("timemercenaries", "textures/gui/" + definition.backgroundTexture().orElse("plain_background") + ".png");
        this.walkingTexture = new ResourceLocation("timemercenaries", "textures/gui/" + Utils.unformatMercenaryString(this.job) + "_walking.png");
        this.description = definition.description();
        this.missionRarityList = new ArrayList();
        this.mapRarityIndex = new HashMap();
        this.random = new Random();
        this.moduleRequirement = definition.module_requirement().orElse(null);
        this.voicelineTranscripts = definition.sounds().orElse(Map.of());
        this.populateRarityMap();
        mercenaryNames.add(this.name);
        mercenaryMap.put(Mission.sanitize(this.name), this);
    }

    public static Mercenary getMercenary(String mercenaryName) {
        return mercenaryMap.get(Mission.sanitize(mercenaryName));
    }

    public static Set<Map.Entry<String, Mercenary>> getMercenariesEntrySet() {
        return mercenaryMap.entrySet();
    }

    public static ArrayList<String> getMercenariesName() {
        return mercenaryNames;
    }

    public static void emptyMercenaries() {
        mercenaryMap.clear();
        mercenaryNames.clear();
    }

    @Nullable
    public String getVoicelineTranscript(String action) {
        return this.voicelineTranscripts.get(action.toLowerCase());
    }

    public static void playerRecruitMercenary(ServerPlayer serverPlayer, String mercenaryName) {
        PlayerData playerData;
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Received recruit request from player : " + serverPlayer.m_6302_() + " name : " + mercenaryName);
        }
        if ((playerData = PlayerData.getPlayerData((Player)serverPlayer)) == null) {
            Admin.playerRequestError((Player)serverPlayer, "Player Data is null.");
            return;
        }
        if (!playerData.getCurrentState().equals("Recruiting")) {
            Admin.playerRequestError((Player)serverPlayer, "Wrong state, expected Recruiting received " + playerData.getCurrentState() + ".");
            return;
        }
        String[] mercenariesAvailable = MercenaryPlayerData.getRecruitsAvailable(playerData);
        boolean canRecruit = false;
        for (String mercenaryAvailable : mercenariesAvailable) {
            if (!mercenaryAvailable.equals(mercenaryName)) continue;
            canRecruit = true;
            break;
        }
        if (!canRecruit) {
            Admin.playerRequestError((Player)serverPlayer, "Mercenary not in Recruits Available list.");
            return;
        }
        MercenaryPlayerData.generateMissionsForMercenaryIfNecessary(playerData, mercenaryName);
        MercenaryPlayerData.setCurrentMercenary(playerData, mercenaryName);
        playerData.setState("SendingMission");
        PacketHandler.sendToPlayer("OpenMissionsScreen", playerData, serverPlayer);
    }

    public static void playerResurrectMercenary(ServerPlayer player, String mercenaryName) {
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (playerData == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        int requiredLevel = MercenaryPlayerData.getRequiredPlayerLevelToResurrectMercenary(playerData, mercenaryName);
        if (!Utils.checkIfPlayerHasEnoughLevel((Player)player, requiredLevel)) {
            return;
        }
        Utils.removePlayerLevel((Player)player, requiredLevel);
        MercenaryPlayerData.resurrectMercenary(playerData, mercenaryName);
        PacketHandler.sendToPlayer("RefreshData", playerData, player);
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Mercenary resurrected : " + player.m_6302_() + ", mercenary : " + mercenaryName);
        }
    }

    public static void addMercenariesToMapClient(Player player) {
        PlayerData playerData = PlayerData.getPlayerData(null);
        if (playerData == null) {
            Admin.playerRequestError(player, "Player Data is null.");
            return;
        }
        DimensionalTimeClock.clearMercenaryTimeClient();
        for (String mercenaryName : Mercenary.getMercenariesName()) {
            if (!MercenaryPlayerData.getMercenaryMissionStatus(playerData, mercenaryName).equals("Ongoing") && !MercenaryPlayerData.getMercenaryMissionStatus(playerData, mercenaryName).equals("Skipped")) continue;
            int timeLeft = MercenaryPlayerData.getMercenaryMissionTimeLeft(playerData, mercenaryName);
            int totalTime = MercenaryPlayerData.getMercenaryMissionTimeTotal(playerData, mercenaryName);
            DimensionalTimeClock.addMercenaryTimeClient(mercenaryName, timeLeft, totalTime);
        }
    }

    public static MissionItem getMercenaryActiveBribeItem(PlayerData playerData, String mercenaryName) {
        Mercenary mercenary = Mercenary.getMercenary(mercenaryName);
        if (mercenary == null || mercenary.bribeItems.isEmpty()) {
            return null;
        }
        int seed = MercenaryPlayerData.getMercenarySeed(playerData, mercenaryName);
        int itemIndex = (seed + 86426) % mercenary.bribeItems.size();
        return mercenary.bribeItems.get(itemIndex);
    }

    public static void playerMercenaryBribe(ServerPlayer player, String mercenaryName) {
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (playerData == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (MercenaryPlayerData.isMercenaryBribed(playerData, mercenaryName)) {
            return;
        }
        MissionItem bribeItem = Mercenary.getMercenaryActiveBribeItem(playerData, mercenaryName);
        assert (bribeItem != null);
        if (!Utils.hasEnoughItems(bribeItem.itemStack.m_41720_(), (Player)player, bribeItem.number)) {
            Admin.playerRequestError((Player)player, "Player has not enough item to bribe.");
            return;
        }
        Utils.removeItemInInventory(bribeItem.itemStack.m_41720_(), bribeItem.number, (Player)player);
        Portal.playPortalAnimation(player, bribeItem.itemStack);
        MercenaryPlayerData.setMercenaryBribe(playerData, mercenaryName, true);
        PacketHandler.sendToPlayer("RefreshData", playerData, player);
        TimeMercenaryAdvancements.checkAndTestGrantAdvancement(player, "Bribe");
    }

    public static void playerMercenaryTotem(ServerPlayer player, String mercenaryName) {
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (playerData == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (MercenaryPlayerData.doesMercenaryHaveTotem(playerData, mercenaryName)) {
            return;
        }
        MissionItem totemItem = Mercenary.totemItem;
        if (!Utils.hasEnoughItems(totemItem.itemStack.m_41720_(), (Player)player, totemItem.number)) {
            Admin.playerRequestError((Player)player, "Player has not enough item to give a totem.");
            return;
        }
        Utils.removeItemInInventory(totemItem.itemStack.m_41720_(), totemItem.number, (Player)player);
        Portal.playPortalAnimation(player, totemItem.itemStack);
        MercenaryPlayerData.setMercenaryTotem(playerData, mercenaryName, true);
        PacketHandler.sendToPlayer("RefreshData", playerData, player);
        TimeMercenaryAdvancements.checkAndTestGrantAdvancement(player, "Totem");
    }

    public void populateRarityMap() {
        this.mapRarityIndex.put("Common", 0);
        this.mapRarityIndex.put("Uncommon", 1);
        this.mapRarityIndex.put("Rare", 2);
        this.mapRarityIndex.put("Epic", 3);
        this.mapRarityIndex.put("Legendary", 4);
        for (int i = 0; i < this.mapRarityIndex.size(); ++i) {
            this.missionRarityList.add(new ArrayList());
        }
    }

    public void addMission(ResourceLocation missionId, String rarity) {
        this.missionRarityList.get(this.mapRarityIndex.get(rarity)).add(missionId);
    }

    public Mission generateRandomMissionForRarity(String rarity) {
        int rarityIndex = this.mapRarityIndex.get(rarity);
        ArrayList<ResourceLocation> missionsForRarity = this.missionRarityList.get(rarityIndex);
        String missionDescription = "This mercenary is heading for the unknown, who knows what he will return!";
        HashSet<Item> requiredUniqueItems = new HashSet<Item>();
        HashSet<Item> successUniqueItems = new HashSet<Item>();
        ArrayList<MissionItem> requiredItems = new ArrayList<MissionItem>();
        ArrayList<MissionItem> successItems = new ArrayList<MissionItem>();
        HashSet<EntityType> successUniqueEntity = new HashSet<EntityType>();
        int failChance = 0;
        int failDamage = 0;
        for (ResourceLocation missionId : missionsForRarity) {
            Mission mission = Mission.getMissionFromId(missionId);
            if (mission == null) continue;
            for (MissionItem missionItem : mission.getRequiredItems(-1)) {
                if (requiredUniqueItems.contains(missionItem.itemStack.m_41720_())) continue;
                requiredItems.add(missionItem);
                requiredUniqueItems.add(missionItem.itemStack.m_41720_());
            }
            for (MissionItem missionItem : mission.getSuccessItems(-1)) {
                if (missionItem.entity != null) {
                    if (successUniqueEntity.contains(missionItem.entity)) continue;
                    successItems.add(missionItem);
                    successUniqueEntity.add(missionItem.entity);
                    continue;
                }
                if (missionItem.itemStack == null || successUniqueItems.contains(missionItem.itemStack.m_41720_())) continue;
                successItems.add(missionItem);
                successUniqueItems.add(missionItem.itemStack.m_41720_());
            }
            failChance += mission.failChance;
            failDamage += mission.failDamage;
        }
        if (missionsForRarity.isEmpty()) {
            return null;
        }
        failChance = (int)((double)failChance / (double)missionsForRarity.size()) + rarityIndex * 5;
        failDamage = (int)((double)failDamage / (double)missionsForRarity.size()) + rarityIndex / 2;
        return new Mission(missionDescription, this.name, requiredItems.toArray(new MissionItem[0]), successItems.toArray(new MissionItem[0]), null, null, rarity, failChance, failDamage);
    }

    public static int getLevelColor(int level) {
        if (level < 3) {
            return 0xFFFFFF;
        }
        if (level < 5) {
            return 65280;
        }
        if (level < 7) {
            return 255;
        }
        if (level < 10) {
            return 0x800080;
        }
        return 16753920;
    }

    public ResourceLocation getRandomMissionId(int[] missionProbability) {
        Mission mission = this.getRandomMission(missionProbability);
        return mission.id;
    }

    public Mission getRandomMission(int[] missionProbability) {
        Mission randomMission;
        int randomValue = this.random.nextInt(100);
        int rarityIndex = 0;
        while (randomValue > missionProbability[rarityIndex]) {
            ++rarityIndex;
        }
        String rarity = Mission.arrayRarityIndex[rarityIndex];
        if (this.random.nextInt(100) < 30 && (randomMission = this.generateRandomMissionForRarity(rarity)) != null) {
            return randomMission;
        }
        ArrayList<ResourceLocation> missionsForRarity = this.missionRarityList.get(rarityIndex);
        if (missionsForRarity.isEmpty()) {
            return this.generateRandomMissionForRarity(rarity);
        }
        ResourceLocation missionId = missionsForRarity.get(this.random.nextInt(missionsForRarity.size()));
        return Mission.getMissionFromId(missionId);
    }

    public static int getLevel(int currentExp) {
        double discriminant = 1.0 + 0.08 * (double)currentExp;
        return (int)((-1.0 + Math.sqrt(discriminant)) / 2.0) + 1;
    }

    public static int getRequiredExpLevel(int level) {
        return 50 * (level - 1) * level;
    }

    public static String getBribeItemTooltip(PlayerData playerData, String mercenaryName) {
        MissionItem bribeItem = Mercenary.getMercenaryActiveBribeItem(playerData, mercenaryName);
        assert (bribeItem != null);
        return bribeItem.number + " " + Utils.unformatString(bribeItem.itemStack.m_41720_().toString());
    }

    public static String getFeedItemTooltip(PlayerData playerData, String mercenaryName) {
        MissionItem feedItem = Mercenary.getMercenaryFoodItem(playerData, mercenaryName);
        return feedItem.number + " " + Utils.unformatString(feedItem.itemStack.m_41720_().toString()) + "\nRegenerate 5 Hunger.";
    }

    public MissionItem[] getDimensionalGlitchSuccessItems(int mercenarySeed, String rarity) {
        Mission mission = this.generateRandomMissionForRarity(rarity);
        return new MissionItem[]{mission.getSuccessItems(mercenarySeed)[(mercenarySeed + 85857) % mission.getSuccessItems(mercenarySeed).length]};
    }

    public LinkedHashSet<MissionItem> getMercenaryAllPossibleRewards() {
        LinkedHashSet<MissionItem> allPossibleRewards = new LinkedHashSet<MissionItem>();
        for (ArrayList<ResourceLocation> resourceLocations : this.missionRarityList) {
            for (ResourceLocation resourceLocation : resourceLocations) {
                Mission mission = Mission.getMissionFromId(resourceLocation);
                assert (mission != null);
                allPossibleRewards.addAll(Arrays.asList(mission.getSuccessItems(-1)));
            }
        }
        return allPossibleRewards;
    }

    public static void handleRegenerateAllPlayerMercenariesHunger(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = event.getServer();
        ServerLevel overworld = server.m_129880_(Level.f_46428_);
        if (overworld == null) {
            return;
        }
        long timeOfDay = overworld.m_46468_() % 24000L;
        if (timeOfDay == 6000L) {
            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println("Time Mercenaries: Noon detected. Regenerating hunger for all mercenaries.");
            }
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                PlayerData playerData = PlayerData.getPlayerData((Player)player);
                if (playerData == null) continue;
                for (String mercenaryName : Mercenary.getMercenariesName()) {
                    int maxHunger;
                    int currentHunger;
                    if (mercenaryName.equals("Vael") || (currentHunger = MercenaryPlayerData.getMercenaryCurrentHunger(playerData, mercenaryName)) >= (maxHunger = MercenaryPlayerData.getMercenaryMaximumHunger(playerData, mercenaryName))) continue;
                    MercenaryPlayerData.setMercenaryHunger(playerData, mercenaryName, currentHunger + 1);
                }
            }
        }
    }

    public static MissionItem getMercenaryFoodItem(PlayerData playerData, String mercenaryName) {
        int mercenarySeed = MercenaryPlayerData.getMercenarySeed(playerData, mercenaryName);
        List<Item> edibleItems = ForgeRegistries.ITEMS.getValues().stream().filter(Item::m_41472_).toList();
        if (edibleItems.isEmpty()) {
            return new MissionItem(1, Items.f_42580_);
        }
        return new MissionItem(1, edibleItems.get((mercenarySeed + 975421) % edibleItems.size()));
    }

    public static void playerFeedMercenary(ServerPlayer player, String mercenaryName) {
        PlayerData playerData;
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Received feed mercenary request from player : " + player.m_6302_() + " name : " + mercenaryName);
        }
        if ((playerData = PlayerData.getPlayerData((Player)player)) == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (!playerData.getCurrentState().equals("SendingMission")) {
            Admin.playerRequestError((Player)player, "Wrong state, expected Sending Mission received " + playerData.getCurrentState() + ".");
            return;
        }
        MissionItem feedItem = Mercenary.getMercenaryFoodItem(playerData, mercenaryName);
        if (!Utils.hasEnoughItems(feedItem.itemStack.m_41720_(), (Player)player, feedItem.number)) {
            Admin.playerRequestError((Player)player, "Not enough item in inventory to feed mercenary.");
            return;
        }
        Utils.removeItemInInventory(feedItem.itemStack.m_41720_(), feedItem.number, (Player)player);
        int currentHunger = MercenaryPlayerData.getMercenaryCurrentHunger(playerData, mercenaryName);
        int maxHunger = MercenaryPlayerData.getMercenaryMaximumHunger(playerData, mercenaryName);
        MercenaryPlayerData.setMercenaryHunger(playerData, mercenaryName, Math.min(currentHunger + 5, maxHunger));
        MercenaryPlayerData.setMercenaryFed(playerData, mercenaryName, true);
        Portal.playPortalAnimation(player, feedItem.itemStack);
        PacketHandler.sendToPlayer("RefreshData", playerData, player);
        TimeMercenaryAdvancements.checkAndTestGrantAdvancement(player, "Feed");
    }
}

