/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.mercenary;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.sluggly.timemercenaries.config.ServerConfig;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.MercenaryDefinition;
import io.github.sluggly.timemercenaries.mercenary.Shopkeeper;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class MercenaryManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String DIRECTORY = "mercenaries";
    private static final MercenaryManager INSTANCE = new MercenaryManager();
    private Map<ResourceLocation, MercenaryDefinition> loadedDefinitions = new HashMap<ResourceLocation, MercenaryDefinition>();
    private boolean jsonLoaded = false;
    private boolean processed = false;

    private MercenaryManager() {
        super(GSON, DIRECTORY);
    }

    public static MercenaryManager getMercenaryManager() {
        return INSTANCE;
    }

    public void resetProcessedFlag() {
        this.processed = false;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsonObjects, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        HashMap<ResourceLocation, MercenaryDefinition> loaded = new HashMap<ResourceLocation, MercenaryDefinition>();
        jsonObjects.forEach((location, jsonElement) -> {
            try {
                MercenaryDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement).resultOrPartial(error -> System.err.println("Failed to parse mercenary " + String.valueOf(location) + ": " + error)).ifPresent(mercenary -> loaded.put((ResourceLocation)location, (MercenaryDefinition)mercenary));
            }
            catch (Exception e) {
                System.err.println("Exception while parsing mercenary " + String.valueOf(location) + ": " + e.getMessage());
            }
        });
        this.loadedDefinitions = loaded;
        this.jsonLoaded = true;
        this.processed = false;
        System.out.println("Loaded " + this.loadedDefinitions.size() + " mercenary definitions.");
        this.tryProcess();
    }

    public void tryProcess() {
        if (this.processed) {
            return;
        }
        if (!this.jsonLoaded) {
            return;
        }
        if (!ServerConfig.isLoaded()) {
            return;
        }
        this.processAndRegisterMercenaries();
        this.processed = true;
    }

    private void processAndRegisterMercenaries() {
        Mercenary.emptyMercenaries();
        this.loadedDefinitions.entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.comparing(ResourceLocation::m_135815_))).forEach(entry -> {
            MercenaryDefinition definition = (MercenaryDefinition)entry.getValue();
            if (ServerConfig.isMercenaryEnabled(definition.name())) {
                this.initMercenaryFromDefinition(definition);
            } else {
                System.out.println("Skipping disabled mercenary: " + definition.name());
            }
        });
        System.out.println("Registered " + Mercenary.getMercenariesName().size() + " enabled mercenaries.");
    }

    public void setMercenaries(Map<ResourceLocation, MercenaryDefinition> mercenaries) {
        this.loadedDefinitions = mercenaries;
        Mercenary.emptyMercenaries();
        mercenaries.entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.comparing(ResourceLocation::m_135815_))).forEach(entry -> {
            MercenaryDefinition definition = (MercenaryDefinition)entry.getValue();
            this.initMercenaryFromDefinition(definition);
        });
        System.out.println("Loaded " + mercenaries.size() + " mercenaries for Time Mercenaries.");
    }

    private void initMercenaryFromDefinition(MercenaryDefinition definition) {
        switch (definition.type()) {
            case "timemercenaries:shopkeeper": {
                new Shopkeeper(definition);
                break;
            }
            case "timemercenaries:mercenary": {
                new Mercenary(definition);
                break;
            }
            default: {
                System.err.println("Mercenary type invalid : " + definition.type() + " for mercenary : " + definition.name());
            }
        }
    }

    public Map<ResourceLocation, MercenaryDefinition> getEnabledMercenaries() {
        this.tryProcess();
        return this.loadedDefinitions.entrySet().stream().filter(entry -> ServerConfig.isMercenaryEnabled(((MercenaryDefinition)entry.getValue()).name())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

