/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.mercenary;

import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.item.DimensionalTimeClock;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.mercenary.Trait;
import io.github.sluggly.timemercenaries.missions.Mission;
import io.github.sluggly.timemercenaries.module.Module;
import io.github.sluggly.timemercenaries.network.PacketHandler;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class Quest {
    public static ArrayList<String> questObjectives = new ArrayList();
    public static ArrayList<String> questRewards = new ArrayList();

    public static void populateQuests() {
        Quest.populateQuestObjectives();
        Quest.populateQuestRewards();
    }

    private static void populateQuestObjectives() {
        questObjectives.add("Success Number Mission");
        questObjectives.add("Fail Number Mission");
        questObjectives.add("Fail Number Rarity Mission");
        questObjectives.add("Success Number Rarity Mission");
        questObjectives.add("Fail Number Mission Mercenary");
        questObjectives.add("Success Number Mission Mercenary");
        questObjectives.add("Fail Number Rarity Mission Mercenary");
        questObjectives.add("Success Number Rarity Mission Mercenary");
        questObjectives.add("Buy Number Items");
    }

    private static void populateQuestRewards() {
        questRewards.add("Mercenary Number Level");
        questRewards.add("Mercenary Number Random Trait");
        questRewards.add("Heal Number Everyone");
        questRewards.add("Resurrect Everyone");
        questRewards.add("Number Coin");
    }

    public static String generateRandomQuestObjective(int seed) {
        return questObjectives.get((seed + 18112) % questObjectives.size());
    }

    public static String generateRandomQuestReward(int seed) {
        return questRewards.get((seed + 1612) % questRewards.size());
    }

    public static String generateRandomQuestRarity(int seed, boolean isObjective) {
        int seedModifier = isObjective ? 154 : 160;
        return Mission.arrayRarityIndex[(seed + seedModifier) % Mission.arrayRarityIndex.length];
    }

    public static String generateRandomQuestMercenary(int seed, boolean isObjective) {
        int seedModifier = isObjective ? 176 : 182;
        return Mercenary.getMercenariesName().get((seed + seedModifier) % Mercenary.getMercenariesName().size());
    }

    public static String generateRandomQuestTrait(int seed, boolean isObjective) {
        int seedModifier = isObjective ? 783 : 278;
        return Trait.getTraits().get((int)((seed + seedModifier) % Trait.getTraitsMap().size())).name;
    }

    public static int getQuestRandomNumber(int seed, String questId) {
        int defaultValue = 10;
        int maximumNumber = switch (questId) {
            case "Success Number Mission" -> 5;
            case "Fail Number Mission", "Fail Number Rarity Mission", "Success Number Rarity Mission Mercenary", "Mercenary Number Level", "Fail Number Mission Mercenary" -> 3;
            case "Success Number Rarity Mission", "Mercenary Number Random Trait", "Success Number Mission Mercenary" -> 4;
            case "Fail Number Rarity Mission Mercenary" -> 2;
            case "Buy Number Items", "Heal Number Everyone" -> 10;
            case "Number Coin" -> 50;
            default -> defaultValue;
        };
        return (seed + 156541) % maximumNumber + 1;
    }

    public static boolean hasPlayerNoOngoingQuest(PlayerData playerData, String mercenaryName) {
        if (Module.isModuleActive(playerData, "Caravaneer Questing Module")) {
            return !MercenaryPlayerData.getMercenaryQuestStatus(playerData, mercenaryName).equals("Ongoing");
        }
        return true;
    }

    public static void updateQuestOnShopItemBuy(PlayerData playerData) {
        if (Quest.hasPlayerNoOngoingQuest(playerData, "Vael")) {
            return;
        }
        String requirementId = MercenaryPlayerData.getMercenaryChosenQuestObjectiveId(playerData, "Vael");
        if (!requirementId.contains("Buy")) {
            return;
        }
        CompoundTag questTag = MercenaryPlayerData.getMercenaryChosenQuestTag(playerData, "Vael");
        int currentProgress = questTag.m_128451_("RequirementProgress");
        questTag.m_128405_("RequirementProgress", ++currentProgress);
        Quest.checkIfQuestIsDone(playerData);
    }

    public static void updateQuestOnMission(PlayerData playerData) {
        String requiredMercenary;
        String requiredRarity;
        if (Quest.hasPlayerNoOngoingQuest(playerData, "Vael")) {
            return;
        }
        String chosenMercenary = MercenaryPlayerData.getCurrentMercenary(playerData);
        ResourceLocation missionId = MercenaryPlayerData.getMercenaryChosenMission(playerData, chosenMercenary);
        Mission mission = Mission.getMissionFromId(missionId);
        assert (mission != null);
        String missionStatus = MercenaryPlayerData.getMercenaryMissionStatus(playerData, chosenMercenary);
        String requirementId = MercenaryPlayerData.getMercenaryChosenQuestObjectiveId(playerData, "Vael");
        if (!requirementId.contains(missionStatus)) {
            return;
        }
        CompoundTag questTag = MercenaryPlayerData.getMercenaryChosenQuestTag(playerData, "Vael");
        if (requirementId.contains("Rarity") && !(requiredRarity = questTag.m_128461_("RequirementTargetRarity")).equals(mission.rarity)) {
            return;
        }
        if (requirementId.contains("Mercenary") && !(requiredMercenary = questTag.m_128461_("RequirementTargetMercenary")).equals(chosenMercenary)) {
            return;
        }
        int currentProgress = questTag.m_128451_("RequirementProgress");
        questTag.m_128405_("RequirementProgress", ++currentProgress);
        Quest.checkIfQuestIsDone(playerData);
    }

    public static void checkIfQuestIsDone(PlayerData playerData) {
        int targetNumber;
        String requirementId = MercenaryPlayerData.getMercenaryChosenQuestObjectiveId(playerData, "Vael");
        CompoundTag questTag = MercenaryPlayerData.getMercenaryChosenQuestTag(playerData, "Vael");
        int questSeed = questTag.m_128451_("Seed");
        int currentProgress = questTag.m_128451_("RequirementProgress");
        if (currentProgress == (targetNumber = Quest.getQuestRandomNumber(questSeed, requirementId))) {
            CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, "Vael");
            mercenaryTag.m_128359_("QuestStatus", "Success");
        }
    }

    public static void giveQuestRewards(PlayerData playerData) {
        String rewardId = MercenaryPlayerData.getMercenaryChosenQuestRewardId(playerData, "Vael");
        CompoundTag questTag = MercenaryPlayerData.getMercenaryChosenQuestTag(playerData, "Vael");
        int questSeed = questTag.m_128451_("Seed");
        if (rewardId.contains("Mercenary")) {
            String mercenaryName = questTag.m_128461_("RewardTargetMercenary");
            if (rewardId.contains("Level")) {
                int numberLevelUp = Quest.getQuestRandomNumber(questSeed, rewardId);
                int currentLevel = MercenaryPlayerData.getMercenaryLevel(playerData, mercenaryName);
                int requiredCurrentExp = Mercenary.getRequiredExpLevel(currentLevel);
                int requiredNewExp = Mercenary.getRequiredExpLevel(currentLevel + numberLevelUp);
                int experienceToGive = requiredNewExp - requiredCurrentExp;
                MercenaryPlayerData.mercenaryGainExp(playerData, mercenaryName, experienceToGive);
            }
            if (rewardId.contains("Trait")) {
                String trait = questTag.m_128461_("RewardTargetTrait");
                int numberTraitLevelUp = Quest.getQuestRandomNumber(questSeed, rewardId);
                for (int i = 0; i < numberTraitLevelUp; ++i) {
                    MercenaryPlayerData.increaseMercenaryTraitLevel(playerData, mercenaryName, trait);
                }
            }
        }
        if (rewardId.contains("Everyone")) {
            if (rewardId.contains("Heal")) {
                int number = Quest.getQuestRandomNumber(questSeed, rewardId);
                for (String mercenaryName : Mercenary.getMercenariesName()) {
                    MercenaryPlayerData.healMercenary(playerData, mercenaryName, number);
                }
            }
            if (rewardId.contains("Resurrect")) {
                for (String mercenaryName : Mercenary.getMercenariesName()) {
                    MercenaryPlayerData.resurrectMercenary(playerData, mercenaryName);
                }
            }
        }
        if (rewardId.contains("Coin")) {
            int number = Quest.getQuestRandomNumber(questSeed, rewardId);
            MercenaryPlayerData.addMercenaryCoins(playerData, "Vael", number);
        }
        MercenaryPlayerData.cleanMercenaryChosenQuest(playerData, "Vael");
        MercenaryPlayerData.generateAllMercenaryQuests(playerData, "Vael");
    }

    public static String getQuestDescription(PlayerData playerData, int questIndex, boolean isObjective) {
        CompoundTag questsTag = MercenaryPlayerData.getMercenaryQuestsTag(playerData, "Vael");
        CompoundTag questTag = questsTag.m_128469_("Quest" + questIndex);
        int seed = questTag.m_128451_("Seed");
        int number = -1;
        String rarity = "";
        String mercenary = "";
        if (isObjective) {
            String requirementId = questTag.m_128461_("RequirementId");
            if (requirementId.contains("Number")) {
                number = Quest.getQuestRandomNumber(seed, requirementId);
            }
            if (requirementId.contains("Rarity")) {
                rarity = questTag.m_128461_("RequirementTargetRarity");
            }
            if (requirementId.contains("Mercenary")) {
                mercenary = questTag.m_128461_("RequirementTargetMercenary");
            }
            return switch (requirementId) {
                case "Success Number Mission" -> "Successfully complete %d missions.".formatted(number);
                case "Fail Number Mission" -> "Fail %d missions.".formatted(number);
                case "Success Number Rarity Mission" -> "Successfully complete %d %s missions.".formatted(number, rarity);
                case "Fail Number Rarity Mission" -> "Fail %d %s missions.".formatted(number, rarity);
                case "Success Number Mission Mercenary" -> "Successfully complete %d missions with %s.".formatted(number, mercenary);
                case "Fail Number Mission Mercenary" -> "Fail %d missions with %s.".formatted(number, mercenary);
                case "Success Number Rarity Mission Mercenary" -> "Successfully complete %d %s missions with %s.".formatted(number, rarity, mercenary);
                case "Fail Number Rarity Mission Mercenary" -> "Fail %d %s missions with %s.".formatted(number, rarity, mercenary);
                case "Buy Number Items" -> "Buy %d items from Vael's shop.".formatted(number);
                default -> "An unknown task awaits...";
            };
        }
        String rewardId = questTag.m_128461_("RewardId");
        if (rewardId.contains("Number")) {
            number = Quest.getQuestRandomNumber(seed, rewardId);
        }
        if (rewardId.contains("Mercenary")) {
            mercenary = questTag.m_128461_("RewardTargetMercenary");
        }
        return switch (rewardId) {
            case "Mercenary Number Level" -> "Grant %d levels to %s.".formatted(number, mercenary);
            case "Mercenary Number Random Trait" -> "Grant %d random trait points to %s.".formatted(number, mercenary);
            case "Heal Number Everyone" -> "Heal all of your mercenaries for %d health.".formatted(number);
            case "Resurrect Everyone" -> "Resurrect all of your dead mercenaries.";
            case "Number Coin" -> "Gain %d coins.".formatted(number);
            default -> "An unknown task awaits...";
        };
    }

    public static void playerAcceptQuest(ServerPlayer player, String mercenaryName, int index) {
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (playerData == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (!Module.isModuleActive(playerData, "Caravaneer Questing Module")) {
            Admin.playerRequestError((Player)player, "Caravaneer Questing Module is not active.");
            return;
        }
        if (MercenaryPlayerData.isMercenaryNotAvailable(playerData, mercenaryName)) {
            Admin.playerRequestError((Player)player, mercenaryName + " is not available.");
            return;
        }
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryName);
        if (mercenaryTag.m_128451_("ChosenQuest") != 0) {
            Admin.playerRequestError((Player)player, "Player already has an active quest.");
            return;
        }
        if (index < 1 || index > 3) {
            Admin.playerRequestError((Player)player, "Invalid index.");
            return;
        }
        MercenaryPlayerData.setMercenaryChosenQuestIndex(playerData, mercenaryName, index);
        MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "TotalQuests");
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Accepted Quest with Index : " + index);
        }
        PacketHandler.sendToPlayer("RefreshData", playerData, player);
    }

    public static void playerAbandonQuest(ServerPlayer player, String mercenaryName) {
        PlayerData playerData;
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Received Abandon Quest : " + player.m_6302_() + ", mercenary : " + mercenaryName);
        }
        if ((playerData = PlayerData.getPlayerData((Player)player)) == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (MercenaryPlayerData.isMercenaryNotAvailable(playerData, mercenaryName)) {
            Admin.playerRequestError((Player)player, "Mercenary is not available.");
            return;
        }
        if (Admin.arePlayerMissionsInstant(player)) {
            MercenaryPlayerData.setMercenaryMissionTimes(playerData, mercenaryName, 5);
        } else {
            MercenaryPlayerData.setMercenaryMissionTimes(playerData, mercenaryName, 150);
        }
        MercenaryPlayerData.setMercenaryMissionStatus(playerData, mercenaryName, "Skipped");
        MercenaryPlayerData.setCurrentMercenary(playerData, mercenaryName);
        DimensionalTimeClock.addMercenaryTimeServer((Player)player, mercenaryName, MercenaryPlayerData.getMercenaryMissionTimeLeft(playerData, mercenaryName));
        MercenaryPlayerData.cleanMercenaryChosenMission(playerData, mercenaryName);
        MercenaryPlayerData.cleanMercenaryChosenQuest(playerData, mercenaryName);
        MercenaryPlayerData.generateAllMercenaryQuests(playerData, mercenaryName);
        playerData.setState("WaitingMission");
        PacketHandler.sendToPlayer("SkipShopAccept", playerData, player);
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Quest Abandoned : " + player.m_6302_() + ", mercenary : " + mercenaryName);
        }
    }

    public static void playerCompleteQuest(ServerPlayer player, String mercenaryName) {
        PlayerData playerData;
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Received Complete Quest : " + player.m_6302_() + ", mercenary : " + mercenaryName);
        }
        if ((playerData = PlayerData.getPlayerData((Player)player)) == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (MercenaryPlayerData.isMercenaryNotAvailable(playerData, mercenaryName)) {
            Admin.playerRequestError((Player)player, mercenaryName + " is not available.");
            return;
        }
        if (!MercenaryPlayerData.hasPlayerAcceptedAMercenaryQuest(playerData, mercenaryName)) {
            Admin.playerRequestError((Player)player, "Player has not accepted a quest from " + mercenaryName + ".");
            return;
        }
        if (!MercenaryPlayerData.isPlayerChosenMercenaryQuestCompleted(playerData, mercenaryName)) {
            Admin.playerRequestError((Player)player, "Player has not completed chosen quest from " + mercenaryName + ".");
            return;
        }
        Quest.giveQuestRewards(playerData);
        MercenaryPlayerData.incrementMercenaryStat(playerData, mercenaryName, "QuestsSuccess");
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Quest Completed : " + player.m_6302_() + ", mercenary : " + mercenaryName);
        }
        PacketHandler.sendToPlayer("RefreshData", playerData, player);
    }
}

