/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.mercenary;

import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.init.ItemInit;
import io.github.sluggly.timemercenaries.item.DimensionalTimeClock;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.MercenaryDefinition;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.mercenary.Quest;
import io.github.sluggly.timemercenaries.missions.Mission;
import io.github.sluggly.timemercenaries.missions.MissionItem;
import io.github.sluggly.timemercenaries.module.Module;
import io.github.sluggly.timemercenaries.network.PacketHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class Shopkeeper
extends Mercenary {
    public ArrayList<LinkedHashSet<ItemStack>> itemRarityList = new ArrayList();
    public static int maxItems = 10;
    public static final HashMap<String, Integer> mapRarityPrice = new HashMap<String, Integer>(){
        {
            this.put("Common", 5);
            this.put("Uncommon", 15);
            this.put("Rare", 30);
            this.put("Epic", 60);
            this.put("Legendary", 100);
        }
    };

    public Shopkeeper(MercenaryDefinition definition) {
        super(definition);
        for (String ignored : Mission.mapRarityIndex.keySet()) {
            this.itemRarityList.add(new LinkedHashSet());
        }
        this.setupCustomItemShop();
    }

    public static void skipShop(ServerPlayer player, String mercenaryName) {
        PlayerData playerData;
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Received skip Shop : " + player.m_6302_() + ", mercenary : " + mercenaryName);
        }
        if ((playerData = PlayerData.getPlayerData((Player)player)) == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (MercenaryPlayerData.isMercenaryNotAvailable(playerData, mercenaryName)) {
            Admin.playerRequestError((Player)player, "Mercenary is not available.");
            return;
        }
        if (Admin.arePlayerMissionsInstant(player)) {
            MercenaryPlayerData.setMercenaryMissionTimes(playerData, mercenaryName, 5);
        } else {
            MercenaryPlayerData.setMercenaryMissionTimes(playerData, mercenaryName, 150);
        }
        MercenaryPlayerData.setMercenaryMissionStatus(playerData, mercenaryName, "Skipped");
        MercenaryPlayerData.setCurrentMercenary(playerData, mercenaryName);
        DimensionalTimeClock.addMercenaryTimeServer((Player)player, mercenaryName, MercenaryPlayerData.getMercenaryMissionTimeLeft(playerData, mercenaryName));
        MercenaryPlayerData.cleanMercenaryChosenMission(playerData, mercenaryName);
        if (MercenaryPlayerData.hasPlayerAcceptedAMercenaryQuest(playerData, mercenaryName)) {
            MercenaryPlayerData.generateAllMercenaryQuests(playerData, mercenaryName);
        }
        playerData.setState("WaitingMission");
        PacketHandler.sendToPlayer("SkipShopAccept", playerData, player);
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Skipped Shop : " + player.m_6302_() + ", mercenary : " + mercenaryName);
        }
    }

    public static boolean checkIfPlayerHasEnoughCoinsToBuyItem(ServerPlayer player, int index) {
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (playerData == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return false;
        }
        Shopkeeper shopkeeper = (Shopkeeper)Shopkeeper.getMercenary("Vael");
        int playerCoins = MercenaryPlayerData.getCurrentMercenaryCoins(playerData, shopkeeper.name);
        int seed = MercenaryPlayerData.getMercenarySeed(playerData, "Vael");
        int level = MercenaryPlayerData.getMercenaryLevel(playerData, "Vael");
        MissionItem[] shopItems = shopkeeper.getShopItems(seed, level);
        return playerCoins >= shopItems[index].price;
    }

    public static void playerBuyShopItem(ServerPlayer player, int index) {
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (playerData == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (!Module.isModuleActive(playerData, "Caravaneer Module")) {
            Admin.playerRequestError((Player)player, "Caravaneer Module is not active.");
            return;
        }
        if (MercenaryPlayerData.isMercenaryNotAvailable(playerData, "Vael")) {
            Admin.playerRequestError((Player)player, "Vael is not available.");
            return;
        }
        if (!MercenaryPlayerData.isShopkeeperItemAvailable(playerData, "Vael", index)) {
            Admin.playerRequestError((Player)player, "Item at index " + index + " is not available.");
            return;
        }
        if (!Shopkeeper.checkIfPlayerHasEnoughCoinsToBuyItem(player, index)) {
            Admin.playerRequestError((Player)player, "Not enough coins to buy item.");
            return;
        }
        MercenaryPlayerData.setShopkeeperItemBought(playerData, "Vael", index);
        Shopkeeper shopkeeper = (Shopkeeper)Shopkeeper.getMercenary("Vael");
        int seed = MercenaryPlayerData.getMercenarySeed(playerData, "Vael");
        int level = MercenaryPlayerData.getMercenaryLevel(playerData, "Vael");
        MissionItem boughtItem = shopkeeper.getShopItems(seed, level)[index];
        MercenaryPlayerData.setMercenaryCoins(playerData, shopkeeper.name, MercenaryPlayerData.getCurrentMercenaryCoins(playerData, shopkeeper.name) - boughtItem.price);
        MercenaryPlayerData.incrementShopkeeperItemRarityStat(playerData, shopkeeper.name, boughtItem.rarity);
        ItemStack rewardStack = boughtItem.itemStack.m_41777_();
        int number = boughtItem.number;
        rewardStack.m_41764_(number);
        player.m_36176_(rewardStack, true);
        int totalExp = boughtItem.price * 10;
        MercenaryPlayerData.mercenaryGainExp(playerData, shopkeeper.name, totalExp);
        Quest.updateQuestOnShopItemBuy(playerData);
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Bought %d ".formatted(boughtItem.number) + boughtItem.getName());
        }
        PacketHandler.sendToPlayer("RefreshData", playerData, player);
    }

    public void setupCustomItemShop() {
        this.itemRarityList.get(Mission.mapRarityIndex.get("Legendary")).add(((Item)ItemInit.CAP_OF_COMMERCE.get()).m_7968_());
        this.itemRarityList.get(Mission.mapRarityIndex.get("Legendary")).add(((Item)ItemInit.GUILD_BEARERS_SEAL.get()).m_7968_());
    }

    public boolean isItemBlacklisted(ItemStack stack) {
        if (stack.m_41720_() == ItemInit.VOID_WOVEN_GREAVES.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.GILDED_GRUDGE.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.OCEAN_SOUL.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.PRIMORDIAL_GROWTH_MOSS.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.DELIRIUM_CONCOCTION.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.WALKING_STICK.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.PRIMAL_HUNTING_SPEAR.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.SWORD_OF_CHICKENING.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.CONSTELLAR_STAFF.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.THUNDER_IN_A_BOTTLE.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.RAINBOW_TIMECRYSTAL.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.CHAINS_OF_SUPREMACY.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.HEART_OF_THE_MOUNTAIN.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.VOID_WOVEN_LEGGINGS.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.TALISMAN_OF_THE_WILDS.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.HELM_OF_THE_FIRST_EXPLORER.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.HYDRO_GEM_OF_EVERGROWTH.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.BRUTES_WAR_HORN.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.VOLATILE_CONCOCTION_CASING.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.TOME_OF_SYNTHESIS.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.TRANSMUTERS_GIZZARD.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.RIFT_IN_A_BOTTLE.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.DICE_OF_INFINITE_POSSIBILITIES.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.GOLEMANCERS_CORE.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.FORGEHEART_CHARM.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.MANTLE_OF_THE_GROVE_WARDEN.get()) {
            return true;
        }
        if (stack.m_41720_() == ItemInit.BEASTBINDER_WAND.get()) {
            return true;
        }
        return stack.m_41720_() == ItemInit.EVERFULL_FEEDBAG.get();
    }

    public void addItemToList(String rarity, ItemStack item) {
        if (this.isItemBlacklisted(item)) {
            return;
        }
        this.itemRarityList.get(Mission.mapRarityIndex.get(rarity)).add(item);
    }

    public MissionItem[] getShopItems(int seed, int shopkeeperLevel) {
        MissionItem[] items = new MissionItem[maxItems];
        Random random = new Random(seed);
        int[] rarityProbability = Shopkeeper.getShopItemsProbability(shopkeeperLevel);
        for (int i = 0; i < maxItems; ++i) {
            int randomValue = random.nextInt(100);
            int rarity = 0;
            while (randomValue > rarityProbability[rarity]) {
                ++rarity;
            }
            int maxItemStack = (rarityProbability.length - rarity) * 2;
            LinkedHashSet<ItemStack> shopItems = this.itemRarityList.get(rarity);
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>(shopItems);
            int randomValueStack = random.nextInt(maxItemStack);
            int randomValueIndex = random.nextInt(itemList.size());
            int randomValuePrice = random.nextInt(4);
            items[i] = new MissionItem(randomValueStack + 1, itemList.get(randomValueIndex));
            items[i].price = mapRarityPrice.get(Mission.arrayRarityIndex[rarity]) + rarity * randomValuePrice;
            items[i].rarity = Mission.arrayRarityIndex[rarity];
        }
        return items;
    }

    public static int[] getShopItemsProbability(int shopkeeperLevel) {
        if (shopkeeperLevel < 3) {
            return new int[]{100, 0, 0, 0, 0};
        }
        if (shopkeeperLevel < 5) {
            return new int[]{80, 100, 0, 0, 0};
        }
        if (shopkeeperLevel < 7) {
            return new int[]{65, 85, 100, 0, 0};
        }
        if (shopkeeperLevel < 10) {
            return new int[]{35, 65, 85, 100, 0};
        }
        return new int[]{10, 40, 70, 95, 100};
    }

    public static void playerOpenShop(ServerPlayer player) {
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (playerData == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (!playerData.getCurrentState().equals("Recruiting")) {
            Admin.playerRequestError((Player)player, "Wrong state, expected Recruiting received " + playerData.getCurrentState() + ".");
            return;
        }
        if (!Module.isModuleActive(playerData, "Caravaneer Module")) {
            Admin.playerRequestError((Player)player, "Caravaneer Module is not active.");
            return;
        }
        if (MercenaryPlayerData.isMercenaryNotAvailable(playerData, "Vael")) {
            Admin.playerRequestError((Player)player, "Vael is not available.");
            return;
        }
        PacketHandler.sendToPlayer("OpenShopScreen", playerData, player);
    }

    public static void playerOpenQuest(ServerPlayer player) {
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (playerData == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (!playerData.getCurrentState().equals("Recruiting")) {
            Admin.playerRequestError((Player)player, "Wrong state, expected Recruiting received " + playerData.getCurrentState() + ".");
            return;
        }
        if (!Module.isModuleActive(playerData, "Caravaneer Questing Module")) {
            Admin.playerRequestError((Player)player, "Caravaneer Questing Module is not active.");
            return;
        }
        if (MercenaryPlayerData.isMercenaryNotAvailable(playerData, "Vael")) {
            Admin.playerRequestError((Player)player, "Vael is not available.");
            return;
        }
        MercenaryPlayerData.generateAllMercenaryQuestsIfNecessary(playerData, "Vael");
        PacketHandler.sendToPlayer("OpenQuestScreen", playerData, player);
    }

    @Override
    public LinkedHashSet<MissionItem> getMercenaryAllPossibleRewards() {
        LinkedHashSet<MissionItem> allPossibleRewards = new LinkedHashSet<MissionItem>();
        allPossibleRewards.add(new MissionItem(1, (Item)ItemInit.CAP_OF_COMMERCE.get()));
        allPossibleRewards.add(new MissionItem(1, (Item)ItemInit.GUILD_BEARERS_SEAL.get()));
        for (MissionItem item : allPossibleRewards) {
            item.rarity = "Legendary";
        }
        return allPossibleRewards;
    }
}

