/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.missions;

import io.github.sluggly.timemercenaries.TimeMercenaryAdvancements;
import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.entity.Portal;
import io.github.sluggly.timemercenaries.init.ItemInit;
import io.github.sluggly.timemercenaries.item.DimensionalTimeClock;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.mercenary.Quest;
import io.github.sluggly.timemercenaries.mercenary.Trait;
import io.github.sluggly.timemercenaries.missions.MissionDefinition;
import io.github.sluggly.timemercenaries.missions.MissionItem;
import io.github.sluggly.timemercenaries.missions.MissionManager;
import io.github.sluggly.timemercenaries.module.Module;
import io.github.sluggly.timemercenaries.network.PacketHandler;
import io.github.sluggly.timemercenaries.utils.NBTKeys;
import io.github.sluggly.timemercenaries.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class Mission {
    public final ResourceLocation id;
    public final String description;
    public final String mercenaryName;
    private final MissionItem[] requiredItems;
    private final MissionItem[] successItems;
    private final MissionItem[] failItems;
    public final String failDescription;
    public final String successDescription;
    public final String rarity;
    public final ResourceLocation backgroundTexture;
    public final int failChance;
    public final int failDamage;
    public final boolean isRandomMission;
    public static final String[] arrayRarityIndex = new String[]{"Common", "Uncommon", "Rare", "Epic", "Legendary"};
    public static final String randomMissionPrefix = "timemercenaries:random/";
    public static final HashMap<String, Integer> mapRarityIndex = new HashMap<String, Integer>(){
        {
            this.put("Common", 0);
            this.put("Uncommon", 1);
            this.put("Rare", 2);
            this.put("Epic", 3);
            this.put("Legendary", 4);
        }
    };
    public static final HashMap<String, Integer> mapRarityToColor = new HashMap<String, Integer>(){
        {
            this.put("Common", 0xFFFFFF);
            this.put("Uncommon", 65280);
            this.put("Rare", 255);
            this.put("Epic", 0x800080);
            this.put("Legendary", 16753920);
        }
    };
    public static final HashMap<String, Integer> mapRarityToTime = new HashMap<String, Integer>(){
        {
            this.put("Common", 150);
            this.put("Uncommon", 210);
            this.put("Rare", 360);
            this.put("Epic", 600);
            this.put("Legendary", 900);
        }
    };
    public static final HashMap<String, Integer> mapRarityToExperience = new HashMap<String, Integer>(){
        {
            this.put("Common", 40);
            this.put("Uncommon", 90);
            this.put("Rare", 150);
            this.put("Epic", 300);
            this.put("Legendary", 500);
        }
    };
    private static final HashMap<String, Integer> mapDurationColor = new HashMap<String, Integer>(){
        {
            this.put("Very Short", 65280);
            this.put("Short", 0x50FF00);
            this.put("Normal", 0xFFFFFF);
            this.put("Long", 0xFF5000);
            this.put("Very Long", 0xFF0000);
        }
    };
    public static final HashMap<String, Integer> mapFailChanceColor = new HashMap<String, Integer>(){
        {
            this.put("Infallible", 65280);
            this.put("Unlikely", 0xFFFFFF);
            this.put("Unclear", 0x500050);
            this.put("Likely", 0xFF00FF);
            this.put("Certain", 0xFF0000);
        }
    };
    public static final HashMap<String, Integer> mapDeathChanceColor = new HashMap<String, Integer>(){
        {
            this.put("Safe", 65280);
            this.put("Harmless", 0xFFFFFF);
            this.put("Risky", 0x500050);
            this.put("Deadly", 0xFF00FF);
            this.put("Suicide", 0xFF0000);
        }
    };
    public static final HashMap<String, Item> mapRarityRerollItem = new HashMap<String, Item>(){
        {
            this.put("Common", (Item)ItemInit.TIMECRYSTRAL.get());
            this.put("Uncommon", (Item)ItemInit.GREEN_TIMECRYSTRAL.get());
            this.put("Rare", (Item)ItemInit.BLUE_TIMECRYSTRAL.get());
            this.put("Epic", (Item)ItemInit.BLUE_TIMECRYSTRAL.get());
            this.put("Legendary", (Item)ItemInit.RED_TIMECRYSTRAL.get());
        }
    };
    public static final HashMap<Integer, String> mapIndexDifficulty = new HashMap<Integer, String>(){
        {
            this.put(0, "Normal");
            this.put(1, "Heroic");
            this.put(2, "Mythic");
        }
    };
    public static final HashMap<String, Integer> mapRarityMaxCoins = new HashMap<String, Integer>(){
        {
            this.put("Common", 5);
            this.put("Uncommon", 10);
            this.put("Rare", 15);
            this.put("Epic", 30);
            this.put("Legendary", 100);
        }
    };
    public static final HashMap<String, Integer> mapRarityToHunger = new HashMap<String, Integer>(){
        {
            this.put("Common", 6);
            this.put("Uncommon", 8);
            this.put("Rare", 11);
            this.put("Epic", 15);
            this.put("Legendary", 18);
        }
    };
    public static Integer VERY_SHORT_DURATION = 30;
    public static Integer SHORT_DURATION = 120;
    public static Integer NORMAL_DURATION = 200;
    public static Integer LONG_DURATION = 400;
    public static Integer MEAGER_EXPERIENCE = 100;
    public static Integer MODEST_EXPERIENCE = 200;
    public static Integer DECENT_EXPERIENCE = 300;
    public static Integer GENEROUS_EXPERIENCE = 1000;
    public static Integer HUNGER_LOW = 5;
    public static Integer HUNGER_MEDIUM = 8;
    public static Integer HUNGER_HIGH = 11;
    public static Integer HUNGER_VERY_HIGH = 15;

    public Mission(String description, String mercenaryName, MissionItem[] requiredItems, MissionItem[] successItems, MissionItem[] failItems, String failDescription, String rarity, int failChance, int failDamage) {
        this.id = new ResourceLocation("timemercenaries", "random/" + Mission.sanitize(mercenaryName) + "/" + Mission.sanitize(rarity));
        this.description = description;
        this.mercenaryName = mercenaryName;
        this.requiredItems = requiredItems;
        this.successItems = successItems;
        this.failItems = failItems;
        this.failDescription = Objects.requireNonNullElse(failDescription, "The mercenary failed to fulfill his mission.");
        this.successDescription = "The Mercenary correctly managed to fulfill his mission! He gained experience from it and you receive your fair share of the loot.";
        this.rarity = rarity;
        this.failChance = failChance;
        this.failDamage = failDamage;
        this.backgroundTexture = null;
        this.isRandomMission = true;
        for (MissionItem item : this.successItems) {
            item.rarity = this.rarity;
        }
    }

    public Mission(ResourceLocation id, MissionDefinition definition) {
        this.id = id;
        this.description = definition.description();
        this.mercenaryName = definition.mercenary();
        this.requiredItems = definition.requiredItems().toArray(new MissionItem[0]);
        this.successItems = definition.successItems().toArray(new MissionItem[0]);
        this.failItems = definition.failItems().toArray(new MissionItem[0]);
        this.failDescription = definition.failDescription().orElse("The mercenary failed to fulfill his mission.");
        this.successDescription = "The Mercenary correctly managed to fulfill his mission! He gained experience from it and you receive your fair share of the loot.";
        this.rarity = definition.rarity();
        this.failChance = definition.failChance();
        this.failDamage = definition.failDamage();
        String tmpBackground = definition.backgroundTexture().orElse(null);
        this.backgroundTexture = tmpBackground != null ? new ResourceLocation("timemercenaries", "textures/gui/" + String.valueOf(definition.backgroundTexture()) + ".png") : null;
        this.isRandomMission = false;
        for (MissionItem item : this.successItems) {
            item.rarity = this.rarity;
        }
    }

    public static int getMissionMaxCoins(String rarity) {
        return mapRarityMaxCoins.get(rarity);
    }

    public static String getFailChanceString(int percent) {
        if (percent == 0) {
            return "Infallible";
        }
        if (percent < 5) {
            return "Unlikely";
        }
        if (percent < 30) {
            return "Unclear";
        }
        if (percent < 80) {
            return "Likely";
        }
        return "Certain";
    }

    public static String getFailDamageString(int failDamage) {
        if (failDamage <= 0) {
            return "Safe";
        }
        if (failDamage == 1) {
            return "Harmless";
        }
        if (failDamage <= 3) {
            return "Risky";
        }
        if (failDamage <= 5) {
            return "Deadly";
        }
        return "Suicide";
    }

    public static Integer getMissionDurationColor(String duration) {
        return mapDurationColor.get(duration);
    }

    public static Integer getMissionDurationColor(int duration) {
        return mapDurationColor.get(Mission.getMissionLengthString(duration));
    }

    public static String getMissionLengthString(int time) {
        if (time <= VERY_SHORT_DURATION) {
            return "Very Short";
        }
        if (time <= SHORT_DURATION) {
            return "Short";
        }
        if (time <= NORMAL_DURATION) {
            return "Normal";
        }
        if (time <= LONG_DURATION) {
            return "Long";
        }
        return "Very Long";
    }

    public static boolean checkIfPlayerHasResourcesToStartMission(ResourceLocation missionId, Player player, boolean isServerSide) {
        PlayerData playerData = PlayerData.getPlayerData((Player)(isServerSide ? player : null));
        if (playerData == null) {
            Admin.playerRequestError(player, "Player Data is null.");
            return false;
        }
        Mission mission = Mission.getMissionFromId(missionId);
        String mercenaryName = MercenaryPlayerData.getCurrentMercenary(playerData);
        int seed = MercenaryPlayerData.getMercenaryMissionSeed(playerData, mercenaryName, missionId);
        assert (mission != null);
        for (MissionItem missionItem : mission.getRequiredItems(seed)) {
            if (Utils.hasEnoughItems(missionItem.itemStack.m_41720_(), player, missionItem.number)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkIfPlayerCanRerollMission(Player player, ResourceLocation missionId, boolean isServerSide) {
        PlayerData playerData = PlayerData.getPlayerData((Player)(isServerSide ? player : null));
        if (playerData == null) {
            Admin.playerRequestError(player, "Player Data is null.");
            return false;
        }
        Mission mission = Mission.getMissionFromId(missionId);
        assert (mission != null);
        return Utils.hasEnoughItems(Mission.getRerollItem(mission.rarity), player, 1);
    }

    public static void rerollMission(ServerPlayer player, String mercenaryName, ResourceLocation missionId) {
        PlayerData playerData;
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Received reroll Mission : " + player.m_6302_() + ", mercenary : " + mercenaryName + ", index : " + String.valueOf(missionId));
        }
        if ((playerData = PlayerData.getPlayerData((Player)player)) == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (MercenaryPlayerData.isMercenaryOnMission(playerData, mercenaryName)) {
            Admin.playerRequestError((Player)player, "Mercenary is on mission.");
            return;
        }
        if (!MercenaryPlayerData.getCurrentMercenary(playerData).equals(mercenaryName)) {
            Admin.playerRequestError((Player)player, "Current mercenary does not match. Received " + mercenaryName + " expected " + MercenaryPlayerData.getCurrentMercenary(playerData) + ".");
            return;
        }
        if (!MercenaryPlayerData.isMercenaryMissionAvailable(playerData, mercenaryName, missionId)) {
            Admin.playerRequestError((Player)player, "Mercenary does not have available mission with id " + String.valueOf(missionId) + ".");
            return;
        }
        if (MercenaryPlayerData.getMercenaryMissionRerollLeft(playerData, mercenaryName) <= 0) {
            Admin.playerRequestError((Player)player, "Mercenary does not have any mission reroll left.");
            return;
        }
        MercenaryPlayerData.rerollMercenaryMission(playerData, mercenaryName, missionId);
        PacketHandler.sendToPlayer("RefreshData", playerData, player);
    }

    public static void sameRerollMission(ServerPlayer player, String mercenaryName, ResourceLocation missionId) {
        PlayerData playerData;
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Received same reroll Mission : " + player.m_6302_() + ", mercenary : " + mercenaryName + ", index : " + String.valueOf(missionId));
        }
        if ((playerData = PlayerData.getPlayerData((Player)player)) == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (MercenaryPlayerData.isMercenaryOnMission(playerData, mercenaryName)) {
            Admin.playerRequestError((Player)player, "Mercenary is on mission.");
            return;
        }
        if (!MercenaryPlayerData.getCurrentMercenary(playerData).equals(mercenaryName)) {
            Admin.playerRequestError((Player)player, "Current mercenary does not match. Received " + mercenaryName + " expected " + MercenaryPlayerData.getCurrentMercenary(playerData) + ".");
            return;
        }
        if (!MercenaryPlayerData.isMercenaryMissionAvailable(playerData, mercenaryName, missionId)) {
            Admin.playerRequestError((Player)player, "Mercenary does not have available mission with id " + String.valueOf(missionId) + ".");
            return;
        }
        if (MercenaryPlayerData.getMercenaryMissionRerollLeft(playerData, mercenaryName) <= 0) {
            Admin.playerRequestError((Player)player, "Mercenary does not have any mission reroll left.");
            return;
        }
        if (!Mission.checkIfPlayerCanRerollMission((Player)player, missionId, true)) {
            Admin.playerRequestError((Player)player, "Player does not have item requirement.");
            return;
        }
        Mission mission = Mission.getMissionFromId(missionId);
        assert (mission != null);
        Utils.removeItemInInventory(Mission.getRerollItem(mission.rarity), 1, (Player)player);
        MercenaryPlayerData.sameRerollMercenaryMission(playerData, mercenaryName, missionId);
        PacketHandler.sendToPlayer("RefreshData", playerData, player);
    }

    public static void skipMission(ServerPlayer player, String mercenaryName) {
        PlayerData playerData;
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Received skip Mission : " + player.m_6302_() + ", mercenary : " + mercenaryName);
        }
        if ((playerData = PlayerData.getPlayerData((Player)player)) == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (MercenaryPlayerData.isMercenaryNotAvailable(playerData, mercenaryName)) {
            Admin.playerRequestError((Player)player, "Mercenary is not available.");
            return;
        }
        if (!MercenaryPlayerData.isMercenaryIdle(playerData, mercenaryName)) {
            Admin.playerRequestError((Player)player, "Mercenary is not idle.");
            return;
        }
        if (Module.isModuleActive(playerData, "Skipping Module") || playerData.getCurrentState().equals("SendingMission")) {
            if (Admin.arePlayerMissionsInstant(player)) {
                MercenaryPlayerData.setMercenaryMissionTimes(playerData, mercenaryName, 5);
            } else {
                MercenaryPlayerData.setMercenaryMissionTimes(playerData, mercenaryName, 150);
            }
            MercenaryPlayerData.setMercenaryMissionStatus(playerData, mercenaryName, "Skipped");
        }
        DimensionalTimeClock.addMercenaryTimeServer((Player)player, mercenaryName, MercenaryPlayerData.getMercenaryMissionTimeLeft(playerData, mercenaryName));
        MercenaryPlayerData.cleanMercenaryChosenMission(playerData, mercenaryName);
        if (playerData.getCurrentState().equals("SendingMission")) {
            playerData.setState("WaitingMission");
        }
        PacketHandler.sendToPlayer("MissionSkipAccept", playerData, player);
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Skipped Missions : " + player.m_6302_() + ", mercenary : " + mercenaryName);
        }
    }

    public static void sendMission(ServerPlayer player, String mercenaryName, ResourceLocation missionId) {
        PlayerData playerData;
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Received send Mission : " + player.m_6302_() + ", mercenary : " + mercenaryName + ", index : " + String.valueOf(missionId));
        }
        if ((playerData = PlayerData.getPlayerData((Player)player)) == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (MercenaryPlayerData.isMercenaryNotAvailable(playerData, mercenaryName)) {
            Admin.playerRequestError((Player)player, "Mercenary is not available.");
            return;
        }
        if (!MercenaryPlayerData.isMercenaryIdle(playerData, mercenaryName)) {
            Admin.playerRequestError((Player)player, "Mercenary is not idle.");
            return;
        }
        if (missionId.toString().equals(NBTKeys.MISSION_EMPTY_ID.toString())) {
            Admin.playerRequestError((Player)player, "MissionId is None.");
            return;
        }
        if (!playerData.getCurrentState().equals("SendingMission")) {
            Admin.playerRequestError((Player)player, "Player State is not SendingMission.");
            return;
        }
        Mission mission = Mission.getMissionFromId(missionId);
        if (mission == null) {
            Admin.playerRequestError((Player)player, "Mission is null.");
            return;
        }
        boolean isMissionFree = MercenaryPlayerData.doesMercenaryProcurerTraitProc(playerData, mercenaryName, missionId);
        int missionSeed = MercenaryPlayerData.getMercenaryMissionSeed(playerData, mercenaryName, missionId);
        if (!isMissionFree) {
            if (!Mission.checkIfPlayerHasResourcesToStartMission(missionId, (Player)player, true)) {
                Admin.playerRequestError((Player)player, "Player does not have resources for mission, but tried to start it.");
                return;
            }
            for (MissionItem missionItem : mission.getRequiredItems(missionSeed)) {
                if (Utils.hasEnoughItems(missionItem.itemStack.m_41720_(), (Player)player, missionItem.number)) continue;
                Admin.playerRequestError((Player)player, "Player has not enough item to start Mission");
                return;
            }
            for (MissionItem missionItem : mission.getRequiredItems(missionSeed)) {
                Utils.removeItemInInventory(missionItem.itemStack.m_41720_(), missionItem.number, (Player)player);
            }
            Portal.playPortalAnimation(player, mission, missionSeed);
        }
        if (Admin.arePlayerMissionsInstant(player)) {
            MercenaryPlayerData.setMercenaryMissionTimes(playerData, mercenaryName, 5);
        } else {
            int difficulty = MercenaryPlayerData.getMercenaryMissionDifficultyIndex(playerData, mercenaryName, missionId);
            int time = MercenaryPlayerData.getMercenaryMissionUpdatedTime(playerData, mercenaryName, Mission.getMissionTime(mission.rarity, missionSeed), difficulty);
            MercenaryPlayerData.setMercenaryMissionTimes(playerData, mercenaryName, time);
        }
        MercenaryPlayerData.setMercenaryMissionStatus(playerData, mercenaryName, "Ongoing");
        DimensionalTimeClock.addMercenaryTimeServer((Player)player, mercenaryName, MercenaryPlayerData.getMercenaryMissionTimeLeft(playerData, mercenaryName));
        MercenaryPlayerData.setMercenaryChosenMission(playerData, mercenaryName, missionId.toString());
        MercenaryPlayerData.incrementMercenarySentMissionStat(playerData, mercenaryName, mission.rarity);
        if (playerData.getCurrentState().equals("SendingMission")) {
            playerData.setState("WaitingMission");
        }
        PacketHandler.sendToPlayer("MissionSentAccept", playerData, player);
        TimeMercenaryAdvancements.checkAndTestGrantAdvancement(player, "Send Mission");
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Mission sent : " + player.m_6302_() + ", mercenary : " + mercenaryName + ", index : " + String.valueOf(missionId));
        }
    }

    public static void generateMissionResult(ServerPlayer serverPlayer, String mercenaryName) {
        PlayerData playerData = PlayerData.getPlayerData((Player)serverPlayer);
        if (playerData == null) {
            Admin.playerRequestError((Player)serverPlayer, "Player Data is null.");
            return;
        }
        if (!MercenaryPlayerData.getMercenaryMissionStatus(playerData, mercenaryName).equals("EndMission")) {
            Admin.playerRequestError((Player)serverPlayer, "Wrong Mercenary Mission Status expected EndMission received " + MercenaryPlayerData.getMercenaryMissionStatus(playerData, mercenaryName) + ".");
            return;
        }
        ResourceLocation missionId = MercenaryPlayerData.getMercenaryChosenMission(playerData, mercenaryName);
        if (missionId.toString().equals(NBTKeys.MISSION_EMPTY_ID.toString())) {
            playerData.setState("Recruiting");
            MercenaryPlayerData.setCurrentMercenary(playerData, "None");
            MercenaryPlayerData.finishMercenaryMission(playerData, mercenaryName, "Skipped");
            MercenaryPlayerData.healMercenaryPercent(playerData, mercenaryName, 25);
            if (!mercenaryName.equals("Vael")) {
                int currentHunger = MercenaryPlayerData.getMercenaryCurrentHunger(playerData, mercenaryName);
                int maxHunger = MercenaryPlayerData.getMercenaryMaximumHunger(playerData, mercenaryName);
                int newHunger = Math.min(maxHunger, currentHunger + 2);
                MercenaryPlayerData.setMercenaryHunger(playerData, mercenaryName, newHunger);
            }
            MercenaryPlayerData.generateRecruitsIfNecessary(playerData);
            PacketHandler.sendToPlayer("OpenRecruitScreen", playerData, serverPlayer);
        } else {
            int result = 0;
            Mission mission = Mission.getMissionFromId(missionId);
            assert (mission != null);
            int currentHunger = MercenaryPlayerData.getMercenaryCurrentHunger(playerData, mercenaryName);
            int hungerCost = Mission.getMissionHungerCost(mission.rarity, MercenaryPlayerData.getMercenaryMissionSeed(playerData, mercenaryName, missionId));
            MercenaryPlayerData.setMercenaryHunger(playerData, mercenaryName, Math.max(currentHunger - hungerCost, 0));
            int hungerRest = hungerCost - currentHunger;
            if (hungerRest > 0) {
                MercenaryPlayerData.damageMercenary(playerData, mercenaryName, hungerRest * 2);
                if (MercenaryPlayerData.isMercenaryDead(playerData, mercenaryName)) {
                    result = 2;
                }
            }
            if (result != 2) {
                int difficulty = MercenaryPlayerData.getMercenaryMissionDifficultyIndex(playerData, mercenaryName, missionId);
                Random random = new Random();
                if (random.nextInt(100) < MercenaryPlayerData.getMercenaryMissionUpdatedFailChance(playerData, mercenaryName, mission.failChance, difficulty)) {
                    result = 1;
                    MercenaryPlayerData.damageMercenary(playerData, mercenaryName, MercenaryPlayerData.getMercenaryMissionUpdatedDamages(mission.failDamage, difficulty));
                    if (MercenaryPlayerData.isMercenaryDead(playerData, mercenaryName)) {
                        result = 2;
                    }
                }
            }
            if (result == 0) {
                MercenaryPlayerData.setMercenaryMissionStatus(playerData, mercenaryName, "Success");
            } else if (result == 1) {
                MercenaryPlayerData.setMercenaryMissionStatus(playerData, mercenaryName, "Failed");
            } else {
                MercenaryPlayerData.setMercenaryMissionStatus(playerData, mercenaryName, "Death");
            }
            playerData.setState("EndMission");
            PacketHandler.sendToPlayer("OpenEndMissionScreen", playerData, serverPlayer);
        }
    }

    private static void missionSuccess(ServerPlayer player, PlayerData playerData, String mercenaryName) {
        ResourceLocation missionId = MercenaryPlayerData.getMercenaryChosenMission(playerData, mercenaryName);
        Mission mission = Mission.getMissionFromId(missionId);
        int missionSeed = MercenaryPlayerData.getMercenaryMissionSeed(playerData, mercenaryName, missionId);
        int mercenarySeed = MercenaryPlayerData.getMercenarySeed(playerData, mercenaryName);
        int multiplier = MercenaryPlayerData.getMercenaryMissionTotalMultiplier(playerData, mercenaryName, missionId);
        assert (mission != null);
        MissionItem[] successItems = mission.getSuccessItems(missionSeed);
        if (Module.doesDimensionalGlitchModuleProc(playerData, mercenaryName)) {
            Mercenary mercenary = Mercenary.getMercenary(mercenaryName);
            MissionItem[] glitchItems = mercenary.getDimensionalGlitchSuccessItems(mercenarySeed, mission.rarity);
            MissionItem[] combinedItems = new MissionItem[successItems.length + glitchItems.length];
            System.arraycopy(successItems, 0, combinedItems, 0, successItems.length);
            System.arraycopy(glitchItems, 0, combinedItems, successItems.length, glitchItems.length);
            successItems = combinedItems;
        }
        int difficulty = MercenaryPlayerData.getMercenaryMissionDifficultyIndex(playerData, mercenaryName, missionId);
        int baseMissionExp = Mission.getMissionExperience(mission.rarity, missionSeed);
        MercenaryPlayerData.mercenaryGainMissionExp(playerData, mercenaryName, baseMissionExp, difficulty);
        int playerExperience = 0;
        if (Module.isModuleActive(playerData, "Multi-EXP Module")) {
            int totalMissionExp = MercenaryPlayerData.getMercenaryMissionUpdatedExperience(playerData, mercenaryName, baseMissionExp, difficulty);
            playerExperience = (int)((double)totalMissionExp * 0.1);
            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println("Multi-EXP Module: Gave " + playerExperience + " XP to player " + player.m_7755_().getString());
            }
            if (Module.isModuleActive(playerData, "EXP-All Module")) {
                for (String otherMercenaryName : Mercenary.getMercenariesName()) {
                    if (otherMercenaryName.equals(mercenaryName)) continue;
                    MercenaryPlayerData.mercenaryGainExp(playerData, otherMercenaryName, playerExperience);
                }
            }
        }
        Portal.playPortalAnimation(player, successItems, multiplier, playerExperience, Portal.PortalType.BLUE);
        if (Module.isModuleActive(playerData, "Coin Module")) {
            int totalCoins = MercenaryPlayerData.getMercenaryMissionTotalCoins(playerData, mercenaryName, missionId);
            MercenaryPlayerData.addMercenaryCoins(playerData, "Vael", totalCoins);
            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println("Coin Module: Gave " + totalCoins + " coins to player " + player.m_7755_().getString());
            }
        }
        if (MercenaryPlayerData.doesMercenaryScavengerTraitProc(playerData, mercenaryName)) {
            int randomValue = MercenaryPlayerData.getMercenaryScavengerTraitValue(playerData, mercenaryName);
            Trait trait = Trait.getTrait(randomValue);
            MercenaryPlayerData.increaseMercenaryTraitLevel(playerData, mercenaryName, trait.name);
        }
        MercenaryPlayerData.incrementMercenarySuccessMissionStat(playerData, mercenaryName, mission.rarity);
    }

    private static void missionFailed(ServerPlayer player, PlayerData playerData, String mercenaryName) {
        ResourceLocation missionId = MercenaryPlayerData.getMercenaryChosenMission(playerData, mercenaryName);
        Mission mission = Mission.getMissionFromId(missionId);
        int multiplier = MercenaryPlayerData.getMercenaryMissionTotalMultiplier(playerData, mercenaryName, missionId);
        assert (mission != null);
        MissionItem[] failedItems = mission.getFailedItems();
        if (failedItems.length > 0) {
            Portal.playPortalAnimation(player, failedItems, multiplier, 0, Portal.PortalType.RED);
        }
    }

    private static void missionDeath(PlayerData playerData, String mercenaryName) {
        if (MercenaryPlayerData.doesMercenaryHaveTotem(playerData, mercenaryName)) {
            MercenaryPlayerData.setMercenaryTotem(playerData, mercenaryName, false);
            MercenaryPlayerData.healMercenaryFull(playerData, mercenaryName);
        } else {
            MercenaryPlayerData.applyMercenaryDeathPenalty(playerData, mercenaryName);
        }
    }

    public static void finishMission(ServerPlayer player, String mercenaryName) {
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        String missionStatus = MercenaryPlayerData.getMercenaryMissionStatus(playerData, mercenaryName);
        switch (missionStatus) {
            case "Success": {
                Mission.missionSuccess(player, playerData, mercenaryName);
                break;
            }
            case "Failed": {
                Mission.missionFailed(player, playerData, mercenaryName);
                break;
            }
            case "Death": {
                Mission.missionDeath(playerData, mercenaryName);
                break;
            }
            default: {
                if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                    System.out.println("No ongoing mission, status: " + missionStatus);
                }
                return;
            }
        }
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Mission completed, status: " + missionStatus);
        }
        for (String otherMercenaryName : Mercenary.getMercenariesName()) {
            int maxHunger;
            int currentHunger;
            if (otherMercenaryName.equals(mercenaryName) || otherMercenaryName.equals("Vael") || (currentHunger = MercenaryPlayerData.getMercenaryCurrentHunger(playerData, otherMercenaryName)) >= (maxHunger = MercenaryPlayerData.getMercenaryMaximumHunger(playerData, otherMercenaryName))) continue;
            MercenaryPlayerData.setMercenaryHunger(playerData, otherMercenaryName, currentHunger + 1);
        }
        Quest.updateQuestOnMission(playerData);
        playerData.setState("Recruiting");
        MercenaryPlayerData.setCurrentMercenary(playerData, "None");
        MercenaryPlayerData.finishMercenaryMission(playerData, mercenaryName, missionStatus);
        MercenaryPlayerData.generateRecruitsIfNecessary(playerData);
        PacketHandler.sendToPlayer("FinishMission", playerData, player);
        TimeMercenaryAdvancements.checkAndTestGrantAdvancement(player, "Level Up");
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Completed Finish Mission");
        }
    }

    public static void changeMissionDifficulty(ServerPlayer player, String mercenaryName, ResourceLocation missionId) {
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (playerData == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (!playerData.getCurrentState().equals("SendingMission")) {
            Admin.playerRequestError((Player)player, "Wrong state, expected SendingMission received " + playerData.getCurrentState() + ".");
            return;
        }
        if (!Module.isModuleActive(playerData, "Heroic Difficulty Module")) {
            Admin.playerRequestError((Player)player, "Heroic Difficulty Module is not active.");
            return;
        }
        MercenaryPlayerData.changeMercenaryMissionDifficulty(playerData, mercenaryName, missionId);
        PacketHandler.sendToPlayer("RefreshData", playerData, player);
    }

    public MissionItem[] getRequiredItems(int seed) {
        if (this.isRandomMission) {
            int[] randomValues = new int[]{11, 50, 123, 674};
            int number = (seed + mapRarityIndex.get(this.rarity)) % 4 + 1;
            ArrayList<MissionItem> items = new ArrayList<MissionItem>();
            HashSet<Item> uniqueItems = new HashSet<Item>();
            for (int i = 0; i < number; ++i) {
                MissionItem missionItem = this.requiredItems[seed % randomValues[i] % this.requiredItems.length];
                if (uniqueItems.contains(missionItem.itemStack.m_41720_())) continue;
                uniqueItems.add(missionItem.itemStack.m_41720_());
                items.add(missionItem);
            }
            return items.toArray(new MissionItem[0]);
        }
        return this.requiredItems;
    }

    public MissionItem[] getSuccessItems(int seed) {
        if (this.isRandomMission) {
            int[] randomValues = new int[]{12, 51, 124, 675};
            int number = (seed + mapRarityIndex.get(this.rarity)) % 4 + 1;
            ArrayList<MissionItem> items = new ArrayList<MissionItem>();
            HashSet<Item> uniqueItems = new HashSet<Item>();
            HashSet<EntityType> uniqueEntities = new HashSet<EntityType>();
            for (int i = 0; i < number; ++i) {
                MissionItem missionItem = this.successItems[seed % randomValues[i] % this.successItems.length];
                if (missionItem.entity != null) {
                    if (uniqueEntities.contains(missionItem.entity)) continue;
                    uniqueEntities.add(missionItem.entity);
                    items.add(missionItem);
                    continue;
                }
                if (missionItem.itemStack == null || uniqueItems.contains(missionItem.itemStack.m_41720_())) continue;
                uniqueItems.add(missionItem.itemStack.m_41720_());
                items.add(missionItem);
            }
            return items.toArray(new MissionItem[0]);
        }
        return this.successItems;
    }

    public MissionItem[] getFailedItems() {
        if (this.failItems == null) {
            return new MissionItem[0];
        }
        return this.failItems;
    }

    public int getTextColor() {
        return mapRarityToColor.get(this.rarity);
    }

    public String getMissingMissionItemsString(int seed, Player player) {
        StringBuilder tooltip = new StringBuilder();
        MissionItem[] requiredItems = this.getRequiredItems(seed);
        if (requiredItems == null || requiredItems.length == 0) {
            return "";
        }
        tooltip.append("\nMissing Items :");
        boolean itemsMissing = false;
        for (MissionItem item : requiredItems) {
            int needed;
            int owned = Utils.countItemInInventory(item.itemStack.m_41720_(), player);
            if (owned >= (needed = item.number)) continue;
            itemsMissing = true;
            tooltip.append(String.format("\n- %d %s", needed - owned, item.getName()));
        }
        if (!itemsMissing) {
            return "";
        }
        return tooltip.toString();
    }

    public static String getItemTooltips(int multiplier, String rarity, boolean isRandomMission, boolean hideRandom, MissionItem[] items) {
        if (items == null) {
            return "";
        }
        StringBuilder tooltip = new StringBuilder();
        if (isRandomMission && hideRandom) {
            if (items.length > 1) {
                tooltip.append("Random ").append(rarity).append(" Items");
            } else {
                tooltip.append("Random ").append(rarity).append(" Item");
            }
        } else {
            for (int j = 0; j < items.length; ++j) {
                tooltip.append(items[j].getItemTooltip(multiplier));
                if (j >= items.length - 1) continue;
                tooltip.append("\n");
            }
        }
        return tooltip.toString();
    }

    public String getSuccessItemsString(int seed, int multiplier, boolean hideRandom) {
        return Mission.getItemTooltips(multiplier, this.rarity, this.isRandomMission, hideRandom, this.getSuccessItems(seed));
    }

    public String getFailItemsString(int multiplier) {
        return Mission.getItemTooltips(multiplier, this.rarity, this.isRandomMission, false, this.getFailedItems());
    }

    public String getRequiredItemsString(int seed) {
        return "Required Items :\n" + Mission.getItemTooltips(1, this.rarity, this.isRandomMission, false, this.getRequiredItems(seed));
    }

    public static int[] getMissionsProbability(int recruitLevel) {
        if (recruitLevel < 3) {
            return new int[]{100, 0, 0, 0, 0};
        }
        if (recruitLevel < 5) {
            return new int[]{80, 100, 0, 0, 0};
        }
        if (recruitLevel < 7) {
            return new int[]{65, 85, 100, 0, 0};
        }
        if (recruitLevel < 10) {
            return new int[]{35, 65, 85, 100, 0};
        }
        return new int[]{10, 40, 70, 95, 100};
    }

    public static Item getRerollItem(String rarity) {
        return mapRarityRerollItem.get(rarity);
    }

    public static String getSameRerollItemTooltip(String rarity) {
        return Mission.getItemTooltips(1, null, false, false, new MissionItem[]{new MissionItem(1, Mission.getRerollItem(rarity))});
    }

    public static boolean isMissionRandom(ResourceLocation missionId) {
        List<String> rarities = List.of(arrayRarityIndex);
        String id = missionId.toString();
        if (!id.toLowerCase().startsWith(randomMissionPrefix.toLowerCase())) {
            return false;
        }
        String remaining = id.substring(randomMissionPrefix.length());
        String[] parts = remaining.split("/");
        if (parts.length != 2) {
            return false;
        }
        String name = Mission.sanitize(parts[0]);
        String rarity = Mission.sanitize(parts[1]);
        boolean nameMatch = Mercenary.getMercenariesName().stream().anyMatch(n -> Mission.sanitize(n).equalsIgnoreCase(name));
        boolean rarityMatch = rarities.stream().anyMatch(r -> Mission.sanitize(r).equalsIgnoreCase(rarity));
        return nameMatch && rarityMatch;
    }

    public static String sanitize(String input) {
        if (input == null) {
            return null;
        }
        String lower = input.toLowerCase();
        return lower.replaceAll("[^a-z0-9_]", "");
    }

    public static int getMissionTime(String rarity, int seed) {
        int indexRarity = mapRarityIndex.get(rarity);
        int minimumTime = 30;
        if (indexRarity > 0) {
            minimumTime = mapRarityToTime.get(arrayRarityIndex[indexRarity - 1]);
        }
        int maximumTime = mapRarityToTime.get(rarity);
        return (seed + 25675176) % maximumTime + minimumTime;
    }

    public static String getExperienceString(int experience) {
        if (experience < MEAGER_EXPERIENCE) {
            return "Meager";
        }
        if (experience < MODEST_EXPERIENCE) {
            return "Modest";
        }
        if (experience < DECENT_EXPERIENCE) {
            return "Decent";
        }
        if (experience < GENEROUS_EXPERIENCE) {
            return "Generous";
        }
        return "Bountiful";
    }

    public static int getExperienceColor(int experience) {
        if (experience < MEAGER_EXPERIENCE) {
            return 0xFF0000;
        }
        if (experience < MODEST_EXPERIENCE) {
            return 0xFF5000;
        }
        if (experience < DECENT_EXPERIENCE) {
            return 0xFFFFFF;
        }
        if (experience < GENEROUS_EXPERIENCE) {
            return 0x50FF00;
        }
        return 65280;
    }

    public static int getMissionExperience(String rarity, int seed) {
        int indexRarity = mapRarityIndex.get(rarity);
        int minimumExperience = 10;
        if (indexRarity > 0) {
            minimumExperience = mapRarityToExperience.get(arrayRarityIndex[indexRarity - 1]);
        }
        int maximumExp = mapRarityToExperience.get(rarity);
        return (seed + 1574615648) % maximumExp + minimumExperience;
    }

    public static int getMissionHungerCost(String rarity, int seed) {
        int baseCost = mapRarityToHunger.get(rarity);
        int variance = (seed + 156435) % 7 - 3;
        return Math.max(1, baseCost + variance);
    }

    public static String getHungerCostString(int hunger) {
        if (hunger <= HUNGER_LOW) {
            return "Snack";
        }
        if (hunger <= HUNGER_MEDIUM) {
            return "Meal";
        }
        if (hunger <= HUNGER_HIGH) {
            return "Serving";
        }
        if (hunger <= HUNGER_VERY_HIGH) {
            return "Feast";
        }
        return "Banquet";
    }

    public static int getHungerCostColor(int cost) {
        if (cost <= HUNGER_LOW) {
            return 65280;
        }
        if (cost <= HUNGER_MEDIUM) {
            return 0xFFFFFF;
        }
        if (cost <= HUNGER_HIGH) {
            return 0x500050;
        }
        if (cost <= HUNGER_VERY_HIGH) {
            return 0xFF00FF;
        }
        return 0xFF0000;
    }

    public static String getMissionSuccessDescription() {
        return "The Mercenary correctly managed to fulfill his mission! He gained experience from it and you receive your fair share of the loot.";
    }

    public static Mission getMissionFromId(ResourceLocation missionId) {
        if (Mission.isMissionRandom(missionId)) {
            String[] parts = missionId.m_135815_().split("/");
            if (parts.length == 3) {
                String mercenaryName = parts[1].substring(0, 1).toUpperCase() + parts[1].substring(1);
                String rarity = parts[2].substring(0, 1).toUpperCase() + parts[2].substring(1);
                Mercenary mercenary = Mercenary.getMercenary(mercenaryName);
                if (mercenary != null) {
                    return mercenary.generateRandomMissionForRarity(rarity);
                }
            }
            System.err.println("Could not generate random mission from invalid ID: " + String.valueOf(missionId));
            return null;
        }
        MissionManager manager = MissionManager.getMissionManager();
        MissionDefinition definition = manager.getMission(missionId);
        if (definition != null) {
            return new Mission(missionId, definition);
        }
        System.err.println("Could not find predefined mission in manager for ID: " + String.valueOf(missionId));
        return null;
    }
}

