/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.missions;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.sluggly.timemercenaries.item.RefiningStone;
import io.github.sluggly.timemercenaries.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class MissionItem {
    public final ItemStack itemStack;
    public static final ResourceLocation questionMarkTexture = new ResourceLocation("timemercenaries", "textures/gui/question_mark.png");
    public final int number;
    public String rarity;
    public final EntityType entity;
    public int price;
    private static final Codec<MissionItemData> DATA_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(MissionItemData::item), (App)ForgeRegistries.ENTITY_TYPES.getCodec().optionalFieldOf("entity").forGetter(MissionItemData::entity), (App)ExtraCodecs.f_144629_.optionalFieldOf("count", (Object)1).forGetter(MissionItemData::count), (App)Codec.STRING.optionalFieldOf("rename").forGetter(MissionItemData::rename), (App)EnchantmentData.CODEC.listOf().optionalFieldOf("enchantments").forGetter(MissionItemData::enchantments), (App)CustomPotionData.CODEC.optionalFieldOf("potion_effects").forGetter(MissionItemData::potion_effects), (App)AttributeData.CODEC.listOf().optionalFieldOf("attributes").forGetter(MissionItemData::attributes)).apply((Applicative)instance, MissionItemData::new));
    public static final Codec<MissionItem> CODEC = DATA_CODEC.xmap(missionItemData -> {
        ItemStack stack = new ItemStack((ItemLike)missionItemData.item(), 1);
        missionItemData.rename().ifPresent(name -> stack.m_41714_((Component)Component.m_237113_((String)name)));
        missionItemData.enchantments().ifPresent(enchantDataList -> {
            HashMap<Enchantment, Integer> enchantmentMap = new HashMap<Enchantment, Integer>();
            for (EnchantmentData enchantData : enchantDataList) {
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantData.id());
                if (enchantment != null) {
                    enchantmentMap.put(enchantment, enchantData.level());
                    continue;
                }
                System.err.println("Unknown enchantment in MissionItem JSON: " + String.valueOf(enchantData.id()));
            }
            EnchantmentHelper.m_44865_(enchantmentMap, (ItemStack)stack);
        });
        missionItemData.potion_effects().ifPresent(potionData -> {
            ArrayList<MobEffectInstance> effectInstances = new ArrayList<MobEffectInstance>();
            for (PotionEffectData effectData : potionData.effects()) {
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectData.id());
                if (effect != null) {
                    effectInstances.add(new MobEffectInstance(effect, effectData.duration(), effectData.amplifier()));
                    continue;
                }
                System.err.println("Unknown mob effect in MissionItem JSON: " + String.valueOf(effectData.id()));
            }
            PotionUtils.m_43552_((ItemStack)stack, effectInstances);
            potionData.custom_color().ifPresent(color -> stack.m_41784_().m_128405_("CustomPotionColor", color.intValue()));
        });
        missionItemData.attributes().ifPresent(attributeDataList -> {
            for (AttributeData attrData : attributeDataList) {
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(attrData.id());
                if (attribute != null) {
                    AttributeModifier.Operation op = attrData.operation().map(s -> AttributeModifier.Operation.valueOf((String)s.toUpperCase(Locale.ROOT))).orElse(AttributeModifier.Operation.ADDITION);
                    AttributeModifier modifier = new AttributeModifier(RefiningStone.BLACKSMITH_UPGRADE_UUID, "Hestra Infusion", attrData.amount(), op);
                    stack.m_41643_(attribute, modifier, EquipmentSlot.OFFHAND);
                    continue;
                }
                System.err.println("Unknown attribute in MissionItem JSON: " + String.valueOf(attrData.id()));
            }
        });
        if (missionItemData.entity().isPresent()) {
            EntityType<?> entityType = missionItemData.entity().get();
            return new MissionItem(missionItemData.count(), entityType, stack);
        }
        return new MissionItem(missionItemData.count(), stack);
    }, missionItem -> {
        Optional<String> rename = missionItem.itemStack.m_41788_() ? Optional.of(missionItem.itemStack.m_41786_().getString()) : Optional.empty();
        Optional<EntityType<?>> entity = Optional.ofNullable(missionItem.entity);
        Map enchants = EnchantmentHelper.m_44831_((ItemStack)missionItem.itemStack);
        Optional<List<EnchantmentData>> enchantDataList = Optional.empty();
        if (!enchants.isEmpty()) {
            List list = enchants.entrySet().stream().map(entry -> new EnchantmentData(ForgeRegistries.ENCHANTMENTS.getKey((Object)((Enchantment)entry.getKey())), (Integer)entry.getValue())).collect(Collectors.toList());
            enchantDataList = Optional.of(list);
        }
        Optional<CustomPotionData> customPotionData = Optional.empty();
        List effects = PotionUtils.m_43571_((ItemStack)missionItem.itemStack);
        if (!effects.isEmpty()) {
            List<PotionEffectData> effectDataList = effects.stream().map(instance -> new PotionEffectData(ForgeRegistries.MOB_EFFECTS.getKey((Object)instance.m_19544_()), instance.m_19564_(), instance.m_19557_())).collect(Collectors.toList());
            Optional<Integer> color = Optional.empty();
            if (missionItem.itemStack.m_41782_()) {
                assert (missionItem.itemStack.m_41783_() != null);
                if (missionItem.itemStack.m_41783_().m_128441_("CustomPotionColor")) {
                    color = Optional.of(missionItem.itemStack.m_41783_().m_128451_("CustomPotionColor"));
                }
            }
            customPotionData = Optional.of(new CustomPotionData(color, effectDataList));
        }
        Optional<List<AttributeData>> attributeDataList = Optional.empty();
        Multimap modifiers = missionItem.itemStack.m_41638_(EquipmentSlot.OFFHAND);
        if (!modifiers.isEmpty()) {
            List list = modifiers.entries().stream().map(entry -> new AttributeData(ForgeRegistries.ATTRIBUTES.getKey((Object)((Attribute)entry.getKey())), ((AttributeModifier)entry.getValue()).m_22218_(), Optional.of(((AttributeModifier)entry.getValue()).m_22217_().name()))).collect(Collectors.toList());
            attributeDataList = Optional.of(list);
        }
        return new MissionItemData(missionItem.itemStack.m_41720_(), entity, missionItem.number, rename, enchantDataList, customPotionData, attributeDataList);
    });

    public MissionItem(int number, ItemStack itemStack) {
        this.itemStack = itemStack;
        this.number = number;
        this.entity = null;
    }

    public MissionItem(int number, Item item) {
        this.itemStack = item.m_7968_();
        this.number = number;
        this.entity = null;
    }

    public MissionItem(int number, EntityType<?> entity, ItemStack itemStack) {
        this.entity = entity;
        this.itemStack = itemStack;
        this.number = number;
    }

    public String getName() {
        if (this.itemStack.m_41788_()) {
            return this.itemStack.m_41786_().getString();
        }
        return Component.m_237115_((String)this.itemStack.m_41778_()).getString();
    }

    private StringBuilder getItemTooltipStringBuilder(int multiplier) {
        StringBuilder tooltip = new StringBuilder();
        if (this.entity != null) {
            if (multiplier <= 0) {
                tooltip.append("Summon ").append(this.entity.m_20676_().getString());
            } else {
                tooltip.append("Summon ").append(this.number * multiplier).append(" ").append(this.entity.m_20676_().getString());
            }
        } else if (this.itemStack != null) {
            if (multiplier <= 0) {
                tooltip.append(this.getName());
            } else {
                tooltip.append(this.number * multiplier).append(" ").append(this.getName());
            }
            Map enchants = EnchantmentHelper.m_44831_((ItemStack)this.itemStack);
            if (!enchants.isEmpty()) {
                for (Map.Entry entry : enchants.entrySet()) {
                    Enchantment enchant = (Enchantment)entry.getKey();
                    int level = (Integer)entry.getValue();
                    tooltip.append("\n - ").append(enchant.m_44700_(level).getString());
                }
            }
            List effects = PotionUtils.m_43571_((ItemStack)this.itemStack);
            for (MobEffectInstance effect : effects) {
                tooltip.append("\n - ").append(Component.m_237115_((String)effect.m_19576_()).getString()).append(" ").append(Utils.toRomanNumeral(effect.m_19564_() + 1)).append(Utils.formatDuration(effect.m_19557_()));
            }
            Multimap multimap = this.itemStack.m_41638_(EquipmentSlot.OFFHAND);
            if (!multimap.isEmpty()) {
                for (Map.Entry entry : multimap.entries()) {
                    tooltip.append("\n ");
                    MutableComponent component = Component.m_237110_((String)"attribute.modifier.plus.0", (Object[])new Object[]{ItemStack.f_41584_.format(((AttributeModifier)entry.getValue()).m_22218_()), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())});
                    tooltip.append(component.getString());
                }
            }
        }
        return tooltip;
    }

    public String getItemTooltip(int multiplier) {
        return this.getItemTooltipStringBuilder(multiplier).toString();
    }

    public String getItemTooltip() {
        return this.getItemTooltipStringBuilder(0).toString();
    }

    private record CustomPotionData(Optional<Integer> custom_color, List<PotionEffectData> effects) {
        public static final Codec<CustomPotionData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("custom_color").forGetter(CustomPotionData::custom_color), (App)PotionEffectData.CODEC.listOf().fieldOf("effects").forGetter(CustomPotionData::effects)).apply((Applicative)instance, CustomPotionData::new));
    }

    private record MissionItemData(Item item, Optional<EntityType<?>> entity, int count, Optional<String> rename, Optional<List<EnchantmentData>> enchantments, Optional<CustomPotionData> potion_effects, Optional<List<AttributeData>> attributes) {
    }

    private record AttributeData(ResourceLocation id, double amount, Optional<String> operation) {
        public static final Codec<AttributeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(AttributeData::id), (App)Codec.DOUBLE.fieldOf("amount").forGetter(AttributeData::amount), (App)Codec.STRING.optionalFieldOf("operation").forGetter(AttributeData::operation)).apply((Applicative)instance, AttributeData::new));
    }

    private record PotionEffectData(ResourceLocation id, int amplifier, int duration) {
        public static final Codec<PotionEffectData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(PotionEffectData::id), (App)Codec.INT.optionalFieldOf("amplifier", (Object)0).forGetter(PotionEffectData::amplifier), (App)Codec.INT.optionalFieldOf("duration", (Object)1).forGetter(PotionEffectData::duration)).apply((Applicative)instance, PotionEffectData::new));
    }

    private record EnchantmentData(ResourceLocation id, int level) {
        public static final Codec<EnchantmentData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("id").forGetter(EnchantmentData::id), (App)Codec.INT.fieldOf("level").forGetter(EnchantmentData::level)).apply((Applicative)instance, EnchantmentData::new));
    }
}

