/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.network;

import io.github.sluggly.timemercenaries.client.handler.ClientSyncHandler;
import io.github.sluggly.timemercenaries.mercenary.MercenaryDefinition;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record SyncMercenariesPacket(Map<ResourceLocation, MercenaryDefinition> mercenaries) {
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_236831_(this.mercenaries, FriendlyByteBuf::m_130085_, (buf, def) -> buf.m_272073_(MercenaryDefinition.CODEC, def));
    }

    public static SyncMercenariesPacket decode(FriendlyByteBuf buffer) {
        Map mercenaries = buffer.m_236847_(FriendlyByteBuf::m_130281_, buf -> (MercenaryDefinition)buf.m_271872_(MercenaryDefinition.CODEC));
        return new SyncMercenariesPacket(mercenaries);
    }

    public static void handle(SyncMercenariesPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientSyncHandler.handleSyncMercenaries(msg)));
        ctx.get().setPacketHandled(true);
    }
}

