/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.utils;

import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.item.artefacts.BeastbinderWand;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;

public class Utils {
    public static boolean hasEnoughItems(Item item, Player player, int requiredAmount) {
        if (player.m_9236_().f_46443_ ? Admin.CLIENT_ADMIN_NO_ITEM_REQUIRED : Admin.hasPlayerNoRequiredItem((ServerPlayer)player)) {
            return true;
        }
        return Utils.countItemInInventory(item, player) >= requiredAmount;
    }

    public static int countItemInInventory(Item item, Player player) {
        int total = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack it = player.m_150109_().m_8020_(i);
            if (!it.m_41720_().equals(item) || it.m_41768_() || it.m_41793_()) continue;
            total += it.m_41613_();
        }
        return total;
    }

    public static void removeItemInInventory(Item item, int number, Player player) {
        if (Admin.hasPlayerNoRequiredItem((ServerPlayer)player)) {
            return;
        }
        int toRemove = number;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack it = player.m_150109_().m_8020_(i);
            if (!it.m_41720_().equals(item) || it.m_41768_() || it.m_41793_()) continue;
            int currentCount = it.m_41613_();
            if (currentCount > toRemove) {
                it.m_41764_(currentCount - toRemove);
                player.m_150109_().m_6836_(i, it);
                break;
            }
            player.m_150109_().m_6836_(i, ItemStack.f_41583_);
            if ((toRemove -= it.m_41613_()) == 0) break;
        }
        player.m_150109_().m_6596_();
    }

    public static boolean checkIfPlayerHasEnoughLevel(Player player, int requiredLevel) {
        return player.f_36078_ >= requiredLevel;
    }

    public static void removePlayerLevel(Player player, int level) {
        player.m_6749_(-level);
    }

    public static int generateSeed() {
        Random random = new Random();
        return random.nextInt(100000) + 1000;
    }

    public static String unformatMercenaryString(String input) {
        return input.toLowerCase().replace('-', '_').replace(' ', '_');
    }

    public static String unformatString(String input) {
        String[] words = input.split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            String capitalizedWord = word.substring(0, 1).toUpperCase() + word.substring(1);
            result.append(capitalizedWord).append(" ");
        }
        return result.toString().trim();
    }

    public static String formatDuration(int durationSeconds) {
        if (durationSeconds < 20) {
            return "";
        }
        int durationNoTick = durationSeconds / 20;
        int minutes = durationNoTick / 60;
        int seconds = durationNoTick % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    public static String toRomanNumeral(int number) {
        String[] romanNumerals = new String[]{"", "I ", "II ", "III ", "IV ", "V ", "VI ", "VII ", "VIII ", "IX ", "X ", "XI ", "XII ", "XIII ", "XIV ", "XV ", "XVI ", "XVII ", "XVIII ", "XIX ", "XX "};
        if (number > romanNumerals.length) {
            return "";
        }
        return romanNumerals[number];
    }

    public static boolean isEntityFriendly(Player player, Entity entity) {
        TamableAnimal tamed;
        if (entity instanceof Mob && BeastbinderWand.isMobBound(player, (Mob)entity)) {
            return true;
        }
        if (entity instanceof TamableAnimal && (tamed = (TamableAnimal)entity).m_21830_((LivingEntity)player)) {
            return true;
        }
        return player == entity;
    }

    public static boolean areEntitiesAllied(Entity e1, Entity e2) {
        Player owner2;
        if (e1 == e2) {
            return true;
        }
        Player owner1 = BeastbinderWand.getBoundPetOwner(e1);
        if (owner1 == null) {
            if (e1 instanceof TamableAnimal) {
                TamableAnimal tamed = (TamableAnimal)e1;
                owner1 = (Player)tamed.m_269323_();
            } else {
                return false;
            }
        }
        if ((owner2 = BeastbinderWand.getBoundPetOwner(e2)) == null) {
            if (e2 instanceof TamableAnimal) {
                TamableAnimal tamed = (TamableAnimal)e2;
                owner2 = (Player)tamed.m_269323_();
            } else {
                return false;
            }
        }
        return owner1 != null && owner1 == owner2;
    }

    public static void setCustomAttribute(Mob mob, Attribute attribute, double value) {
        CompoundTag data = mob.getPersistentData();
        if (attribute.equals(Attributes.f_22276_)) {
            data.m_128350_("timemercenaries_nbt_max_health", (float)value);
        } else if (attribute.equals(Attributes.f_22279_)) {
            data.m_128350_("timemercenaries_nbt_movement_speed", (float)value);
        } else if (attribute.equals(Attributes.f_22278_)) {
            data.m_128350_("timemercenaries_nbt_knockback_resistance", (float)value);
        } else if (attribute.equals(Attributes.f_22281_)) {
            data.m_128350_("timemercenaries_arena_atk_dmg", (float)value);
        } else if (attribute.equals(Attributes.f_22283_)) {
            data.m_128350_("timemercenaries_arena_attack_speed", (float)value);
        } else if (attribute.equals(Attributes.f_22282_)) {
            data.m_128350_("timemercenaries_nbt_attack_knockback", (float)value);
        } else if (attribute.equals(Attributes.f_22284_)) {
            data.m_128350_("timemercenaries_nbt_armor", (float)value);
        } else if (attribute.equals(Attributes.f_22285_)) {
            data.m_128350_("timemercenaries_nbt_armor_toughness", (float)value);
        } else if (attribute.equals(ForgeMod.STEP_HEIGHT_ADDITION.get())) {
            data.m_128350_("timemercenaries_nbt_step_height", (float)value);
        }
    }

    public static boolean removeCustomAttribute(Mob mob) {
        boolean removedAttribute = false;
        CompoundTag data = mob.getPersistentData();
        if (data.m_128441_("timemercenaries_nbt_max_health")) {
            data.m_128473_("timemercenaries_nbt_max_health");
            removedAttribute = true;
        } else if (data.m_128441_("timemercenaries_nbt_movement_speed")) {
            data.m_128473_("timemercenaries_nbt_movement_speed");
            removedAttribute = true;
        } else if (data.m_128441_("timemercenaries_nbt_knockback_resistance")) {
            data.m_128473_("timemercenaries_nbt_knockback_resistance");
            removedAttribute = true;
        } else if (data.m_128441_("timemercenaries_arena_atk_dmg")) {
            data.m_128473_("timemercenaries_arena_atk_dmg");
            removedAttribute = true;
        } else if (data.m_128441_("timemercenaries_arena_attack_speed")) {
            data.m_128473_("timemercenaries_arena_attack_speed");
            removedAttribute = true;
        } else if (data.m_128441_("timemercenaries_nbt_attack_knockback")) {
            data.m_128473_("timemercenaries_nbt_attack_knockback");
            removedAttribute = true;
        } else if (data.m_128441_("timemercenaries_nbt_armor")) {
            data.m_128473_("timemercenaries_nbt_armor");
            removedAttribute = true;
        } else if (data.m_128441_("timemercenaries_nbt_armor_toughness")) {
            data.m_128473_("timemercenaries_nbt_armor_toughness");
            removedAttribute = true;
        } else if (data.m_128441_("timemercenaries_nbt_step_height")) {
            data.m_128473_("timemercenaries_nbt_step_height");
            removedAttribute = true;
        }
        return removedAttribute;
    }
}

