/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.admin;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.network.PacketHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class AdminCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"TM_resetData").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(AdminCommands::resetDataCommand)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"TM_printNBT").requires(source -> source.m_6761_(2))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(AdminCommands::printPlayerNBTCommand)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"TM_adminMode").requires(source -> source.m_6761_(2))).executes(AdminCommands::toggleAdminModeCommand));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"TM_serverConsoleLog").requires(source -> source.m_6761_(2))).executes(AdminCommands::toggleAdminServerConsoleLogCommand));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"TM_printMyNBT").executes(AdminCommands::printMyNBTCommand));
    }

    private static int resetDataCommand(CommandContext<CommandSourceStack> command) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(command, (String)"player");
            System.out.println("Resetting data for: " + player.m_7755_().getString());
            Admin.adminResetPlayerData(player);
            return 1;
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
    }

    private static int printPlayerNBTCommand(CommandContext<CommandSourceStack> command) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(command, (String)"player");
            System.out.println("Printing NBT data for: " + player.m_7755_().getString());
            PlayerData.logCustomData((Player)player, true);
            return 1;
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
    }

    private static int printMyNBTCommand(CommandContext<CommandSourceStack> command) {
        try {
            ServerPlayer player = ((CommandSourceStack)command.getSource()).m_81375_();
            System.out.println("Printing NBT data for: " + player.m_7755_().getString());
            PlayerData.logCustomData((Player)player, true);
            PlayerData playerData = PlayerData.getPlayerData((Player)player);
            if (playerData != null) {
                PacketHandler.sendToPlayer("LogData", playerData, player);
            }
            return 1;
        }
        catch (CommandSyntaxException e) {
            return 0;
        }
    }

    private static int toggleAdminModeCommand(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
        System.out.println("Toggling player administrator: " + String.valueOf(((CommandSourceStack)command.getSource()).m_230896_()));
        Admin.togglePlayerAdministrator(((CommandSourceStack)command.getSource()).m_81375_());
        return 1;
    }

    private static int toggleAdminServerConsoleLogCommand(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
        System.out.println("Toggling Server Console Log");
        Admin.toggleServerConsoleLog(((CommandSourceStack)command.getSource()).m_81375_());
        return 1;
    }
}

