/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.capability;

import io.github.sluggly.timemercenaries.capability.IPlayerData;
import io.github.sluggly.timemercenaries.capability.PlayerCapability;
import io.github.sluggly.timemercenaries.capability.PlayerDataImpl;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerDataProvider
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    private final IPlayerData playerData;
    private final LazyOptional<IPlayerData> optional;

    public PlayerDataProvider(Player player) {
        this.playerData = new PlayerDataImpl(player);
        this.optional = LazyOptional.of(() -> this.playerData);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == PlayerCapability.PLAYER_DATA) {
            return this.optional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        return this.playerData.saveNBTData();
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.playerData.loadNBTData(nbt);
    }
}

