/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.data;

import io.github.sluggly.timemercenaries.client.handler.ButtonHandler;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.lore.Lore;
import io.github.sluggly.timemercenaries.utils.Utils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;

public class LoreData {
    public final float progress;
    public final Font font;
    public boolean canCompleteStep;
    public LoreButton completeStepButton;
    public final int count;
    public StringWidget nameWidget;
    public String name;
    public int color;
    public String description;
    public ResourceLocation texture;

    public LoreData(PlayerData playerData) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.progress = Lore.getPlayerLoreProgress(playerData);
        this.canCompleteStep = false;
        this.count = Lore.getPlayerLoreCount(playerData);
        if (this.progress == 0.0f) {
            this.canCompleteStep = Utils.hasEnoughItems(Items.f_42451_, playerData.player, 10);
            this.completeStepButton = new LoreButton(this, 20, 20, ButtonHandler.Empty, ButtonHandler::handleCompleteLoreStep, "Power Up!");
            this.completeStepButton.f_93623_ = this.canCompleteStep;
        } else if (this.progress == 0.1f) {
            this.completeStepButton = new LoreButton(this, 80, 20, (Component)Component.m_237113_((String)"Calibrate Signal"), ButtonHandler::handleCompleteLoreStep, null);
            this.completeStepButton.f_93623_ = false;
        } else if (this.progress == 0.2f) {
            this.completeStepButton = new LoreButton(this, 80, 20, (Component)Component.m_237113_((String)"Find Resonance"), ButtonHandler::handleCompleteLoreStep, null);
            this.completeStepButton.f_93623_ = false;
        } else if (this.progress == 0.3f) {
            this.completeStepButton = new LoreButton(this, 100, 20, (Component)Component.m_237113_((String)"Quench the Clock's Thirst"), ButtonHandler::handleCompleteLoreStep, null);
            this.completeStepButton.f_93623_ = false;
        } else if (this.progress == 0.4f) {
            this.canCompleteStep = this.count >= 3;
            this.completeStepButton = new LoreButton(this, 80, 20, (Component)Component.m_237113_((String)"Finish Ritual"), ButtonHandler::handleCompleteLoreStep, null);
            this.completeStepButton.f_93623_ = this.canCompleteStep;
        } else if (this.progress == 0.5f) {
            this.canCompleteStep = Utils.hasEnoughItems(Items.f_42516_, playerData.player, 1);
            this.completeStepButton = new LoreButton(this, 20, 20, ButtonHandler.Empty, ButtonHandler::handleCompleteLoreStep, "Sign Contract");
            this.completeStepButton.f_93623_ = this.canCompleteStep;
        }
        this.description = "Lene is the chief organizer of the Arena and a master swordswoman, renowned for her unmatched skill. Only a rare few can hope to best her in battle.";
        this.texture = new ResourceLocation("timemercenaries", "textures/gui/lene.png");
        this.name = "Lene";
        this.color = 0xFF00FF;
        this.nameWidget = new StringWidget(0, 0, 48, 10, (Component)Component.m_237113_((String)this.name).m_130948_(Style.f_131099_.m_178520_(this.color)), this.font);
        this.nameWidget.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)this.description)));
        this.nameWidget.m_267729_();
    }

    public static class LoreButton
    extends Button {
        public final LoreData loreData;
        public static final Button.CreateNarration DEFAULT_NARRATION = Supplier::get;

        public LoreButton(LoreData loreData, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress, String tooltip) {
            super(0, 0, pWidth, pHeight, pMessage, pOnPress, DEFAULT_NARRATION);
            this.loreData = loreData;
            if (tooltip != null) {
                this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)tooltip)));
            }
        }

        public LoreData getLoreData() {
            return this.loreData;
        }
    }
}

