/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.data;

import io.github.sluggly.timemercenaries.client.data.StatisticsData;
import io.github.sluggly.timemercenaries.client.handler.ButtonHandler;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.mercenary.Trait;
import io.github.sluggly.timemercenaries.missions.MissionItem;
import io.github.sluggly.timemercenaries.module.Module;
import io.github.sluggly.timemercenaries.utils.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class MercenaryData {
    public StatisticsData statisticsData;
    public final String name;
    public final String description;
    public final String job;
    public final int seed;
    public final int level;
    public final int experience;
    public final int nextLevelExperience;
    public final int color;
    public int numberTraitAvailable;
    public int currentHealth;
    public int maxHealth;
    public int currentHunger;
    public int maxHunger;
    public final ResourceLocation texture;
    public boolean hasTraitAvailable;
    public boolean hasTotem;
    public boolean isBribed;
    public boolean canBeBribed;
    public boolean isDead;
    public boolean isFed;
    public boolean canBeFed;
    public MercenaryButton buttonTrait;
    public MercenaryButton buttonRecruit;
    public final Button buttonTotem;
    public final StringWidget nameWidget;
    public boolean shouldRenderButtonTrait = false;
    public boolean shouldRenderButtonRecruit = false;
    public boolean shouldRenderButtonTotem = false;
    public boolean shouldRenderResurrectLevels = false;
    public boolean shouldRenderHealth = true;
    public boolean shouldRenderHunger = true;
    public int requiredResurrectLevels;
    public final ResourceLocation backgroundTexture;
    public final ResourceLocation walkingTexture;
    public final int rerollsLeft;
    public final Font font;
    public final Map<String, Integer> mapTraitLevel = new HashMap<String, Integer>();
    public final Map<String, Integer> mapTraitMaximumLevel = new HashMap<String, Integer>();
    public List<ResourceLocation> missionsAvailable;
    public ResourceLocation chosenMission;
    public String missionStatus;
    public int timeLeft;
    public int timeTotal;
    public MissionItem bribeItem;
    public MissionItem feedItem;

    public MercenaryData(PlayerData playerData, Mercenary mercenary) {
        this.name = mercenary.name;
        this.job = mercenary.job;
        this.seed = MercenaryPlayerData.getMercenarySeed(playerData, mercenary.name);
        this.color = mercenary.color;
        this.texture = mercenary.texture;
        this.description = mercenary.description;
        this.backgroundTexture = mercenary.backgroundTexture;
        this.walkingTexture = mercenary.walkingTexture;
        this.font = Minecraft.m_91087_().f_91062_;
        this.nameWidget = new StringWidget(0, 0, 48, 10, (Component)Component.m_237113_((String)this.name).m_130948_(Style.f_131099_.m_178520_(this.color)), this.font);
        this.nameWidget.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)this.description)));
        this.nameWidget.m_267729_();
        this.buttonTotem = Button.m_253074_((Component)ButtonHandler.Empty, ButtonHandler::doNothing).m_253046_(20, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"This Mercenary has a Totem Of Undying in his possession and will prevent his next death on a mission."))).m_253136_();
        this.buttonTotem.f_93623_ = false;
        this.hasTotem = MercenaryPlayerData.doesMercenaryHaveTotem(playerData, mercenary.name);
        int currentExp = MercenaryPlayerData.getMercenaryExp(playerData, mercenary.name);
        int currentLevel = Mercenary.getLevel(currentExp);
        int currentLevelExpNeeded = Mercenary.getRequiredExpLevel(currentLevel);
        int currentNextLevelExpNeeded = Mercenary.getRequiredExpLevel(currentLevel + 1);
        this.level = currentLevel;
        this.experience = currentExp - currentLevelExpNeeded;
        this.nextLevelExperience = currentNextLevelExpNeeded - currentLevelExpNeeded;
        this.rerollsLeft = MercenaryPlayerData.getMercenaryMissionRerollLeft(playerData, mercenary.name);
        if (this.name.equals("Vael")) {
            this.shouldRenderHealth = false;
            this.shouldRenderHunger = false;
            if (MercenaryPlayerData.isMercenaryIdle(playerData, mercenary.name)) {
                this.buttonTrait = new MercenaryButton(this, 48, 20, ButtonHandler.Quest, ButtonHandler::handleOpenQuestButton, null);
                this.shouldRenderButtonTrait = Module.isModuleActive(playerData, "Caravaneer Questing Module");
                this.buttonRecruit = new MercenaryButton(this, 48, 20, ButtonHandler.Shop, ButtonHandler::handleOpenShopButton, null);
            } else {
                this.shouldRenderButtonTrait = false;
                this.buttonRecruit = new MercenaryButton(this, 48, 20, ButtonHandler.Skipped, ButtonHandler::handleRecruitScreenMissionButton, null);
            }
        } else {
            if (MercenaryPlayerData.isMercenaryDead(playerData, mercenary.name)) {
                int requiredLevel = MercenaryPlayerData.getRequiredPlayerLevelToResurrectMercenary(playerData, mercenary.name);
                this.buttonRecruit = new MercenaryButton(this, 48, 20, ButtonHandler.Revive, ButtonHandler::handleResurrectButton, "Reviving " + mercenary.name + " will cost you " + requiredLevel + " levels.");
                if (playerData.player.f_36078_ < requiredLevel) {
                    this.buttonRecruit.f_93623_ = false;
                }
                this.shouldRenderResurrectLevels = true;
                this.requiredResurrectLevels = requiredLevel;
            } else {
                if (MercenaryPlayerData.canPlayerRecruitMercenaries(playerData)) {
                    if (MercenaryPlayerData.isMercenaryIdle(playerData, mercenary.name)) {
                        this.buttonRecruit = new MercenaryButton(this, 48, 20, ButtonHandler.Recruit, ButtonHandler::handleRecruitButton, null);
                    }
                } else if (MercenaryPlayerData.isMercenaryIdle(playerData, mercenary.name)) {
                    this.buttonRecruit = new MercenaryButton(this, 48, 20, ButtonHandler.Skip, ButtonHandler::handleRecruitSkipButton, null);
                }
                if (!MercenaryPlayerData.isMercenaryIdle(playerData, mercenary.name)) {
                    this.buttonRecruit = MercenaryPlayerData.isMercenaryOnMission(playerData, mercenary.name) || MercenaryPlayerData.isMercenaryWaitingMissionResult(playerData, mercenary.name) ? new MercenaryButton(this, 48, 20, ButtonHandler.Mission, ButtonHandler::handleRecruitScreenMissionButton, null) : new MercenaryButton(this, 48, 20, ButtonHandler.Skipped, ButtonHandler::handleRecruitScreenMissionButton, null);
                }
            }
            this.currentHealth = MercenaryPlayerData.getMercenaryCurrentHealth(playerData, mercenary.name);
            this.maxHealth = MercenaryPlayerData.getMercenaryMaxHealth(playerData, mercenary.name);
            this.currentHunger = MercenaryPlayerData.getMercenaryCurrentHunger(playerData, mercenary.name);
            this.maxHunger = MercenaryPlayerData.getMercenaryMaximumHunger(playerData, mercenary.name);
            this.buttonTrait = new MercenaryButton(this, 48, 20, ButtonHandler.Trait, ButtonHandler::handleTraitButton, null);
            this.isDead = MercenaryPlayerData.isMercenaryDead(playerData, mercenary.name);
            this.bribeItem = Mercenary.getMercenaryActiveBribeItem(playerData, mercenary.name);
            this.isBribed = MercenaryPlayerData.isMercenaryBribed(playerData, mercenary.name);
            this.canBeBribed = Utils.hasEnoughItems(this.bribeItem.itemStack.m_41720_(), (Player)(Minecraft.m_91087_().f_91074_ != null ? Minecraft.m_91087_().f_91074_ : null), this.bribeItem.number) && !this.isBribed;
            int usedTrait = MercenaryPlayerData.getMercenaryLevelsSpent(playerData, mercenary.name) + 1;
            for (Map.Entry<String, Trait> entry : Trait.getTraitsMap()) {
                this.mapTraitLevel.put(entry.getKey(), MercenaryPlayerData.getMercenaryTraitLevel(playerData, mercenary.name, entry.getKey()));
                this.mapTraitMaximumLevel.put(entry.getKey(), entry.getValue().maxLevel);
            }
            this.feedItem = Mercenary.getMercenaryFoodItem(playerData, mercenary.name);
            this.isFed = MercenaryPlayerData.isMercenaryFed(playerData, mercenary.name);
            this.canBeFed = Utils.hasEnoughItems(this.feedItem.itemStack.m_41720_(), playerData.player, this.feedItem.number) && !this.isFed && MercenaryPlayerData.getMercenaryCurrentHunger(playerData, mercenary.name) < MercenaryPlayerData.getMercenaryMaximumHunger(playerData, mercenary.name);
            this.numberTraitAvailable = currentLevel - usedTrait;
            this.hasTraitAvailable = this.numberTraitAvailable > 0;
            this.missionsAvailable = MercenaryPlayerData.getMercenaryMissionsAvailable(playerData, mercenary.name);
            this.chosenMission = MercenaryPlayerData.getMercenaryChosenMission(playerData, mercenary.name);
            this.missionStatus = MercenaryPlayerData.getMercenaryMissionStatus(playerData, mercenary.name);
            this.timeTotal = MercenaryPlayerData.getMercenaryMissionTimeTotal(playerData, mercenary.name);
            this.timeLeft = MercenaryPlayerData.getMercenaryMissionTimeLeft(playerData, mercenary.name);
        }
    }

    public int getTraitLevel(String trait) {
        return this.mapTraitLevel.get(trait);
    }

    public int getTotalLevels() {
        int sum = 0;
        for (int level : this.mapTraitLevel.values()) {
            sum += level;
        }
        return sum;
    }

    public int getMercenaryHealthStringColor() {
        if (this.currentHealth == this.maxHealth) {
            return 0xFF0000;
        }
        if (this.currentHealth > this.maxHealth / 4) {
            return 65280;
        }
        return 0xFFFFFF;
    }

    public int getMercenaryHungerStringColor() {
        if (this.currentHunger == this.maxHunger) {
            return 13929018;
        }
        if (this.currentHunger > this.maxHunger / 4) {
            return 65280;
        }
        if (this.currentHunger > 0) {
            return 0xFF0000;
        }
        return 0xFFFFFF;
    }

    public static class MercenaryButton
    extends Button {
        public final MercenaryData mercenaryData;
        public static final Button.CreateNarration DEFAULT_NARRATION = Supplier::get;

        public MercenaryButton(MercenaryData mercenaryData, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress, String tooltip) {
            super(0, 0, pWidth, pHeight, pMessage, pOnPress, DEFAULT_NARRATION);
            this.mercenaryData = mercenaryData;
            if (tooltip != null) {
                this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)tooltip)));
            }
        }

        public MercenaryData getMercenaryData() {
            return this.mercenaryData;
        }
    }
}

