/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.data;

import io.github.sluggly.timemercenaries.client.handler.ButtonHandler;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.module.Module;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ModuleData {
    public final boolean[] moduleUnlocks;
    public final boolean[] canUnlockModules;
    public final boolean[] hasItemRequirements;
    public final boolean[] hasModuleRequirements;
    public final String[][] missingModuleRequirements;
    public final int[][] requirementLinesIndex;
    public final ModuleButton[] buttonsModule;
    public final int[] columns;
    public final int[] rows;
    public final int[] colors;
    public final ItemStack[] textures;
    public final Font font;

    public boolean hasModule(String moduleName) {
        Module module = Module.getModule(moduleName);
        return this.moduleUnlocks[module.index];
    }

    public ModuleData(PlayerData playerData) {
        CompoundTag modules = Module.getModulesTag(playerData);
        int numberOfModules = Module.getModules().size();
        this.moduleUnlocks = new boolean[numberOfModules];
        this.canUnlockModules = new boolean[numberOfModules];
        this.buttonsModule = new ModuleButton[numberOfModules];
        this.columns = new int[numberOfModules];
        this.rows = new int[numberOfModules];
        this.colors = new int[numberOfModules];
        this.requirementLinesIndex = new int[numberOfModules][];
        this.textures = new ItemStack[numberOfModules];
        this.hasItemRequirements = new boolean[numberOfModules];
        this.hasModuleRequirements = new boolean[numberOfModules];
        this.missingModuleRequirements = new String[numberOfModules][];
        this.font = Minecraft.m_91087_().f_91062_;
        for (Map.Entry<String, Module> entry : Module.getModules()) {
            Module module = entry.getValue();
            int index = module.index;
            this.moduleUnlocks[index] = modules.m_128471_(entry.getKey());
            this.columns[index] = module.column;
            this.rows[index] = module.row;
            this.colors[index] = module.color;
            this.textures[index] = module.itemTexture.m_7968_();
            this.canUnlockModules[index] = Module.checkIfPlayerCanUnlockModule(index, (Player)Minecraft.m_91087_().f_91074_, false);
            this.buttonsModule[index] = new ModuleButton(index, 20, 20, ButtonHandler.Empty, ButtonHandler::handleUnlockModule, null);
            this.buttonsModule[index].f_93623_ = this.canUnlockModules[index];
            this.missingModuleRequirements[index] = Objects.requireNonNull(Module.missingPlayerModuleModulesRequirement(index, null)).toArray(new String[0]);
            this.hasItemRequirements[index] = Module.checkIfPlayerHasModuleItemRequirements(index, (Player)Minecraft.m_91087_().f_91074_, false);
            this.hasModuleRequirements[index] = this.missingModuleRequirements[index].length == 0;
            StringBuilder tooltip = new StringBuilder();
            tooltip.append("\n\n").append(module.description);
            if (!this.moduleUnlocks[index]) {
                if (!this.hasModuleRequirements[index]) {
                    tooltip.append("\n\nInstalled Modules Required :");
                    for (String req : this.missingModuleRequirements[index]) {
                        tooltip.append("\n - ").append(req);
                    }
                } else {
                    tooltip.append("\n\nItems Needed to install :");
                    for (int j = 0; j < module.unlockItems.length; ++j) {
                        tooltip.append("\n - ").append(module.unlockItems[j].number).append(" ").append(module.unlockItems[j].getName());
                    }
                    if (!this.hasItemRequirements[index]) {
                        tooltip.append(module.getMissingModuleItemsString(playerData.player));
                    }
                }
            } else {
                tooltip.append("\n\nINSTALLED !");
            }
            MutableComponent buttonTooltip = Component.m_237113_((String)module.name).m_130948_(Style.f_131099_.m_178520_(module.color)).m_7220_((Component)Component.m_237113_((String)tooltip.toString()));
            this.buttonsModule[index].m_257544_(Tooltip.m_257550_((Component)buttonTooltip));
            ArrayList<Integer> lines = new ArrayList<Integer>();
            for (String requirement : module.requirements) {
                if (requirement.equals("None") || requirement.equals("Dimensional Modulator") || requirement.equals("Green Module Installer") || requirement.equals("Blue Module Installer") || requirement.equals("Red Module Installer")) continue;
                lines.add(Module.getModule((String)requirement).index);
            }
            this.requirementLinesIndex[index] = new int[lines.size()];
            for (int i = 0; i < lines.size(); ++i) {
                this.requirementLinesIndex[index][i] = (Integer)lines.get(i);
            }
        }
    }

    public static class ModuleButton
    extends Button {
        public final int moduleIndex;
        public static final Button.CreateNarration DEFAULT_NARRATION = Supplier::get;

        public ModuleButton(int moduleIndex, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress, String tooltip) {
            super(0, 0, pWidth, pHeight, pMessage, pOnPress, DEFAULT_NARRATION);
            this.moduleIndex = moduleIndex;
            if (tooltip != null) {
                this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)tooltip)));
            }
        }

        public int getModuleIndex() {
            return this.moduleIndex;
        }
    }
}

