/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.data;

import io.github.sluggly.timemercenaries.client.data.MercenaryData;
import io.github.sluggly.timemercenaries.client.handler.ButtonHandler;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.mercenary.Quest;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public class QuestData {
    public final int questIndex;
    public final String requirementId;
    public final String rewardId;
    public String requirementMissionStatus;
    public String requirementRarity;
    public String requirementMercenary;
    public String rewardTrait;
    public String rewardMercenary;
    public String progressStatus;
    public int progress;
    public int requirementNumber;
    public int rewardNumber;
    public final boolean shouldRenderAcceptQuestButton;
    public final boolean shouldRenderCompleteQuestButton;
    public QuestButton buttonAcceptQuest;
    public QuestButton buttonCompleteQuest;
    public final String requirementDescription;
    public final String rewardDescription;
    public final boolean isChosenQuest;

    public QuestData(PlayerData playerData, MercenaryData mercenaryData, int questIndex) {
        this.questIndex = questIndex;
        CompoundTag mercenaryTag = MercenaryPlayerData.getMercenaryTag(playerData, mercenaryData.name);
        CompoundTag questsAvailableTag = MercenaryPlayerData.getMercenaryQuestsTag(playerData, mercenaryData.name);
        CompoundTag questTag = questsAvailableTag.m_128469_("Quest" + questIndex);
        int chosenQuestIndex = mercenaryTag.m_128451_("ChosenQuest");
        this.isChosenQuest = chosenQuestIndex == questIndex;
        int questSeed = questTag.m_128451_("Seed");
        this.progressStatus = mercenaryTag.m_128461_("QuestStatus");
        this.requirementId = questTag.m_128461_("RequirementId");
        if (this.requirementId.contains("Success")) {
            this.requirementMissionStatus = "Success";
        } else if (this.requirementId.contains("Fail")) {
            this.requirementMissionStatus = "Fail";
        }
        if (this.requirementId.contains("Rarity")) {
            this.requirementRarity = questTag.m_128461_("RequirementTargetRarity");
        }
        if (this.requirementId.contains("Mercenary")) {
            this.requirementMercenary = questTag.m_128461_("RequirementTargetMercenary");
        }
        if (questTag.m_128441_("RequirementProgress")) {
            this.progress = questTag.m_128451_("RequirementProgress");
        }
        if (this.requirementId.contains("Number")) {
            this.requirementNumber = Quest.getQuestRandomNumber(questSeed, this.requirementId);
        }
        this.requirementDescription = Quest.getQuestDescription(playerData, questIndex, true);
        this.rewardId = questTag.m_128461_("RewardId");
        if (this.rewardId.contains("Mercenary")) {
            this.rewardMercenary = questTag.m_128461_("RewardTargetMercenary");
        }
        if (this.rewardId.contains("Trait")) {
            this.rewardTrait = questTag.m_128461_("RewardTargetTrait");
        }
        if (this.rewardId.contains("Number")) {
            this.rewardNumber = Quest.getQuestRandomNumber(questSeed, this.rewardId);
        }
        this.rewardDescription = Quest.getQuestDescription(playerData, questIndex, false);
        this.shouldRenderAcceptQuestButton = chosenQuestIndex == 0;
        this.buttonAcceptQuest = new QuestButton(this, 48, 20, ButtonHandler.Accept, ButtonHandler::handleAcceptQuestButton, null);
        this.shouldRenderCompleteQuestButton = this.progressStatus.equals("Success") && this.isChosenQuest;
        this.buttonCompleteQuest = new QuestButton(this, 48, 20, ButtonHandler.Complete, ButtonHandler::handleShopCompleteQuestButton, null);
    }

    public static class QuestButton
    extends Button {
        public final QuestData questData;
        public static final Button.CreateNarration DEFAULT_NARRATION = Supplier::get;

        public QuestButton(QuestData questData, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress, String tooltip) {
            super(0, 0, pWidth, pHeight, pMessage, pOnPress, DEFAULT_NARRATION);
            this.questData = questData;
            if (tooltip != null) {
                this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)tooltip)));
            }
        }

        public QuestData getQuestData() {
            return this.questData;
        }
    }
}

