/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.data;

import io.github.sluggly.timemercenaries.client.data.MercenaryData;
import io.github.sluggly.timemercenaries.init.SoundInit;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;

public class ScreenData {
    public boolean isAnimatingXp = false;
    private long animationStartTime;
    private long currentAnimationDurationMs = 1500L;
    private static final long BASE_ANIMATION_DURATION_MS = 1500L;
    private static final long LEVEL_UP_PAUSE_MS = 300L;
    private static final int MAX_XP_BAR_WIDTH = 48;
    private int xpBarStartWidth;
    private int xpBarTargetWidth;
    private int currentXpBarWidth = 0;
    private int xpSoundTickCounter;
    private int predictedTargetXp;
    private int levelsToAnimate;
    private boolean isBarWidthComputed = false;
    private int mercenaryLevelToShow = 0;
    private MercenaryData mercenaryData;

    public void startXpAnimation(MercenaryData mercenaryData, int totalXpGained) {
        int predictedCurrentXp = mercenaryData.level > 1 || mercenaryData.experience > 0 ? Mercenary.getRequiredExpLevel(mercenaryData.level) + mercenaryData.experience : 0;
        this.predictedTargetXp = predictedCurrentXp + totalXpGained;
        int startLevel = Mercenary.getLevel(predictedCurrentXp);
        int finalLevel = Mercenary.getLevel(this.predictedTargetXp);
        this.levelsToAnimate = finalLevel - startLevel;
        int currentLevelRequiredXp = Mercenary.getRequiredExpLevel(startLevel);
        int currentLevelNextXp = Mercenary.getRequiredExpLevel(startLevel + 1);
        int currentLevelTotalXp = currentLevelNextXp - currentLevelRequiredXp;
        float startPercentage = currentLevelTotalXp > 0 ? (float)(predictedCurrentXp - currentLevelRequiredXp) / (float)currentLevelTotalXp : 0.0f;
        this.currentXpBarWidth = this.xpBarStartWidth = (int)(48.0f * startPercentage);
        this.xpBarTargetWidth = 48;
        this.mercenaryLevelToShow = startLevel;
        if (this.levelsToAnimate <= 0) {
            int finalLevelRequiredXp = Mercenary.getRequiredExpLevel(finalLevel);
            int finalLevelNextXp = Mercenary.getRequiredExpLevel(finalLevel + 1);
            int finalLevelTotalXp = finalLevelNextXp - finalLevelRequiredXp;
            float finalPercentage = finalLevelTotalXp > 0 ? (float)(this.predictedTargetXp - finalLevelRequiredXp) / (float)finalLevelTotalXp : 1.0f;
            this.xpBarTargetWidth = (int)(48.0f * finalPercentage);
        }
        this.isAnimatingXp = true;
        this.currentAnimationDurationMs = 1500L;
        this.animationStartTime = System.currentTimeMillis();
        this.isBarWidthComputed = true;
        this.xpSoundTickCounter = 0;
        this.mercenaryData = mercenaryData;
    }

    public void startXpDelevelAnimation(MercenaryData mercenaryData) {
        this.predictedTargetXp = Mercenary.getRequiredExpLevel(mercenaryData.level - 1) + mercenaryData.experience;
        this.levelsToAnimate = -1;
        int startLevelRequiredXp = Mercenary.getRequiredExpLevel(mercenaryData.level);
        int startLevelNextXp = Mercenary.getRequiredExpLevel(mercenaryData.level + 1);
        int startLevelTotalXp = startLevelNextXp - startLevelRequiredXp;
        float startPercentage = startLevelTotalXp > 0 ? (float)(mercenaryData.experience - startLevelRequiredXp) / (float)startLevelTotalXp : 0.0f;
        this.currentXpBarWidth = this.xpBarStartWidth = (int)(48.0f * startPercentage);
        this.xpBarTargetWidth = 0;
        this.mercenaryLevelToShow = mercenaryData.level;
        this.isAnimatingXp = true;
        this.currentAnimationDurationMs = 1500L;
        this.animationStartTime = System.currentTimeMillis();
        this.isBarWidthComputed = true;
        this.mercenaryData = mercenaryData;
    }

    public void tick() {
        if (!this.isAnimatingXp) {
            return;
        }
        long elapsedTime = System.currentTimeMillis() - this.animationStartTime;
        float progress = Math.min(1.0f, (float)elapsedTime / (float)this.currentAnimationDurationMs);
        this.currentXpBarWidth = (int)((float)this.xpBarStartWidth + (float)(this.xpBarTargetWidth - this.xpBarStartWidth) * progress);
        if (this.levelsToAnimate != 0) {
            ++this.xpSoundTickCounter;
            if (this.xpSoundTickCounter % 4 == 0) {
                float pitch = 1.0f + progress * 0.5f;
                SoundInit.playXpTickSound(1.0f, pitch);
            }
        }
        if (progress >= 1.0f) {
            if (this.levelsToAnimate > 0) {
                SoundInit.playLevelUpSound(1.0f, 1.0f);
                SoundInit.playMercenaryVoiceline(this.mercenaryData.name, "level_up");
                ++this.mercenaryLevelToShow;
                --this.levelsToAnimate;
                this.currentAnimationDurationMs = Math.max(500L, this.currentAnimationDurationMs - 250L);
                this.animationStartTime = System.currentTimeMillis() + 300L;
                this.xpBarStartWidth = 0;
                if (this.levelsToAnimate > 0) {
                    this.xpBarTargetWidth = 48;
                } else {
                    int finalLevel = Mercenary.getLevel(this.predictedTargetXp);
                    int finalLevelRequiredXp = Mercenary.getRequiredExpLevel(finalLevel);
                    int finalLevelNextXp = Mercenary.getRequiredExpLevel(finalLevel + 1);
                    int finalLevelTotalXp = finalLevelNextXp - finalLevelRequiredXp;
                    float finalPercentage = finalLevelTotalXp > 0 ? (float)(this.predictedTargetXp - finalLevelRequiredXp) / (float)finalLevelTotalXp : 1.0f;
                    this.xpBarTargetWidth = (int)(48.0f * finalPercentage);
                }
            } else if (this.levelsToAnimate < 0) {
                SoundInit.playLevelDownSound(1.0f, 1.0f);
                SoundInit.playMercenaryVoiceline(this.mercenaryData.name, "death");
                --this.mercenaryLevelToShow;
                ++this.levelsToAnimate;
                this.currentAnimationDurationMs = Math.max(500L, this.currentAnimationDurationMs - 250L);
                this.animationStartTime = System.currentTimeMillis() + 300L;
                this.xpBarStartWidth = 48;
                if (this.levelsToAnimate < 0) {
                    this.xpBarTargetWidth = 0;
                } else {
                    int finalLevel = Mercenary.getLevel(this.predictedTargetXp);
                    int finalLevelRequiredXp = Mercenary.getRequiredExpLevel(finalLevel);
                    int finalLevelNextXp = Mercenary.getRequiredExpLevel(finalLevel + 1);
                    int finalLevelTotalXp = finalLevelNextXp - finalLevelRequiredXp;
                    float finalPercentage = finalLevelTotalXp > 0 ? (float)(this.predictedTargetXp - finalLevelRequiredXp) / (float)finalLevelTotalXp : 0.0f;
                    this.xpBarTargetWidth = (int)(48.0f * finalPercentage);
                }
            } else {
                this.isAnimatingXp = false;
            }
        }
    }

    public int getMercenaryLevelToShow(MercenaryData mercenaryData) {
        if (!this.isAnimatingXp && !this.isBarWidthComputed) {
            this.mercenaryLevelToShow = mercenaryData.level;
        }
        return this.mercenaryLevelToShow;
    }

    public int getCurrentXpBarWidth(MercenaryData mercenaryData) {
        if (!this.isAnimatingXp && !this.isBarWidthComputed) {
            float xpPercentage = mercenaryData.nextLevelExperience > 0 ? (float)mercenaryData.experience / (float)mercenaryData.nextLevelExperience : 1.0f;
            this.currentXpBarWidth = (int)(48.0f * xpPercentage);
        }
        return this.currentXpBarWidth;
    }
}

