/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.data;

import io.github.sluggly.timemercenaries.client.handler.ButtonHandler;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.mercenary.Shopkeeper;
import io.github.sluggly.timemercenaries.missions.MissionItem;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;

public class ShopData {
    public final MissionItem[] shopItems;
    public final int maxItems;
    public final int numberOfItemsToDisplay;
    public final byte[] shopStatus;
    public final int itemsPerRow = 5;
    public final int multiplier = 1;
    public final int playerCoins;
    public ShopButton[] shopButtons;

    public ShopData(PlayerData playerData, Shopkeeper shopkeeper) {
        int i;
        int seed = MercenaryPlayerData.getMercenarySeed(playerData, shopkeeper.name);
        int level = MercenaryPlayerData.getMercenaryLevel(playerData, shopkeeper.name);
        this.shopItems = shopkeeper.getShopItems(seed, level);
        this.maxItems = Shopkeeper.maxItems;
        this.playerCoins = MercenaryPlayerData.getCurrentMercenaryCoins(playerData, shopkeeper.name);
        this.numberOfItemsToDisplay = Math.min(level, this.maxItems);
        this.shopButtons = new ShopButton[this.maxItems];
        this.shopStatus = MercenaryPlayerData.getShopkeeperShopStatus(playerData, shopkeeper.name);
        for (i = 0; i < this.numberOfItemsToDisplay; ++i) {
            this.shopButtons[i] = new ShopButton(this, i, 20, 20, ButtonHandler.Empty, ButtonHandler::handleBuyShopItem, this.shopItems[i].getItemTooltip(this.multiplier));
            if (this.playerCoins >= this.shopItems[i].price && this.shopStatus[i] != 1) continue;
            this.shopButtons[i].f_93623_ = false;
        }
        for (i = this.numberOfItemsToDisplay; i < this.maxItems; ++i) {
            this.shopButtons[i] = new ShopButton(this, i, 20, 20, ButtonHandler.Empty, ButtonHandler::doNothing, "Requires %s to be level %d.".formatted(shopkeeper.name, i + 1));
            this.shopButtons[i].f_93623_ = false;
        }
    }

    public static class ShopButton
    extends Button {
        public final ShopData shopData;
        public final int itemIndex;
        public static final Button.CreateNarration DEFAULT_NARRATION = Supplier::get;

        public ShopButton(ShopData shopData, int itemIndex, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress, String tooltip) {
            super(0, 0, pWidth, pHeight, pMessage, pOnPress, DEFAULT_NARRATION);
            this.shopData = shopData;
            this.itemIndex = itemIndex;
            if (tooltip != null) {
                this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)tooltip)));
            }
        }

        public ShopData getShopData() {
            return this.shopData;
        }
    }
}

