/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.handler;

import io.github.sluggly.timemercenaries.client.data.MercenaryData;
import io.github.sluggly.timemercenaries.client.data.MissionData;
import io.github.sluggly.timemercenaries.client.data.ModuleData;
import io.github.sluggly.timemercenaries.client.data.QuestData;
import io.github.sluggly.timemercenaries.client.data.ShopData;
import io.github.sluggly.timemercenaries.client.data.TraitData;
import io.github.sluggly.timemercenaries.client.handler.ClientHooks;
import io.github.sluggly.timemercenaries.client.screen.dtc.AbstractDimensionalTimeClockScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockEndMissionScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockGuideMainScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockMissionScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockQuestScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockRecruitScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockShopScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockTraitScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockWaitingMissionScreen;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.init.SoundInit;
import io.github.sluggly.timemercenaries.network.PacketHandler;
import net.minecraft.client.gui.components.Button;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class ButtonHandler {
    public static final Component Recruit = Component.m_237115_((String)"gui.dimensional_time_mod_screen.recruit_button");
    public static final Component Empty = Component.m_237115_((String)"gui.dimensional_time_mod_screen.empty_button");
    public static final Component Skip = Component.m_237115_((String)"gui.dimensional_time_mod_screen.skip_button");
    public static final Component Skipped = Component.m_237115_((String)"gui.dimensional_time_mod_screen.skipped_button");
    public static final Component Finish = Component.m_237115_((String)"gui.dimensional_time_mod_screen.finish_button");
    public static final Component Back = Component.m_237115_((String)"gui.dimensional_time_mod_screen.back_button");
    public static final Component Trait = Component.m_237115_((String)"gui.dimensional_time_mod_screen.trait_button");
    public static final Component TraitAvailable = Component.m_237115_((String)"gui.dimensional_time_mod_screen.trait_button").m_130948_(Style.f_131099_.m_178520_(65280));
    public static final Component Bribe = Component.m_237115_((String)"gui.dimensional_time_mod_screen.bribe_button");
    public static final Component Totem = Component.m_237115_((String)"gui.dimensional_time_mod_screen.totem_button");
    public static final Component Feed = Component.m_237115_((String)"gui.dimensional_time_mod_screen.feed_button");
    public static final Component ResetTraits = Component.m_237115_((String)"gui.dimensional_time_mod_screen.reset_traits_button");
    public static final Component GettingStarted = Component.m_237115_((String)"gui.dimensional_time_mod_screen.getting_started_button");
    public static final Component Mercenaries = Component.m_237115_((String)"gui.dimensional_time_mod_screen.mercenaries_button");
    public static final Component Modules = Component.m_237115_((String)"gui.dimensional_time_mod_screen.modules_button");
    public static final Component Previous = Component.m_237115_((String)"gui.dimensional_time_mod_screen.previous_button");
    public static final Component Next = Component.m_237115_((String)"gui.dimensional_time_mod_screen.next_button");
    public static final Component Shop = Component.m_237115_((String)"gui.dimensional_time_mod_screen.shop_button");
    public static final Component Waiting = Component.m_237115_((String)"gui.dimensional_time_mod_screen.wait_button");
    public static final Component Revive = Component.m_237115_((String)"gui.dimensional_time_mod_screen.revive_button");
    public static final Component Results = Component.m_237115_((String)"gui.dimensional_time_mod_screen.results_button");
    public static final Component Accept = Component.m_237115_((String)"gui.dimensional_time_mod_screen.accept_button");
    public static final Component Complete = Component.m_237115_((String)"gui.dimensional_time_mod_screen.complete_button");
    public static final Component Mission = Component.m_237115_((String)"gui.dimensional_time_mod_screen.mission_button");
    public static final Component Quest = Component.m_237115_((String)"gui.dimensional_time_mod_screen.quest_button");
    public static final Component SkipQuests = Component.m_237115_((String)"gui.dimensional_time_mod_screen.skip_quests_button");
    public static final Component AbandonQuest = Component.m_237115_((String)"gui.dimensional_time_mod_screen.abandon_quest_button");

    public static void doNothing(Button ignoredButton) {
    }

    public static void handleRecruitButton(Button button) {
        final MercenaryData.MercenaryButton mercenaryButton = (MercenaryData.MercenaryButton)button;
        PacketHandler.sendToServer("Recruit", new CompoundTag(){
            {
                this.m_128359_("Mercenary", mercenaryButton.getMercenaryData().name);
            }
        });
        SoundInit.playMercenaryVoiceline(mercenaryButton.mercenaryData.name, "recruit");
    }

    public static void handleSendButton(Button button) {
        final MissionData.MissionButton missionButton = (MissionData.MissionButton)button;
        PacketHandler.sendToServer("SendMission", new CompoundTag(){
            {
                this.m_128359_("Mercenary", DimensionalTimeClockMissionScreen.mercenaryData.name);
                this.m_128359_("Mission", String.valueOf(missionButton.getMissionData().id));
            }
        });
        SoundInit.playMercenaryVoiceline(DimensionalTimeClockMissionScreen.mercenaryData.name, "send");
    }

    public static void handleSkipButton(Button ignoredButton) {
        PacketHandler.sendToServer("SkipMission", new CompoundTag(){
            {
                this.m_128359_("Mercenary", DimensionalTimeClockMissionScreen.mercenaryData.name);
            }
        });
        SoundInit.playMercenaryVoiceline(DimensionalTimeClockMissionScreen.mercenaryData.name, "skip");
    }

    public static void handleShopSkipButton(Button ignoredButton) {
        PacketHandler.sendToServer("SkipShop", new CompoundTag(){
            {
                this.m_128359_("Mercenary", DimensionalTimeClockShopScreen.mercenaryData.name);
            }
        });
        SoundInit.playMercenaryVoiceline(DimensionalTimeClockShopScreen.mercenaryData.name, "skip");
    }

    public static void handleFinishButton(Button ignoredButton) {
        PacketHandler.sendToServer("FinishMission", new CompoundTag(){
            {
                this.m_128359_("Mercenary", DimensionalTimeClockEndMissionScreen.mercenaryData.name);
            }
        });
    }

    public static void handleBackButton(Button ignoredButton) {
        ClientHooks.openPreviousScreen();
    }

    public static void handleTraitButton(Button button) {
        MercenaryData.MercenaryButton mercenaryButton = (MercenaryData.MercenaryButton)button;
        ClientHooks.openDimensionalTimeClockTraitScreen(mercenaryButton.getMercenaryData().name);
    }

    public static void handleLevelUpTraitButton(Button button) {
        final TraitData.TraitButton traitButton = (TraitData.TraitButton)button;
        PacketHandler.sendToServer("LevelTrait", new CompoundTag(){
            {
                this.m_128359_("Mercenary", DimensionalTimeClockTraitScreen.mercenaryData.name);
                this.m_128359_("Trait", traitButton.getTrait());
            }
        });
        SoundInit.playMercenaryVoiceline(DimensionalTimeClockTraitScreen.mercenaryData.name, "trait");
    }

    public static void handleBribeButton(Button button) {
        final MercenaryData.MercenaryButton mercenaryButton = (MercenaryData.MercenaryButton)button;
        PacketHandler.sendToServer("Bribe", new CompoundTag(){
            {
                this.m_128359_("Mercenary", mercenaryButton.getMercenaryData().name);
            }
        });
        SoundInit.playMercenaryVoiceline(mercenaryButton.mercenaryData.name, "bribe");
    }

    public static void handleTotemButton(Button ignoredButton) {
        PacketHandler.sendToServer("Totem", new CompoundTag(){
            {
                this.m_128359_("Mercenary", DimensionalTimeClockMissionScreen.mercenaryData.name);
            }
        });
        SoundInit.playMercenaryVoiceline(DimensionalTimeClockMissionScreen.mercenaryData.name, "totem");
    }

    public static void handleResetTraitsButton(Button ignoredButton) {
        PacketHandler.sendToServer("ResetTraits", new CompoundTag(){
            {
                this.m_128359_("Mercenary", DimensionalTimeClockTraitScreen.mercenaryData.name);
            }
        });
    }

    public static void handleGuideButton(Button ignoredButton) {
        ClientHooks.openDimensionalTimeClockMainGuideScreen();
    }

    public static void handleOpenRecruitScreen(Button ignoredButton) {
        ClientHooks.openScreen(DimensionalTimeClockRecruitScreen.class);
    }

    public static void handleChangeSection(Button button) {
        DimensionalTimeClockGuideMainScreen.update.setDirty();
        if (button == DimensionalTimeClockGuideMainScreen.gettingStartedSectionButton) {
            DimensionalTimeClockGuideMainScreen.section = "GettingStarted";
        } else if (button == DimensionalTimeClockGuideMainScreen.mercenariesSectionButton) {
            DimensionalTimeClockGuideMainScreen.section = "Mercenaries";
        } else if (button == DimensionalTimeClockGuideMainScreen.modulesSectionButton) {
            DimensionalTimeClockGuideMainScreen.section = "Modules";
        }
    }

    public static void nextMercenaryIndex(Button ignoredButton) {
        DimensionalTimeClockGuideMainScreen.update.setDirty();
        DimensionalTimeClockGuideMainScreen.currentRecruitIndex = Math.min(DimensionalTimeClockGuideMainScreen.currentRecruitIndex + 1, DimensionalTimeClockGuideMainScreen.mercenariesData.length - 1);
        if (DimensionalTimeClockGuideMainScreen.currentRecruitIndex == DimensionalTimeClockGuideMainScreen.mercenariesData.length - 1) {
            DimensionalTimeClockGuideMainScreen.nextMercenaryButton.f_93623_ = false;
        }
        DimensionalTimeClockGuideMainScreen.previousMercenaryButton.f_93623_ = true;
        DimensionalTimeClockGuideMainScreen.itemScrollOffset = 0;
    }

    public static void previousMercenaryIndex(Button ignoredButton) {
        DimensionalTimeClockGuideMainScreen.update.setDirty();
        DimensionalTimeClockGuideMainScreen.currentRecruitIndex = Math.max(DimensionalTimeClockGuideMainScreen.currentRecruitIndex - 1, 0);
        if (DimensionalTimeClockGuideMainScreen.currentRecruitIndex == 0) {
            DimensionalTimeClockGuideMainScreen.previousMercenaryButton.f_93623_ = false;
        }
        DimensionalTimeClockGuideMainScreen.nextMercenaryButton.f_93623_ = true;
        DimensionalTimeClockGuideMainScreen.itemScrollOffset = 0;
    }

    public static void handleUnlockModule(Button button) {
        final ModuleData.ModuleButton moduleButton = (ModuleData.ModuleButton)button;
        PacketHandler.sendToServer("UnlockModule", new CompoundTag(){
            {
                this.m_128359_("Module", String.valueOf(moduleButton.getModuleIndex()));
            }
        });
    }

    public static void handlePrintNBT(Button ignoredButton) {
        PlayerData.logCustomData(null, false);
        PacketHandler.sendToServer("PrintNBT");
    }

    public static void handleGenerateMissionResult(Button ignoredButton) {
        PacketHandler.sendToServer("GenerateMissionResults", new CompoundTag(){
            {
                this.m_128359_("Mercenary", DimensionalTimeClockWaitingMissionScreen.mercenaryData.name);
            }
        });
    }

    public static void handleScoutingReturn(Button ignoredButton) {
        PacketHandler.sendToServer("ScoutingReturn");
    }

    public static void handleSkippingReturn(Button ignoredButton) {
        PacketHandler.sendToServer("SkippingReturn");
    }

    public static void handleRecruitSkipButton(Button button) {
        final MercenaryData.MercenaryButton mercenaryButton = (MercenaryData.MercenaryButton)button;
        PacketHandler.sendToServer("SkipMission", new CompoundTag(){
            {
                this.m_128359_("Mercenary", mercenaryButton.getMercenaryData().name);
            }
        });
    }

    public static void handleRecruitScreenMissionButton(Button button) {
        final MercenaryData.MercenaryButton mercenaryButton = (MercenaryData.MercenaryButton)button;
        PacketHandler.sendToServer("MercenaryWaitingScreen", new CompoundTag(){
            {
                this.m_128359_("Mercenary", mercenaryButton.getMercenaryData().name);
            }
        });
    }

    public static void handleResurrectButton(Button button) {
        final MercenaryData.MercenaryButton mercenaryButton = (MercenaryData.MercenaryButton)button;
        PacketHandler.sendToServer("Resurrect", new CompoundTag(){
            {
                this.m_128359_("Mercenary", mercenaryButton.getMercenaryData().name);
            }
        });
    }

    public static void handleRerollMissionButton(Button button) {
        final MissionData.MissionButton missionButton = (MissionData.MissionButton)button;
        PacketHandler.sendToServer("RerollMission", new CompoundTag(){
            {
                this.m_128359_("Mercenary", DimensionalTimeClockMissionScreen.mercenaryData.name);
                this.m_128359_("Mission", String.valueOf(missionButton.getMissionData().id));
            }
        });
    }

    public static void handleSameRerollMissionButton(Button button) {
        final MissionData.MissionButton missionButton = (MissionData.MissionButton)button;
        PacketHandler.sendToServer("SameRerollMission", new CompoundTag(){
            {
                this.m_128359_("Mercenary", DimensionalTimeClockMissionScreen.mercenaryData.name);
                this.m_128359_("Mission", String.valueOf(missionButton.getMissionData().id));
            }
        });
    }

    public static void handleChangeMissionDifficultyButton(Button button) {
        final MissionData.MissionButton missionButton = (MissionData.MissionButton)button;
        PacketHandler.sendToServer("ChangeMissionDifficulty", new CompoundTag(){
            {
                this.m_128359_("Mercenary", DimensionalTimeClockMissionScreen.mercenaryData.name);
                this.m_128359_("Mission", String.valueOf(missionButton.getMissionData().id));
            }
        });
    }

    public static void handleOpenShopButton(Button button) {
        PacketHandler.sendToServer("OpenShop");
        MercenaryData.MercenaryButton mercenaryButton = (MercenaryData.MercenaryButton)button;
        SoundInit.playMercenaryVoiceline(mercenaryButton.mercenaryData.name, "recruit");
    }

    public static void handleOpenQuestButton(Button ignoredButton) {
        PacketHandler.sendToServer("OpenQuest");
    }

    public static void handleAcceptQuestButton(Button button) {
        final QuestData.QuestButton questButton = (QuestData.QuestButton)button;
        PacketHandler.sendToServer("AcceptQuest", new CompoundTag(){
            {
                this.m_128359_("Mercenary", DimensionalTimeClockQuestScreen.mercenaryData.name);
                this.m_128405_("Quest", questButton.getQuestData().questIndex);
            }
        });
        SoundInit.playMercenaryVoiceline("Vael", "buy");
    }

    public static void handleShopAbandonQuestButton(Button ignoredButton) {
        PacketHandler.sendToServer("AbandonQuest", new CompoundTag(){
            {
                this.m_128359_("Mercenary", DimensionalTimeClockQuestScreen.mercenaryData.name);
            }
        });
    }

    public static void handleShopCompleteQuestButton(Button ignoredButton) {
        PacketHandler.sendToServer("CompleteQuest", new CompoundTag(){
            {
                this.m_128359_("Mercenary", DimensionalTimeClockQuestScreen.mercenaryData.name);
            }
        });
    }

    public static void handleBuyShopItem(Button button) {
        final ShopData.ShopButton shopButton = (ShopData.ShopButton)button;
        PacketHandler.sendToServer("BuyShopItem", new CompoundTag(){
            {
                this.m_128405_("Index", shopButton.itemIndex);
            }
        });
        SoundInit.playMercenaryVoiceline(DimensionalTimeClockShopScreen.mercenaryData.name, "buy");
    }

    public static void handleCompleteLoreStep(Button ignoredButton) {
        PacketHandler.sendToServer("CompleteLoreStep");
    }

    public static void handleFeedMercenaryButton(Button button) {
        final MercenaryData.MercenaryButton mercenaryButton = (MercenaryData.MercenaryButton)button;
        PacketHandler.sendToServer("FeedMercenary", new CompoundTag(){
            {
                this.m_128359_("Mercenary", mercenaryButton.getMercenaryData().name);
            }
        });
        SoundInit.playMercenaryVoiceline(mercenaryButton.mercenaryData.name, "feed");
    }

    public static void handleAdminReset(Button ignoredButton) {
        PacketHandler.sendToServer("ADMIN_RESET");
    }

    public static void handleAdminItems(Button ignoredButton) {
        PacketHandler.sendToServer("ADMIN_ITEMS");
    }

    public static void handleAdminInstant(Button ignoredButton) {
        PacketHandler.sendToServer("ADMIN_INSTANT");
    }

    public static void handleAdminResetAdvancements(Button ignoredButton) {
        PacketHandler.sendToServer("ADMIN_RESET_ADVANCEMENTS");
    }

    public static void handleAdminResetModules(Button ignoredButton) {
        PacketHandler.sendToServer("ADMIN_RESET_MODULES");
    }

    public static void handleAdminRerollRecruits(Button ignoredButton) {
        PacketHandler.sendToServer("ADMIN_REROLL_RECRUITS");
    }

    public static void handleAdminRunTests(Button ignoredButton) {
        PacketHandler.sendToServer("ADMIN_TESTS");
    }

    public static void handleAdminLevelUpMercenary(Button button) {
        final AbstractDimensionalTimeClockScreen.AdminButton adminButton = (AbstractDimensionalTimeClockScreen.AdminButton)button;
        PacketHandler.sendToServer("ADMIN_LEVEL_UP", new CompoundTag(){
            {
                this.m_128359_("Mercenary", adminButton.getMercenaryData().name);
            }
        });
    }

    public static void handleAdminKillMercenary(Button button) {
        final AbstractDimensionalTimeClockScreen.AdminButton adminButton = (AbstractDimensionalTimeClockScreen.AdminButton)button;
        PacketHandler.sendToServer("ADMIN_KILL", new CompoundTag(){
            {
                this.m_128359_("Mercenary", adminButton.getMercenaryData().name);
            }
        });
    }

    public static void handleAdminResurrectMercenary(Button button) {
        final AbstractDimensionalTimeClockScreen.AdminButton adminButton = (AbstractDimensionalTimeClockScreen.AdminButton)button;
        PacketHandler.sendToServer("ADMIN_RESURRECT", new CompoundTag(){
            {
                this.m_128359_("Mercenary", adminButton.getMercenaryData().name);
            }
        });
    }

    public static void handleAdminDamageMercenary(Button button) {
        final AbstractDimensionalTimeClockScreen.AdminButton adminButton = (AbstractDimensionalTimeClockScreen.AdminButton)button;
        PacketHandler.sendToServer("ADMIN_DAMAGE", new CompoundTag(){
            {
                this.m_128359_("Mercenary", adminButton.getMercenaryData().name);
            }
        });
    }

    public static void handleAdminHealMercenary(Button button) {
        final AbstractDimensionalTimeClockScreen.AdminButton adminButton = (AbstractDimensionalTimeClockScreen.AdminButton)button;
        PacketHandler.sendToServer("ADMIN_HEAL", new CompoundTag(){
            {
                this.m_128359_("Mercenary", adminButton.getMercenaryData().name);
            }
        });
    }

    public static void handleAdminFeedMercenary(Button button) {
        final AbstractDimensionalTimeClockScreen.AdminButton adminButton = (AbstractDimensionalTimeClockScreen.AdminButton)button;
        PacketHandler.sendToServer("ADMIN_FEED_MERCENARY", new CompoundTag(){
            {
                this.m_128359_("Mercenary", adminButton.getMercenaryData().name);
                this.m_128405_("Index", adminButton.index);
            }
        });
    }

    public static void handleAdminNextMercenary(Button button) {
        final AbstractDimensionalTimeClockScreen.AdminButton adminButton = (AbstractDimensionalTimeClockScreen.AdminButton)button;
        PacketHandler.sendToServer("ADMIN_NEXT", new CompoundTag(){
            {
                this.m_128359_("Index", String.valueOf(adminButton.index));
            }
        });
    }

    public static void handleAdminRerollMission(Button button) {
        final AbstractDimensionalTimeClockScreen.AdminButton adminButton = (AbstractDimensionalTimeClockScreen.AdminButton)button;
        PacketHandler.sendToServer("ADMIN_REROLL_MISSION", new CompoundTag(){
            {
                this.m_128359_("Mercenary", adminButton.getMercenaryData().name);
                this.m_128359_("Index", String.valueOf(adminButton.index));
            }
        });
    }

    public static void handleAdminRerollQuest(Button button) {
        final AbstractDimensionalTimeClockScreen.AdminButton adminButton = (AbstractDimensionalTimeClockScreen.AdminButton)button;
        PacketHandler.sendToServer("ADMIN_REROLL_QUEST", new CompoundTag(){
            {
                this.m_128359_("Mercenary", adminButton.getMercenaryData().name);
                this.m_128405_("Index", adminButton.index);
            }
        });
    }

    public static void handleAdminAddQuestProgress(Button button) {
        final AbstractDimensionalTimeClockScreen.AdminButton adminButton = (AbstractDimensionalTimeClockScreen.AdminButton)button;
        PacketHandler.sendToServer("ADMIN_PROGRESS_QUEST", new CompoundTag(){
            {
                this.m_128359_("Mercenary", adminButton.getMercenaryData().name);
            }
        });
    }

    public static void handleAdminMercenaryAllTraits(Button button) {
        final AbstractDimensionalTimeClockScreen.AdminButton adminButton = (AbstractDimensionalTimeClockScreen.AdminButton)button;
        PacketHandler.sendToServer("ADMIN_MERCENARY_TRAITS", new CompoundTag(){
            {
                this.m_128359_("Mercenary", adminButton.getMercenaryData().name);
            }
        });
    }

    public static void handleAdminSuccessMission(Button button) {
        final AbstractDimensionalTimeClockScreen.AdminButton adminButton = (AbstractDimensionalTimeClockScreen.AdminButton)button;
        PacketHandler.sendToServer("ADMIN_SUCCESS_MISSION", new CompoundTag(){
            {
                this.m_128359_("Mercenary", adminButton.getMercenaryData().name);
            }
        });
    }

    public static void handleAdminFailMission(Button button) {
        final AbstractDimensionalTimeClockScreen.AdminButton adminButton = (AbstractDimensionalTimeClockScreen.AdminButton)button;
        PacketHandler.sendToServer("ADMIN_FAIL_MISSION", new CompoundTag(){
            {
                this.m_128359_("Mercenary", adminButton.getMercenaryData().name);
            }
        });
    }

    public static void handleAdminResetCoins(Button ignoredButton) {
        PacketHandler.sendToServer("ADMIN_RESET_COINS");
    }

    public static void handleAdminAddCoins(Button ignoredButton) {
        PacketHandler.sendToServer("ADMIN_ADD_COINS");
    }

    public static void handleAdminRerollShop(Button button) {
        final AbstractDimensionalTimeClockScreen.AdminButton adminButton = (AbstractDimensionalTimeClockScreen.AdminButton)button;
        PacketHandler.sendToServer("ADMIN_REROLL_SHOP", new CompoundTag(){
            {
                this.m_128359_("Mercenary", adminButton.getMercenaryData().name);
            }
        });
    }

    public static void handleAdminSkipTutorial(Button ignoredButton) {
        PacketHandler.sendToServer("ADMIN_SKIP_TUTORIAL");
    }

    public static void handleAdminNextLoreStep(Button ignoredButton) {
        PacketHandler.sendToServer("ADMIN_NEXT_LORE_STEP");
    }

    public static void handleAdminChangeLoreCount(Button button) {
        final AbstractDimensionalTimeClockScreen.AdminButton adminButton = (AbstractDimensionalTimeClockScreen.AdminButton)button;
        PacketHandler.sendToServer("ADMIN_CHANGE_LORE_COUNT", new CompoundTag(){
            {
                this.m_128405_("Index", adminButton.index);
            }
        });
    }

    public static void handleLoreFirstCarorotFight(Button ignoredbutton) {
        PacketHandler.sendToServer("Lore_first_carorot_fight");
    }
}

