/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.handler;

import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.client.data.LoreData;
import io.github.sluggly.timemercenaries.client.data.MercenaryData;
import io.github.sluggly.timemercenaries.client.data.MissionData;
import io.github.sluggly.timemercenaries.client.data.ModuleData;
import io.github.sluggly.timemercenaries.client.data.QuestData;
import io.github.sluggly.timemercenaries.client.data.ShopData;
import io.github.sluggly.timemercenaries.client.data.StatisticsData;
import io.github.sluggly.timemercenaries.client.data.TraitData;
import io.github.sluggly.timemercenaries.client.screen.dtc.AbstractDimensionalTimeClockScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockEndMissionScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockGuideMainScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockMissionScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockQuestScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockRecruitScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockShopScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockTraitScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockTutorialScreen;
import io.github.sluggly.timemercenaries.client.screen.dtc.DimensionalTimeClockWaitingMissionScreen;
import io.github.sluggly.timemercenaries.config.ClientConfig;
import io.github.sluggly.timemercenaries.data.PlayerData;
import io.github.sluggly.timemercenaries.init.SoundInit;
import io.github.sluggly.timemercenaries.item.DimensionalTimeClock;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.mercenary.Shopkeeper;
import io.github.sluggly.timemercenaries.mercenary.Trait;
import io.github.sluggly.timemercenaries.missions.Mission;
import io.github.sluggly.timemercenaries.missions.MissionItem;
import io.github.sluggly.timemercenaries.module.Module;
import io.github.sluggly.timemercenaries.network.StoCPacket;
import io.github.sluggly.timemercenaries.utils.NBTKeys;
import io.github.sluggly.timemercenaries.utils.Utils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ClientHooks {
    public static String currentScreen = "None";
    public static String previousScreen = "None";

    public static void handleActions(StoCPacket msg) {
        String action = msg.action;
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Action received : " + action);
        }
        switch (action) {
            case "OpenTutorialScreen": {
                ClientHooks.updateNBTData(msg);
                ClientHooks.openTutorialScreen();
                break;
            }
            case "OpenRecruitScreen": {
                ClientHooks.updateNBTData(msg);
                ClientHooks.openScreen(DimensionalTimeClockRecruitScreen.class);
                break;
            }
            case "OpenMissionsScreen": {
                ClientHooks.updateNBTData(msg);
                ClientHooks.openScreen(DimensionalTimeClockMissionScreen.class);
                break;
            }
            case "MissionSentAccept": 
            case "MissionSkipAccept": {
                ClientHooks.updateNBTData(msg);
                Mercenary.addMercenariesToMapClient(null);
                ClientHooks.closeCurrentScreen();
                break;
            }
            case "SkipShopAccept": {
                ClientHooks.updateNBTData(msg);
                Mercenary.addMercenariesToMapClient(null);
                ClientHooks.openScreen(DimensionalTimeClockWaitingMissionScreen.class);
                break;
            }
            case "OpenWaitingMissionScreen": {
                ClientHooks.updateNBTData(msg);
                ClientHooks.openScreen(DimensionalTimeClockWaitingMissionScreen.class);
                break;
            }
            case "OpenEndMissionScreen": {
                ClientHooks.updateNBTData(msg);
                ClientHooks.openScreen(DimensionalTimeClockEndMissionScreen.class);
                break;
            }
            case "FinishMission": 
            case "CloseScreen": {
                ClientHooks.closeCurrentScreen();
                ClientHooks.updateNBTData(msg);
                break;
            }
            case "AddMercenariesToMap": {
                ClientHooks.updateNBTData(msg);
                Mercenary.addMercenariesToMapClient(null);
                break;
            }
            case "RefreshData": 
            case "TraitLeveled": {
                ClientHooks.updateNBTData(msg);
                break;
            }
            case "PlaySoundMissionFinished": {
                ClientHooks.handleMissionFinishedNotification();
                break;
            }
            case "OpenShopScreen": {
                ClientHooks.updateNBTData(msg);
                ClientHooks.openShopScreen();
                break;
            }
            case "OpenQuestScreen": {
                ClientHooks.updateNBTData(msg);
                ClientHooks.openQuestScreen();
                break;
            }
            case "LogData": {
                PlayerData.logCustomData(null, false);
                break;
            }
            case "AdminItems": {
                Admin.CLIENT_ADMIN_NO_ITEM_REQUIRED = true;
                break;
            }
            case "AdminItemsNo": {
                Admin.CLIENT_ADMIN_NO_ITEM_REQUIRED = false;
                break;
            }
            case "Admin": {
                Admin.CLIENT_IS_ADMIN_MODE_ACTIVATED = true;
                break;
            }
            case "AdminNo": {
                Admin.CLIENT_IS_ADMIN_MODE_ACTIVATED = false;
                break;
            }
            case "AdminLog": {
                Admin.ADMIN_SERVER_CONSOLE_LOG = true;
                break;
            }
            case "AdminLogNo": {
                Admin.ADMIN_SERVER_CONSOLE_LOG = false;
                break;
            }
            case "AdminInstant": {
                Admin.CLIENT_ADMIN_MISSION_INSTANT = true;
                DimensionalTimeClock.mapMercenaryTimeLeft.replaceAll((n, v) -> 5);
                break;
            }
            case "AdminInstantNo": {
                Admin.CLIENT_ADMIN_MISSION_INSTANT = false;
            }
        }
    }

    public static void handleMissionFinishedNotification() {
        if (((Boolean)ClientConfig.PLAY_MISSION_FINISHED_SOUND.get()).booleanValue()) {
            SoundInit.playMissionFinishedSound(1.0f, 1.0f);
        }
        if (((Boolean)ClientConfig.SHOW_MISSION_FINISHED_MESSAGE.get()).booleanValue()) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            assert (player != null);
            player.m_213846_((Component)Component.m_237113_((String)"Dimensional Time Clock: Ready to use!").m_130940_(ChatFormatting.GREEN));
        }
    }

    public static void openScreen(Class<? extends AbstractDimensionalTimeClockScreen> screenClass) {
        try {
            Minecraft.m_91087_().m_91152_((Screen)screenClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            Field field = screenClass.getDeclaredField("screenType");
            String tmpScreen = (String)field.get(null);
            if (!currentScreen.equals(tmpScreen)) {
                previousScreen = currentScreen;
                currentScreen = tmpScreen;
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            System.err.println("Failed to instantiate the class: " + e.getMessage());
        }
    }

    public static void openPreviousScreen() {
        if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
            System.out.println("Open previous screen : " + previousScreen);
        }
        if (!previousScreen.equals("None")) {
            ClientHooks.openScreen(AbstractDimensionalTimeClockScreen.mapTypeToScreenClass.get(previousScreen));
        }
    }

    public static void openTutorialScreen() {
        ClientHooks.updateTutorialScreenData();
        Minecraft.m_91087_().m_91152_((Screen)new DimensionalTimeClockTutorialScreen());
    }

    public static void openShopScreen() {
        ClientHooks.updateShopScreenData();
        Minecraft.m_91087_().m_91152_((Screen)new DimensionalTimeClockShopScreen());
    }

    public static void openQuestScreen() {
        ClientHooks.updateQuestScreenData();
        Minecraft.m_91087_().m_91152_((Screen)new DimensionalTimeClockQuestScreen());
    }

    public static void openDimensionalTimeClockTraitScreen(String mercenaryName) {
        ClientHooks.updateTraitScreen(mercenaryName);
        Minecraft.m_91087_().m_91152_((Screen)new DimensionalTimeClockTraitScreen());
        previousScreen = currentScreen;
    }

    public static void openDimensionalTimeClockMainGuideScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new DimensionalTimeClockGuideMainScreen());
        previousScreen = currentScreen;
    }

    public static void closeCurrentScreen() {
        Minecraft.m_91087_().m_91152_(null);
    }

    public static void updateNBTData(StoCPacket msg) {
        String state;
        PlayerData playerData;
        CompoundTag customData = msg.getTag();
        PlayerData.globalPlayerData = playerData = new PlayerData((Player)Minecraft.m_91087_().f_91074_, customData.m_6426_());
        switch (state = playerData.getCurrentState()) {
            case "Recruiting": {
                ClientHooks.updateRecruitScreenData(playerData);
                break;
            }
            case "SendingMission": {
                ClientHooks.updateSendMissionScreen(playerData);
                break;
            }
            case "WaitingMission": {
                ClientHooks.updateWaitingMissionScreenData(playerData);
                break;
            }
            case "EndMission": {
                ClientHooks.updateEndMissionScreen(playerData);
            }
        }
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        if (currentScreen instanceof DimensionalTimeClockTraitScreen) {
            ClientHooks.updateTraitScreen(DimensionalTimeClockTraitScreen.mercenaryData.name);
        }
        ClientHooks.updateGameGuideData();
        if (currentScreen instanceof DimensionalTimeClockShopScreen) {
            ClientHooks.updateShopScreenData();
        }
        if (currentScreen instanceof DimensionalTimeClockQuestScreen) {
            ClientHooks.updateQuestScreenData();
        }
        if (currentScreen instanceof DimensionalTimeClockTutorialScreen) {
            ClientHooks.updateTutorialScreenData();
        }
    }

    public static QuestData getQuestData(PlayerData playerData, MercenaryData mercenaryData, int questIndex) {
        return new QuestData(playerData, mercenaryData, questIndex);
    }

    public static MercenaryData getMercenaryData(PlayerData playerData, Mercenary mercenary) {
        return new MercenaryData(playerData, mercenary);
    }

    public static MissionData getMissionData(PlayerData playerData, MercenaryData mercenaryData, ModuleData moduleData, Mission mission) {
        return new MissionData(mission, playerData, mercenaryData, moduleData);
    }

    public static ModuleData getModuleData(PlayerData playerData) {
        return new ModuleData(playerData);
    }

    public static TraitData getTraitData(MercenaryData mercenaryData, PlayerData playerData) {
        return new TraitData(mercenaryData, playerData);
    }

    public static ShopData getShopData(PlayerData playerData, Shopkeeper shopkeeper) {
        return new ShopData(playerData, shopkeeper);
    }

    public static LoreData getLoreData(PlayerData playerData) {
        return new LoreData(playerData);
    }

    public static void updateShopScreenData() {
        PlayerData playerData = PlayerData.getPlayerData(null);
        Shopkeeper shopkeeper = (Shopkeeper)Mercenary.getMercenary("Vael");
        MercenaryData mercenaryData = ClientHooks.getMercenaryData(playerData, shopkeeper);
        mercenaryData.shouldRenderButtonRecruit = false;
        DimensionalTimeClockShopScreen.mercenaryData = mercenaryData;
        DimensionalTimeClockShopScreen.shopData = ClientHooks.getShopData(playerData, shopkeeper);
        DimensionalTimeClockShopScreen.update.setDirty();
    }

    public static void updateQuestScreenData() {
        MercenaryData mercenaryData;
        PlayerData playerData = PlayerData.getPlayerData(null);
        Shopkeeper shopkeeper = (Shopkeeper)Mercenary.getMercenary("Vael");
        DimensionalTimeClockQuestScreen.mercenaryData = mercenaryData = ClientHooks.getMercenaryData(playerData, shopkeeper);
        int numberOfQuests = 3;
        DimensionalTimeClockQuestScreen.questsData = new QuestData[numberOfQuests];
        for (int index = 0; index < numberOfQuests; ++index) {
            QuestData questData;
            DimensionalTimeClockQuestScreen.questsData[index] = questData = ClientHooks.getQuestData(playerData, mercenaryData, index + 1);
        }
        mercenaryData.shouldRenderButtonTrait = false;
        mercenaryData.shouldRenderButtonRecruit = true;
        DimensionalTimeClockQuestScreen.shopData = ClientHooks.getShopData(playerData, shopkeeper);
        DimensionalTimeClockQuestScreen.update.setDirty();
    }

    public static void updateTutorialScreenData() {
        PlayerData playerData = PlayerData.getPlayerData(null);
        DimensionalTimeClockTutorialScreen.loreData = ClientHooks.getLoreData(playerData);
        DimensionalTimeClockTutorialScreen.update.setDirty();
    }

    public static void updateGameGuideData() {
        PlayerData playerData = PlayerData.getPlayerData(null);
        List<MercenaryData> mercenariesData = Mercenary.getMercenariesEntrySet().stream().filter(entry -> MercenaryPlayerData.isMercenaryUnlocked(playerData, (String)entry.getKey()) && !((String)entry.getKey()).equals("Vael")).map(entry -> {
            Mercenary mercenary = (Mercenary)entry.getValue();
            MercenaryData mercenaryData = ClientHooks.getMercenaryData(playerData, mercenary);
            mercenaryData.shouldRenderButtonTotem = true;
            mercenaryData.shouldRenderButtonTrait = true;
            return mercenaryData;
        }).toList();
        for (MercenaryData mercenaryData : mercenariesData) {
            if (mercenaryData.name.equals("Vael")) {
                mercenaryData.shouldRenderButtonTrait = false;
            }
            mercenaryData.statisticsData = new StatisticsData(playerData, mercenaryData.name);
        }
        DimensionalTimeClockGuideMainScreen.mercenariesData = mercenariesData.toArray(new MercenaryData[0]);
        DimensionalTimeClockGuideMainScreen.moduleData = ClientHooks.getModuleData(playerData);
        DimensionalTimeClockGuideMainScreen.update.setDirty();
    }

    public static void updateRecruitScreenData(PlayerData playerData) {
        String[] recruitsAvailable = MercenaryPlayerData.getRecruitsAvailable(playerData);
        if (recruitsAvailable.length == 0) {
            System.out.println("Error, no recruits available");
            return;
        }
        ArrayList<Mercenary> mercenaries = new ArrayList<Mercenary>();
        for (String mercenaryName : recruitsAvailable) {
            mercenaries.add(Mercenary.getMercenary(mercenaryName));
        }
        DimensionalTimeClockRecruitScreen.mercenariesData = new MercenaryData[mercenaries.size()];
        for (int index = 0; index < mercenaries.size(); ++index) {
            Mercenary mercenary = (Mercenary)mercenaries.get(index);
            MercenaryData mercenaryData = ClientHooks.getMercenaryData(playerData, mercenary);
            if (!(mercenary instanceof Shopkeeper)) {
                mercenaryData.shouldRenderButtonTotem = true;
                mercenaryData.shouldRenderButtonTrait = true;
            }
            mercenaryData.shouldRenderButtonRecruit = true;
            DimensionalTimeClockRecruitScreen.mercenariesData[index] = mercenaryData;
        }
        DimensionalTimeClockRecruitScreen.moduleData = ClientHooks.getModuleData(playerData);
        DimensionalTimeClockRecruitScreen.update.setDirty();
    }

    public static void updateSendMissionScreen(PlayerData playerData) {
        String chosenRecruit = MercenaryPlayerData.getCurrentMercenary(playerData);
        Mercenary chosenMercenary = Mercenary.getMercenary(chosenRecruit);
        MercenaryData mercenaryData = ClientHooks.getMercenaryData(playerData, chosenMercenary);
        ModuleData moduleData = ClientHooks.getModuleData(playerData);
        mercenaryData.shouldRenderButtonTotem = true;
        mercenaryData.shouldRenderButtonTrait = true;
        List<ResourceLocation> missionsAvailable = MercenaryPlayerData.getMercenaryMissionsAvailable(playerData, chosenRecruit);
        DimensionalTimeClockMissionScreen.missionsData = new MissionData[missionsAvailable.size()];
        for (int index = 0; index < missionsAvailable.size(); ++index) {
            ResourceLocation missionId = missionsAvailable.get(index);
            Mission mission = Mission.getMissionFromId(missionId);
            assert (mission != null);
            DimensionalTimeClockMissionScreen.missionsData[index] = ClientHooks.getMissionData(playerData, mercenaryData, moduleData, mission);
            DimensionalTimeClockMissionScreen.missionsData[index].shouldRenderRerollButton = moduleData.hasModule("Dice Module");
            DimensionalTimeClockMissionScreen.missionsData[index].shouldRenderSameRerollButton = moduleData.hasModule("D-Infinite Module");
        }
        MissionItem totemItem = Mercenary.totemItem;
        assert (Minecraft.m_91087_().f_91074_ != null);
        DimensionalTimeClockMissionScreen.canTotem = Utils.hasEnoughItems(totemItem.itemStack.m_41720_(), (Player)Minecraft.m_91087_().f_91074_, totemItem.number);
        DimensionalTimeClockMissionScreen.totemItemTexture = totemItem.itemStack;
        DimensionalTimeClockMissionScreen.totemItemNumber = totemItem.number;
        int usedTrait = MercenaryPlayerData.getMercenaryLevelsSpent(playerData, chosenRecruit) + 1;
        DimensionalTimeClockMissionScreen.hasTraitsAvailable = mercenaryData.level - usedTrait > 0;
        DimensionalTimeClockMissionScreen.mercenaryData = mercenaryData;
        DimensionalTimeClockMissionScreen.moduleData = moduleData;
        DimensionalTimeClockMissionScreen.update.setDirty();
    }

    public static void updateEndMissionScreen(PlayerData playerData) {
        String chosenRecruit = MercenaryPlayerData.getCurrentMercenary(playerData);
        String missionStatus = MercenaryPlayerData.getMercenaryMissionStatus(playerData, chosenRecruit);
        if (!missionStatus.equals("Skipped")) {
            ModuleData moduleData;
            Mercenary chosenMercenary = Mercenary.getMercenary(chosenRecruit);
            MercenaryData mercenaryData = ClientHooks.getMercenaryData(playerData, chosenMercenary);
            mercenaryData.shouldRenderButtonTotem = true;
            ResourceLocation missionId = MercenaryPlayerData.getMercenaryChosenMission(playerData, chosenRecruit);
            Mission mission = Mission.getMissionFromId(missionId);
            assert (mission != null);
            DimensionalTimeClockEndMissionScreen.missionStatus = missionStatus;
            DimensionalTimeClockEndMissionScreen.moduleData = moduleData = ClientHooks.getModuleData(playerData);
            MissionData missionData = ClientHooks.getMissionData(playerData, mercenaryData, moduleData, mission);
            missionData.shouldRenderSendButton = true;
            missionData.canMissionStart = false;
            DimensionalTimeClockEndMissionScreen.missionData = missionData;
            int doubleLevel = MercenaryPlayerData.getMercenaryTraitLevel(playerData, chosenRecruit, "Greedy");
            int multiplier = MercenaryPlayerData.getMercenaryLootMultiplier(playerData, chosenRecruit);
            DimensionalTimeClockEndMissionScreen.didGreedyTraitProc = false;
            if (multiplier > 1) {
                DimensionalTimeClockEndMissionScreen.didGreedyTraitProc = true;
                DimensionalTimeClockEndMissionScreen.doubleDesc = Trait.getTrait("Greedy").getDescription(doubleLevel);
                DimensionalTimeClockEndMissionScreen.doubleLevel = doubleLevel;
            }
            DimensionalTimeClockEndMissionScreen.didScavengerTraitProc = false;
            DimensionalTimeClockEndMissionScreen.hasTotemBeenUsed = false;
            switch (missionData.missionStatus) {
                case "Success": {
                    int traitLevel;
                    SoundInit.playMercenaryVoiceline(mercenaryData.name, "success");
                    DimensionalTimeClockEndMissionScreen.missionStatusTextTitle = "Mission is a success!";
                    DimensionalTimeClockEndMissionScreen.successFailDeathDescription = missionData.successDescription;
                    missionData.shouldRenderTotalCoins = Module.isModuleActive(playerData, "Coin Module");
                    if (!MercenaryPlayerData.doesMercenaryScavengerTraitProc(playerData, chosenRecruit)) break;
                    int randomValue = MercenaryPlayerData.getMercenaryScavengerTraitValue(playerData, chosenRecruit);
                    Trait trait = Trait.getTrait(randomValue);
                    DimensionalTimeClockEndMissionScreen.didScavengerTraitProc = true;
                    DimensionalTimeClockEndMissionScreen.scavengerTraitLevel = traitLevel = MercenaryPlayerData.getMercenaryTraitLevel(playerData, chosenRecruit, trait.name) + 1;
                    DimensionalTimeClockEndMissionScreen.scavengerTraitTexture = trait.itemTexture.m_7968_();
                    DimensionalTimeClockEndMissionScreen.scavengerTraitDesc = trait.getDescription(traitLevel);
                    break;
                }
                case "Failed": {
                    DimensionalTimeClockEndMissionScreen.missionStatusTextTitle = "Mission has been failed!";
                    DimensionalTimeClockEndMissionScreen.successFailDeathDescription = String.valueOf(mission.failDescription);
                    SoundInit.playMercenaryVoiceline(mercenaryData.name, "fail");
                    break;
                }
                case "Death": {
                    DimensionalTimeClockEndMissionScreen.missionStatusTextTitle = chosenMercenary.name + " has died.";
                    if (MercenaryPlayerData.doesMercenaryHaveTotem(playerData, chosenRecruit)) {
                        DimensionalTimeClockEndMissionScreen.successFailDeathDescription = mission.failDescription + "\nThankfully his Totem of Undying saved him! The mercenary retains all his levels and traits.";
                        DimensionalTimeClockEndMissionScreen.hasTotemBeenUsed = true;
                        mercenaryData.hasTotem = false;
                        break;
                    }
                    DimensionalTimeClockEndMissionScreen.successFailDeathDescription = String.valueOf(mission.failDescription);
                    String traitName = MercenaryPlayerData.getMercenaryRandomTraitDeathTarget(playerData, chosenMercenary.name);
                    if (traitName != null) {
                        int traitLevel;
                        Trait trait = Trait.getTrait(traitName);
                        DimensionalTimeClockEndMissionScreen.didLostTraitProc = true;
                        DimensionalTimeClockEndMissionScreen.lostTraitLevel = traitLevel = MercenaryPlayerData.getMercenaryTraitLevel(playerData, chosenRecruit, trait.name) - 1;
                        DimensionalTimeClockEndMissionScreen.lostTraitTexture = trait.itemTexture.m_7968_();
                        DimensionalTimeClockEndMissionScreen.lostTraitDesc = trait.getDescription(traitLevel);
                        break;
                    }
                    DimensionalTimeClockEndMissionScreen.didLostTraitProc = false;
                }
            }
            DimensionalTimeClockEndMissionScreen.mercenaryData = mercenaryData;
            DimensionalTimeClockEndMissionScreen.update.setDirty();
        }
    }

    public static void updateTraitScreen(String mercenaryName) {
        PlayerData playerData = PlayerData.getPlayerData(null);
        Mercenary chosenMercenary = Mercenary.getMercenary(mercenaryName);
        MercenaryData mercenaryData = ClientHooks.getMercenaryData(playerData, chosenMercenary);
        mercenaryData.shouldRenderButtonTotem = true;
        int totalLevels = mercenaryData.getTotalLevels();
        MissionItem resetTraitsItem = Mercenary.resetTraitsItem;
        assert (Minecraft.m_91087_().f_91074_ != null);
        DimensionalTimeClockTraitScreen.canReset = totalLevels > 0 && Utils.hasEnoughItems(resetTraitsItem.itemStack.m_41720_(), (Player)Minecraft.m_91087_().f_91074_, resetTraitsItem.number);
        DimensionalTimeClockTraitScreen.resetItemTooltip = totalLevels == 0 && Utils.hasEnoughItems(resetTraitsItem.itemStack.m_41720_(), (Player)Minecraft.m_91087_().f_91074_, resetTraitsItem.number) ? "Mercenary has no allocated traits." : resetTraitsItem.number + " " + Utils.unformatString(resetTraitsItem.itemStack.m_41720_().toString());
        DimensionalTimeClockTraitScreen.resetItemTexture = resetTraitsItem.itemStack;
        DimensionalTimeClockTraitScreen.resetItemNumber = resetTraitsItem.number;
        DimensionalTimeClockTraitScreen.mercenaryData = mercenaryData;
        DimensionalTimeClockTraitScreen.traitData = ClientHooks.getTraitData(mercenaryData, playerData);
        DimensionalTimeClockTraitScreen.update.setDirty();
    }

    public static void updateWaitingMissionScreenData(PlayerData playerData) {
        String mercenaryName = MercenaryPlayerData.getCurrentMercenary(playerData);
        Mercenary mercenary = Mercenary.getMercenary(mercenaryName);
        MercenaryData mercenaryData = ClientHooks.getMercenaryData(playerData, mercenary);
        mercenaryData.shouldRenderButtonTotem = true;
        mercenaryData.shouldRenderButtonRecruit = false;
        mercenaryData.shouldRenderButtonTrait = false;
        ModuleData moduleData = ClientHooks.getModuleData(playerData);
        ResourceLocation missionId = MercenaryPlayerData.getMercenaryChosenMission(playerData, MercenaryPlayerData.getCurrentMercenary(playerData));
        if (!missionId.toString().equals(NBTKeys.MISSION_EMPTY_ID.toString())) {
            Mission mission = Mission.getMissionFromId(missionId);
            assert (mission != null);
            MissionData missionData = ClientHooks.getMissionData(playerData, mercenaryData, moduleData, mission);
            missionData.shouldRenderSendButton = true;
            missionData.canMissionStart = false;
            DimensionalTimeClockWaitingMissionScreen.missionData = missionData;
        } else {
            DimensionalTimeClockWaitingMissionScreen.missionData = null;
        }
        DimensionalTimeClockWaitingMissionScreen.mercenaryData = mercenaryData;
        DimensionalTimeClockWaitingMissionScreen.moduleData = moduleData;
        DimensionalTimeClockWaitingMissionScreen.update.setDirty();
    }
}

