/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.handler;

import io.github.sluggly.timemercenaries.compat.ItemObtainCategory;
import io.github.sluggly.timemercenaries.compat.JeiTimeMercenariesPlugin;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.MercenaryManager;
import io.github.sluggly.timemercenaries.missions.Mission;
import io.github.sluggly.timemercenaries.missions.MissionItem;
import io.github.sluggly.timemercenaries.missions.MissionManager;
import io.github.sluggly.timemercenaries.module.ModuleManager;
import io.github.sluggly.timemercenaries.network.SyncMercenariesPacket;
import io.github.sluggly.timemercenaries.network.SyncMissionsPacket;
import io.github.sluggly.timemercenaries.network.SyncModulesPacket;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;

public class ClientSyncHandler {
    private static boolean areMissionsSynced = false;
    private static boolean areMercenariesSynced = false;

    public static void handleSyncMissions(SyncMissionsPacket msg) {
        MissionManager missionManager = MissionManager.getMissionManager();
        missionManager.setMissions(msg.missions());
        areMissionsSynced = true;
        ClientSyncHandler.refreshJeiRecipes();
    }

    public static void handleSyncMercenaries(SyncMercenariesPacket msg) {
        MercenaryManager mercenaryManager = MercenaryManager.getMercenaryManager();
        mercenaryManager.setMercenaries(msg.mercenaries());
        areMercenariesSynced = true;
        ClientSyncHandler.refreshJeiRecipes();
    }

    public static void handleSyncModules(SyncModulesPacket msg) {
        ModuleManager moduleManager = ModuleManager.getModuleManager();
        moduleManager.setModules(msg.modules());
    }

    private static void refreshJeiRecipes() {
        if (!areMissionsSynced || !areMercenariesSynced) {
            return;
        }
        if (JeiTimeMercenariesPlugin.recipeManager == null) {
            System.err.println("JEI Recipe Manager is not available yet. Recipes will be added later.");
            return;
        }
        ArrayList<ItemObtainCategory.ObtainMethod> recipes = new ArrayList<ItemObtainCategory.ObtainMethod>();
        MissionManager.getMissionManager().getAllMissions().forEach((missionId, missionDefinition) -> {
            Mercenary mercenary = Mercenary.getMercenary(missionDefinition.mercenary());
            if (mercenary == null) {
                return;
            }
            for (MissionItem successItem : missionDefinition.successItems()) {
                if (successItem.entity != null || successItem.itemStack == null || successItem.itemStack.m_41619_()) continue;
                recipes.add(new ItemObtainCategory.ObtainMethod(successItem.itemStack, mercenary.name, Mission.getMissionFromId(missionId)));
            }
        });
        Mercenary chaosMercenary = Mercenary.getMercenary("Chaos");
        if (chaosMercenary == null) {
            return;
        }
        for (int index = 0; index < chaosMercenary.missionRarityList.size(); ++index) {
            for (ResourceLocation missionId2 : chaosMercenary.missionRarityList.get(index)) {
                Mission mission = Mission.getMissionFromId(missionId2);
                assert (mission != null);
                for (MissionItem successItem : mission.getSuccessItems(-1)) {
                    if (successItem.entity != null || successItem.itemStack == null || successItem.itemStack.m_41619_()) continue;
                    recipes.add(new ItemObtainCategory.ObtainMethod(successItem.itemStack, chaosMercenary.name, mission));
                }
            }
        }
        JeiTimeMercenariesPlugin.recipeManager.addRecipes(ItemObtainCategory.OBTAIN_METHOD_RECIPE_TYPE, recipes);
        System.out.println("Added " + recipes.size() + " recipes to JEI.");
    }

    public static void resetSyncFlags() {
        areMissionsSynced = false;
        areMercenariesSynced = false;
    }
}

