/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.github.sluggly.timemercenaries.entity.projectile.BeamProjectile;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class BeamRenderer
extends EntityRenderer<BeamProjectile> {
    private static final ResourceLocation BEAM_TEXTURE = new ResourceLocation("minecraft", "textures/entity/beacon_beam.png");

    public BeamRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.f_114477_ = 0.0f;
    }

    protected boolean shouldShowName(@NotNull BeamProjectile pEntity) {
        return false;
    }

    public void render(BeamProjectile beam, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        Vec3 start = beam.getStartPos();
        Vec3 end = beam.getEndPos();
        Vec3 beamVector = end.m_82546_(start);
        Color color = new Color(beam.getColor());
        float width = 0.04f;
        float length = (float)beamVector.m_82553_();
        float rotation = beam.rotation + partialTicks * 15.0f;
        poseStack.m_85836_();
        double x = Mth.m_14139_((double)partialTicks, (double)beam.f_19854_, (double)beam.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)beam.f_19855_, (double)beam.m_20186_());
        double z = Mth.m_14139_((double)partialTicks, (double)beam.f_19856_, (double)beam.m_20189_());
        poseStack.m_85837_(start.f_82479_ - x, start.f_82480_ - y, start.f_82481_ - z);
        this.alignToVector(poseStack, beamVector);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110460_((ResourceLocation)BEAM_TEXTURE, (boolean)true));
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float alpha = 0.8f;
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotation));
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f poseMatrix = pose.m_252922_();
        Matrix3f normalMatrix = pose.m_252943_();
        this.addQuad(vertexConsumer, poseMatrix, normalMatrix, r, g, b, alpha, -width, -width, width, width, 0.0f, length, 0.0f, 1.0f, 0.0f, 1.0f);
        poseStack.m_85849_();
        poseStack.m_85849_();
        super.m_7392_((Entity)beam, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void alignToVector(PoseStack poseStack, Vec3 direction) {
        if (direction.m_82556_() < 1.0E-6) {
            return;
        }
        Vec3 forward = new Vec3(0.0, 0.0, 1.0);
        Vec3 dir = direction.m_82541_();
        Vec3 axis = forward.m_82537_(dir);
        double axisLength = axis.m_82553_();
        if (axisLength < 1.0E-6) {
            if (forward.m_82526_(dir) < 0.0) {
                poseStack.m_252781_(new Quaternionf().rotateXYZ((float)Math.PI, 0.0f, 0.0f));
            }
            return;
        }
        axis = axis.m_82541_();
        double angle = Math.acos(forward.m_82526_(dir));
        Quaternionf rotation = new Quaternionf().rotateAxis((float)angle, (float)axis.f_82479_, (float)axis.f_82480_, (float)axis.f_82481_);
        poseStack.m_252781_(rotation);
    }

    private void addQuad(VertexConsumer consumer, Matrix4f poseMatrix, Matrix3f normalMatrix, float r, float g, float b, float a, float x1, float y1, float x2, float y2, float z1, float z2, float u1, float u2, float v1, float v2) {
        this.addVertex(consumer, poseMatrix, normalMatrix, r, g, b, a, x1, y1, z1, u1, v1);
        this.addVertex(consumer, poseMatrix, normalMatrix, r, g, b, a, x1, y1, z2, u1, v2);
        this.addVertex(consumer, poseMatrix, normalMatrix, r, g, b, a, x2, y2, z2, u2, v2);
        this.addVertex(consumer, poseMatrix, normalMatrix, r, g, b, a, x2, y2, z1, u2, v1);
    }

    private void addVertex(VertexConsumer consumer, Matrix4f poseMatrix, Matrix3f normalMatrix, float r, float g, float b, float a, float x, float y, float z, float u, float v) {
        consumer.m_252986_(poseMatrix, x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_7122_(0, 10).m_85969_(240).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public boolean shouldRender(@NotNull BeamProjectile pLivingEntity, @NotNull Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return true;
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull BeamProjectile pEntity) {
        return BEAM_TEXTURE;
    }
}

