/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.screen;

import io.github.sluggly.timemercenaries.config.ClientConfig;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ClientConfigScreen
extends Screen {
    private final Screen parent;
    private boolean playSound;
    private boolean showMessage;
    private boolean showHud;
    private double hudScale;
    private boolean muteAllSounds;
    private boolean playVoicelines;
    private boolean showVoicelineTranscripts;

    public ClientConfigScreen(Screen parent) {
        super((Component)Component.m_237113_((String)"Time Mercenaries Configuration"));
        this.parent = parent;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.playSound = (Boolean)ClientConfig.PLAY_MISSION_FINISHED_SOUND.get();
        this.showMessage = (Boolean)ClientConfig.SHOW_MISSION_FINISHED_MESSAGE.get();
        this.showHud = (Boolean)ClientConfig.SHOW_ARENA_TEAMS_HUD.get();
        this.hudScale = (Double)ClientConfig.ARENA_TEAMS_HUD_SCALE.get();
        this.muteAllSounds = (Boolean)ClientConfig.MUTE_ALL_SOUNDS.get();
        this.playVoicelines = (Boolean)ClientConfig.PLAY_MERCENARY_VOICELINES.get();
        this.showVoicelineTranscripts = (Boolean)ClientConfig.SHOW_MERCENARY_VOICELINE_TRANSCRIPTS.get();
        int screenWidth = this.f_96543_;
        int screenHeight = this.f_96544_;
        int columnWidth = 145;
        int columnSpacing = 10;
        int leftColX = screenWidth / 2 - columnWidth - columnSpacing / 2;
        int rightColX = screenWidth / 2 + columnSpacing / 2;
        int buttonWidth = 30;
        int buttonHeight = 16;
        int sliderWidth = 50;
        int y = screenHeight / 4 + 12;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getBooleanComponent(this.playSound), button -> {
            this.playSound = !this.playSound;
            button.m_93666_(this.getBooleanComponent(this.playSound));
        }).m_252987_(leftColX + columnWidth - buttonWidth, y, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getBooleanComponent(this.showMessage), button -> {
            this.showMessage = !this.showMessage;
            button.m_93666_(this.getBooleanComponent(this.showMessage));
        }).m_252987_(rightColX + columnWidth - buttonWidth, y, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getBooleanComponent(this.muteAllSounds), button -> {
            this.muteAllSounds = !this.muteAllSounds;
            button.m_93666_(this.getBooleanComponent(this.muteAllSounds));
        }).m_252987_(leftColX + columnWidth - buttonWidth, y += 30, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getBooleanComponent(this.playVoicelines), button -> {
            this.playVoicelines = !this.playVoicelines;
            button.m_93666_(this.getBooleanComponent(this.playVoicelines));
        }).m_252987_(leftColX + columnWidth - buttonWidth, y += 30, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getBooleanComponent(this.showVoicelineTranscripts), button -> {
            this.showVoicelineTranscripts = !this.showVoicelineTranscripts;
            button.m_93666_(this.getBooleanComponent(this.showVoicelineTranscripts));
        }).m_252987_(rightColX + columnWidth - buttonWidth, y, buttonWidth, buttonHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getBooleanComponent(this.showHud), button -> {
            this.showHud = !this.showHud;
            button.m_93666_(this.getBooleanComponent(this.showHud));
        }).m_252987_(leftColX + columnWidth - buttonWidth, y += 30, buttonWidth, buttonHeight).m_253136_());
        double initialSliderValue = (this.hudScale - 0.1) / 2.9;
        this.m_142416_((GuiEventListener)new AbstractSliderButton(rightColX + columnWidth - buttonWidth, y, sliderWidth, buttonHeight, (Component)Component.m_237119_(), initialSliderValue){
            {
                this.m_5695_();
            }

            protected void m_5695_() {
                this.m_93666_((Component)Component.m_237113_((String)String.format("%.2f", 0.1 + this.f_93577_ * 2.9)));
            }

            protected void m_5697_() {
                ClientConfigScreen.this.hudScale = 0.1 + this.f_93577_ * 2.9;
            }
        });
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> this.saveAndClose()).m_252987_(screenWidth / 2 - 100, screenHeight - 28, 98, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), button -> this.m_7379_()).m_252987_(screenWidth / 2 + 2, screenHeight - 28, 98, 20).m_253136_());
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        int screenWidth = this.f_96543_;
        int screenHeight = this.f_96544_;
        int columnWidth = 150;
        int columnSpacing = 10;
        int leftColX = screenWidth / 2 - columnWidth - columnSpacing / 2;
        int rightColX = screenWidth / 2 + columnSpacing / 2;
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        int optionY = screenHeight / 4;
        guiGraphics.m_280488_(this.f_96547_, "Notifications", leftColX, optionY, 0xFFFF55);
        guiGraphics.m_280488_(this.f_96547_, "Play Mission Sound", leftColX, optionY += 15, 0xA0A0A0);
        guiGraphics.m_280488_(this.f_96547_, "Show Mission Message", rightColX, optionY, 0xA0A0A0);
        guiGraphics.m_280488_(this.f_96547_, "Sounds", leftColX, optionY += 15, 0xFFFF55);
        guiGraphics.m_280488_(this.f_96547_, "Mute All Sounds", leftColX, optionY += 15, 0xA0A0A0);
        guiGraphics.m_280488_(this.f_96547_, "Mercenary Voicelines", leftColX, optionY += 30, 0xA0A0A0);
        guiGraphics.m_280488_(this.f_96547_, "Voicelines transcripts", rightColX, optionY, 0xA0A0A0);
        guiGraphics.m_280488_(this.f_96547_, "Arena", leftColX, optionY += 15, 0xFFFF55);
        guiGraphics.m_280488_(this.f_96547_, "Show Teams HUD", leftColX, optionY += 15, 0xA0A0A0);
        guiGraphics.m_280488_(this.f_96547_, "Teams HUD Scale", rightColX, optionY, 0xA0A0A0);
    }

    private Component getBooleanComponent(boolean value) {
        return Component.m_237113_((String)(value ? "ON" : "OFF"));
    }

    private void saveAndClose() {
        ClientConfig.PLAY_MISSION_FINISHED_SOUND.set((Object)this.playSound);
        ClientConfig.SHOW_MISSION_FINISHED_MESSAGE.set((Object)this.showMessage);
        ClientConfig.MUTE_ALL_SOUNDS.set((Object)this.muteAllSounds);
        ClientConfig.PLAY_MERCENARY_VOICELINES.set((Object)this.playVoicelines);
        ClientConfig.SHOW_MERCENARY_VOICELINE_TRANSCRIPTS.set((Object)this.showVoicelineTranscripts);
        ClientConfig.SHOW_ARENA_TEAMS_HUD.set((Object)this.showHud);
        ClientConfig.ARENA_TEAMS_HUD_SCALE.set((Object)this.hudScale);
        ClientConfig.SPEC.save();
        this.m_7379_();
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
    }
}

