/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.screen.dtc;

import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.client.KeyBindings;
import io.github.sluggly.timemercenaries.client.data.LoreData;
import io.github.sluggly.timemercenaries.client.data.MercenaryData;
import io.github.sluggly.timemercenaries.client.data.MissionData;
import io.github.sluggly.timemercenaries.client.data.ModuleData;
import io.github.sluggly.timemercenaries.client.data.ScreenData;
import io.github.sluggly.timemercenaries.client.handler.ButtonHandler;
import io.github.sluggly.timemercenaries.client.handler.ClientHooks;
import io.github.sluggly.timemercenaries.init.ItemInit;
import io.github.sluggly.timemercenaries.item.DimensionalTimeClock;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.missions.MissionItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDimensionalTimeClockScreen
extends Screen {
    public ArrayList<AdminButton> adminButtons = new ArrayList();
    public int leftPos;
    public int topPos;
    public static final Component TITLE = Component.m_237115_((String)"gui.dimensional_time_mod_screen");
    public ResourceLocation TEXTURE;
    public static final ResourceLocation MERCENARY_INFO_TEXTURE = new ResourceLocation("timemercenaries", "textures/gui/dimensional_time_clock_mercenary_info.png");
    public static final ResourceLocation MISSION_INFO_TEXTURE = new ResourceLocation("timemercenaries", "textures/gui/dimensional_time_clock_mission_info.png");
    public static final ResourceLocation UNLOCKED_BACKGROUND = new ResourceLocation("timemercenaries", "textures/gui/unlocked.png");
    public static final ResourceLocation BLACK_BACKGROUND = new ResourceLocation("timemercenaries", "textures/gui/black.png");
    public static final ResourceLocation GRAY_BACKGROUND = new ResourceLocation("timemercenaries", "textures/gui/gray.png");
    public static final ResourceLocation GREEN_BACKGROUND = new ResourceLocation("timemercenaries", "textures/gui/green.png");
    public static final ResourceLocation BLUE_BACKGROUND = new ResourceLocation("timemercenaries", "textures/gui/blue.png");
    public static final ResourceLocation RED_BACKGROUND = new ResourceLocation("timemercenaries", "textures/gui/red.png");
    public static final ResourceLocation RED_HEART = new ResourceLocation("timemercenaries", "textures/gui/red_heart.png");
    public static final ResourceLocation BLACK_HEART = new ResourceLocation("timemercenaries", "textures/gui/black_heart.png");
    public static final ResourceLocation COIN = new ResourceLocation("timemercenaries", "textures/gui/coin.png");
    public static final ResourceLocation HUNGER = new ResourceLocation("timemercenaries", "textures/gui/hunger.png");
    public int imageWidth;
    public int imageHeight;
    public static String screenType;
    public ScreenData screenData;
    public boolean hasGameGuideBook;
    public static final HashMap<String, Class<? extends AbstractDimensionalTimeClockScreen>> mapTypeToScreenClass;
    public static final BooleanWrapper update;
    public final ArrayList<AbstractWidget> temporaryWidgets = new ArrayList();
    public static final ResourceLocation texture_exp_empty;
    public static final ResourceLocation texture_exp_filled;
    public static final ResourceLocation texture_checkmark;

    protected AbstractDimensionalTimeClockScreen() {
        super(TITLE);
    }

    public void commonInit(boolean hasGameGuideBook) {
        super.m_7856_();
        if (this.f_96541_ == null) {
            return;
        }
        if (this.f_96541_.f_91073_ == null) {
            return;
        }
        this.screenData = new ScreenData();
        update.reset();
        update.setScreen(this);
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.hasGameGuideBook = hasGameGuideBook;
        if (this.hasGameGuideBook) {
            this.addGuideScreenButton(8, 9);
        }
        this.initGlobalAdminButtons();
    }

    public void commonRender(@NotNull GuiGraphics graphics) {
        this.m_280273_(graphics);
        graphics.m_280218_(this.TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        graphics.m_280653_(this.f_96547_, TITLE, this.leftPos + this.imageWidth / 2, this.topPos + 14, 0xFFFFFF);
        if (this.hasGameGuideBook) {
            this.renderItem(graphics, Items.f_42750_.m_7968_(), this.leftPos + 10, this.topPos + 11);
        }
    }

    public void initGlobalAdminButtons() {
        if (Admin.CLIENT_IS_ADMIN_MODE_ACTIVATED) {
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"PRINT NBT"), ButtonHandler::handlePrintNBT).m_252987_(this.leftPos - 100, this.topPos + 10, 80, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"RESET DATA"), ButtonHandler::handleAdminReset).m_252987_(this.leftPos - 100, this.topPos + 40, 80, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"INFINITE ITEMS"), ButtonHandler::handleAdminItems).m_252987_(this.leftPos - 100, this.topPos + 70, 80, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"INSTANT MISSIONS"), ButtonHandler::handleAdminInstant).m_252987_(this.leftPos - 100, this.topPos + 100, 80, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"RESET ADVANCEMENTS"), ButtonHandler::handleAdminResetAdvancements).m_252987_(this.leftPos - 100, this.topPos + 130, 80, 20).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"RESET MODULES"), ButtonHandler::handleAdminResetModules).m_252987_(this.leftPos - 100, this.topPos + 160, 80, 20).m_253136_());
        }
    }

    public void removeWidget(Button button) {
        if (this.f_169369_.contains(button)) {
            this.f_169369_.remove(button);
            this.m_6702_().remove(button);
        }
    }

    public void addGuideScreenButton(int x, int y) {
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)ButtonHandler.Empty, ButtonHandler::handleGuideButton).m_252987_(this.leftPos + x, this.topPos + y, 20, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Time Mercenaries Guide"))).m_253136_());
    }

    public void renderCustomTextureProps(@NotNull GuiGraphics graphics, ResourceLocation texture, int x, int y, int z, int w, int h) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, (float)z);
        graphics.m_280163_(texture, x, y, 0.0f, 0.0f, w, h, w, h);
        graphics.m_280168_().m_85849_();
    }

    public void renderItemWithBackground(@NotNull GuiGraphics graphics, ItemStack itemStack, ResourceLocation background, int x, int y) {
        if (itemStack == null || itemStack.m_41720_().equals(ItemInit.DIMENSIONAL_TIME_CLOCK.get())) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 10.0f);
            graphics.m_280163_(background, x - 1, y - 1, 0.0f, 0.0f, 18, 18, 18, 18);
            graphics.m_280163_(MissionItem.questionMarkTexture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            graphics.m_280168_().m_85849_();
        } else {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 10.0f);
            graphics.m_280163_(background, x - 1, y - 1, 0.0f, 0.0f, 18, 18, 18, 18);
            graphics.m_280480_(itemStack, x, y);
            graphics.m_280168_().m_85849_();
        }
    }

    public void renderCustomTexture(@NotNull GuiGraphics graphics, ResourceLocation texture, int x, int y) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 10.0f);
        graphics.m_280163_(texture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        graphics.m_280168_().m_85849_();
    }

    public void renderItem(@NotNull GuiGraphics graphics, ItemStack itemStack, int x, int y) {
        if (itemStack == null || itemStack.m_41720_().equals(ItemInit.DIMENSIONAL_TIME_CLOCK.get())) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 10.0f);
            graphics.m_280163_(MissionItem.questionMarkTexture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            graphics.m_280168_().m_85849_();
        } else {
            graphics.m_280480_(itemStack, x, y);
        }
    }

    public void renderItemAndCount(@NotNull GuiGraphics graphics, ItemStack itemStack, int x, int y, String count, int color) {
        if (itemStack == null || itemStack.m_41720_().equals(ItemInit.DIMENSIONAL_TIME_CLOCK.get())) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
            graphics.m_280163_(MissionItem.questionMarkTexture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            graphics.m_280137_(this.f_96547_, count, x + 12, y + 8, color);
            graphics.m_280168_().m_85849_();
        } else {
            graphics.m_280480_(itemStack, x, y);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
            graphics.m_280137_(this.f_96547_, count, x + 12, y + 8, 0xFFFFFF);
            graphics.m_280168_().m_85849_();
        }
    }

    public void renderWidget(AbstractWidget widget) {
        this.temporaryWidgets.add(widget);
        this.m_142416_((GuiEventListener)widget);
    }

    public void deleteAllTemporaryWidgets() {
        for (AbstractWidget widget : this.temporaryWidgets) {
            this.m_169411_((GuiEventListener)widget);
        }
        this.temporaryWidgets.clear();
    }

    public void renderMercenaryInfo(@NotNull GuiGraphics graphics, int x, int y, int updateIndex, MercenaryData mercenaryData, ScreenData screenData) {
        graphics.m_280163_(MERCENARY_INFO_TEXTURE, this.leftPos + x, this.topPos + y, 0.0f, 0.0f, 167, 73, 256, 256);
        graphics.m_280163_(mercenaryData.texture, this.leftPos + x + 2, this.topPos + y + 2, 0.0f, 0.0f, 48, 69, 256, 256);
        graphics.m_280488_(this.f_96547_, "%s".formatted(mercenaryData.job), this.leftPos + x + 56, this.topPos + y + 3, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Level %d".formatted(screenData.getMercenaryLevelToShow(mercenaryData)), this.leftPos + x + 56, this.topPos + y + 13, Mercenary.getLevelColor(mercenaryData.level));
        graphics.m_280163_(texture_exp_empty, this.leftPos + x + 117, this.topPos + y + 13, 0.0f, 0.0f, 48, 8, 256, 256);
        graphics.m_280163_(texture_exp_filled, this.leftPos + x + 117, this.topPos + y + 13, 0.0f, 0.0f, screenData.getCurrentXpBarWidth(mercenaryData), 8, 256, 256);
        if (mercenaryData.hasTotem) {
            graphics.m_280480_(Items.f_42747_.m_7968_(), this.leftPos + x + 59, this.topPos + y + 51);
        }
        if (mercenaryData.shouldRenderButtonTrait && !mercenaryData.name.equals("Vael")) {
            if (mercenaryData.hasTraitAvailable) {
                mercenaryData.buttonTrait.m_93666_(ButtonHandler.TraitAvailable);
            } else {
                mercenaryData.buttonTrait.m_93666_(ButtonHandler.Trait);
            }
        }
        if (mercenaryData.shouldRenderHealth) {
            graphics.m_280163_(RED_HEART, this.leftPos + x + 56, this.topPos + y + 25, 0.0f, 0.0f, 7, 7, 7, 7);
            graphics.m_280488_(this.f_96547_, "%s".formatted(mercenaryData.currentHealth + "/" + mercenaryData.maxHealth), this.leftPos + x + 65, this.topPos + y + 25, mercenaryData.getMercenaryHealthStringColor());
        }
        if (mercenaryData.shouldRenderHunger) {
            graphics.m_280163_(HUNGER, this.leftPos + x + 56, this.topPos + y + 35, 0.0f, 0.0f, 9, 9, 9, 9);
            graphics.m_280488_(this.f_96547_, "%d/%d".formatted(mercenaryData.currentHunger, mercenaryData.maxHunger), this.leftPos + x + 67, this.topPos + y + 36, mercenaryData.getMercenaryHungerStringColor());
        }
        if (mercenaryData.shouldRenderButtonRecruit && mercenaryData.shouldRenderResurrectLevels) {
            this.renderItemAndCount(graphics, Items.f_42612_.m_7968_(), this.leftPos + x + 147, this.topPos + y + 52, "%d".formatted(mercenaryData.requiredResurrectLevels), 0xFFFFFF);
        }
        if (update.shouldUpdate(updateIndex)) {
            mercenaryData.nameWidget.m_264152_(this.leftPos + x + 2, this.topPos + y + 3);
            this.renderWidget((AbstractWidget)mercenaryData.nameWidget);
            if (mercenaryData.shouldRenderButtonTrait) {
                mercenaryData.buttonTrait.m_264152_(this.leftPos + x + 117, this.topPos + y + 25);
                this.renderWidget((AbstractWidget)mercenaryData.buttonTrait);
            }
            if (mercenaryData.shouldRenderButtonRecruit) {
                mercenaryData.buttonRecruit.m_264152_(this.leftPos + x + 117, this.topPos + y + 50);
                this.renderWidget((AbstractWidget)mercenaryData.buttonRecruit);
            }
            if (mercenaryData.shouldRenderButtonTotem && mercenaryData.hasTotem) {
                mercenaryData.buttonTotem.m_264152_(this.leftPos + x + 57, this.topPos + y + 50);
                this.renderWidget((AbstractWidget)mercenaryData.buttonTotem);
            }
            update.setUpdated(updateIndex);
        }
    }

    public void renderMissionInfo(@NotNull GuiGraphics graphics, int x, int y, int updateIndex, MissionData missionData, MercenaryData mercenaryData, ModuleData moduleData) {
        int i;
        graphics.m_280163_(MISSION_INFO_TEXTURE, this.leftPos + x, this.topPos + y, 0.0f, 0.0f, 81, 144, 256, 256);
        int yOffset = 15;
        graphics.m_280488_(this.f_96547_, "Rewards:", this.leftPos + x + 2, this.topPos + y + yOffset, 0xFFFFFF);
        if (missionData.shouldRenderInitialCoin) {
            graphics.m_280163_(COIN, this.leftPos + x + 50, this.topPos + y + yOffset, 0.0f, 0.0f, 9, 9, 9, 9);
            graphics.m_280488_(this.f_96547_, "%d".formatted(missionData.totalCoins), this.leftPos + x + 60, this.topPos + y + yOffset, 0xFFFFFF);
        }
        yOffset += 8;
        for (i = 0; i < missionData.rewardItems.length; ++i) {
            if (missionData.isMissionRandom && !moduleData.hasModule("Divination Module")) {
                this.renderItemAndCount(graphics, null, this.leftPos + x + 3 + i * 18, this.topPos + y + yOffset, "", 0xFFFFFF);
                continue;
            }
            if (missionData.rewardItems[i].itemStack == null) continue;
            this.renderItemAndCount(graphics, missionData.rewardItems[i].itemStack, this.leftPos + x + 3 + i * 18, this.topPos + y + yOffset, "%d".formatted(missionData.rewardItemsNumber[i]), 0xFFFFFF);
        }
        graphics.m_280488_(this.f_96547_, "Exp:", this.leftPos + x + 2, this.topPos + y + (yOffset += 19), 0xFFFFFF);
        if (moduleData.hasModule("Experience Tracker Module")) {
            graphics.m_280488_(this.f_96547_, "%d".formatted(missionData.experience), this.leftPos + x + 27, this.topPos + y + yOffset, missionData.experienceColor);
        } else {
            graphics.m_280488_(this.f_96547_, missionData.experienceString, this.leftPos + x + 27, this.topPos + y + yOffset, missionData.experienceColor);
        }
        graphics.m_280488_(this.f_96547_, "Time:", this.leftPos + x + 2, this.topPos + y + (yOffset += 10), 0xFFFFFF);
        if (moduleData.hasModule("Planner Module")) {
            graphics.m_280488_(this.f_96547_, "%ds".formatted(missionData.time), this.leftPos + x + 27, this.topPos + y + yOffset, missionData.timeColor);
        } else {
            graphics.m_280488_(this.f_96547_, missionData.timeString, this.leftPos + x + 27, this.topPos + y + yOffset, missionData.timeColor);
        }
        graphics.m_280488_(this.f_96547_, "Fail:", this.leftPos + x + 2, this.topPos + y + (yOffset += 10), 0xFFFFFF);
        if (moduleData.hasModule("Risk Evaluation Module")) {
            graphics.m_280488_(this.f_96547_, "%d%%".formatted(missionData.failChance), this.leftPos + x + 27, this.topPos + y + yOffset, missionData.failColor);
        } else {
            graphics.m_280488_(this.f_96547_, missionData.failString, this.leftPos + x + 27, this.topPos + y + yOffset, missionData.failColor);
        }
        graphics.m_280488_(this.f_96547_, "Risk:", this.leftPos + x + 2, this.topPos + y + (yOffset += 10), 0xFFFFFF);
        if (moduleData.hasModule("Advanced Risk Evaluation Module")) {
            graphics.m_280163_(BLACK_HEART, this.leftPos + x + 27, this.topPos + y + yOffset, 0.0f, 0.0f, 7, 7, 7, 7);
            graphics.m_280488_(this.f_96547_, "%d".formatted(missionData.failDamage), this.leftPos + x + 35, this.topPos + y + yOffset, missionData.deathColor);
        } else {
            graphics.m_280488_(this.f_96547_, missionData.failDamageString, this.leftPos + x + 27, this.topPos + y + yOffset, missionData.deathColor);
        }
        graphics.m_280488_(this.f_96547_, "Eat:", this.leftPos + x + 2, this.topPos + y + (yOffset += 10), 0xFFFFFF);
        if (moduleData.hasModule("Nutritional Analysis Module")) {
            graphics.m_280163_(HUNGER, this.leftPos + x + 27, this.topPos + y + yOffset, 0.0f, 0.0f, 9, 9, 9, 9);
            graphics.m_280488_(this.f_96547_, "%d".formatted(missionData.hungerCost), this.leftPos + x + 35, this.topPos + y + yOffset, missionData.hungerColor);
        } else {
            graphics.m_280488_(this.f_96547_, missionData.hungerString, this.leftPos + x + 27, this.topPos + y + yOffset, missionData.hungerColor);
        }
        if (missionData.shouldRenderDifficultyButton) {
            this.renderItem(graphics, missionData.difficultyMissionTexture, this.leftPos + x + 3, this.topPos + y + 94);
        }
        if (missionData.shouldRenderRerollButton) {
            this.renderItemAndCount(graphics, Items.f_41870_.m_7968_(), this.leftPos + x + 28, this.topPos + y + 94, String.valueOf(mercenaryData.rerollsLeft), 0xFFFFFF);
        }
        if (missionData.shouldRenderSameRerollButton) {
            this.renderItemAndCount(graphics, missionData.sameRerollItem.itemStack, this.leftPos + x + 53, this.topPos + y + 94, String.valueOf(mercenaryData.rerollsLeft), 0xFFFFFF);
        }
        graphics.m_280488_(this.f_96547_, "Required Items:", this.leftPos + x + 2, this.topPos + y + (yOffset += 31), 0xFFFFFF);
        if (!missionData.didProcurerTraitProc) {
            for (i = 0; i < missionData.requiredItems.length; ++i) {
                this.renderItemAndCount(graphics, missionData.requiredItems[i].itemStack, this.leftPos + x + 3 + i * 18, this.topPos + y + yOffset + 12, "%d".formatted(missionData.requiredItemsNumber[i]), 0xFFFFFF);
            }
        }
        if (update.shouldUpdate(updateIndex)) {
            missionData.nameWidget.m_264152_(this.leftPos + x + 13, this.topPos + y + 4);
            missionData.nameWidget.m_267729_();
            this.renderWidget((AbstractWidget)missionData.nameWidget);
            missionData.rewardItemTooltips.m_264152_(this.leftPos + x + 3, this.topPos + y + 23);
            this.renderWidget((AbstractWidget)missionData.rewardItemTooltips);
            if (missionData.shouldRenderSendButton) {
                missionData.buttonSendMission.m_264152_(this.leftPos + x + 1, this.topPos + y + 123);
                missionData.buttonSendMission.f_93623_ = missionData.canMissionStart;
                this.renderWidget((AbstractWidget)missionData.buttonSendMission);
            }
            if (missionData.shouldRenderRerollButton) {
                missionData.buttonRerollMission.m_264152_(this.leftPos + x + 26, this.topPos + y + 92);
                missionData.buttonRerollMission.f_93623_ = missionData.canMissionReroll;
                this.renderWidget((AbstractWidget)missionData.buttonRerollMission);
            }
            if (missionData.shouldRenderSameRerollButton) {
                missionData.buttonSameRerollMission.m_264152_(this.leftPos + x + 51, this.topPos + y + 92);
                missionData.buttonSameRerollMission.f_93623_ = missionData.canMissionSameReroll;
                this.renderWidget((AbstractWidget)missionData.buttonSameRerollMission);
            }
            if (missionData.shouldRenderDifficultyButton) {
                missionData.buttonDifficultyMission.m_264152_(this.leftPos + x + 1, this.topPos + y + 92);
                this.renderWidget((AbstractWidget)missionData.buttonDifficultyMission);
            }
            update.setUpdated(updateIndex);
        }
    }

    public void renderDialogPortrait(@NotNull GuiGraphics graphics, int x, int y, int updateIndex, LoreData loreData) {
        graphics.m_280163_(loreData.texture, this.leftPos + x + 2, this.topPos + y + 2, 0.0f, 0.0f, 49, 42, 256, 256);
        if (update.shouldUpdate(updateIndex)) {
            loreData.nameWidget.m_264152_(this.leftPos + x + 2, this.topPos + y + 3);
            this.renderWidget((AbstractWidget)loreData.nameWidget);
            update.setUpdated(updateIndex);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_6574_(@NotNull Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        update.setDirty();
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == KeyBindings.INSTANCE.useDimensionalTimeClockKey.getKey().m_84873_()) {
            assert (Minecraft.m_91087_().f_91073_ != null);
            DimensionalTimeClock.lastSentTick = Minecraft.m_91087_().f_91073_.m_46467_();
            ClientHooks.closeCurrentScreen();
            return true;
        }
        if (pKeyCode == Minecraft.m_91087_().f_91066_.f_92092_.getKey().m_84873_()) {
            ClientHooks.closeCurrentScreen();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    static {
        mapTypeToScreenClass = new HashMap();
        update = new BooleanWrapper();
        texture_exp_empty = new ResourceLocation("timemercenaries", "textures/gui/exp_bar.png");
        texture_exp_filled = new ResourceLocation("timemercenaries", "textures/gui/exp_bar_full.png");
        texture_checkmark = new ResourceLocation("timemercenaries", "textures/gui/checkmark.png");
    }

    public static class BooleanWrapper {
        public boolean isUpdated = false;
        int numberToUpdate = 0;
        AbstractDimensionalTimeClockScreen screen = null;

        public void setScreen(AbstractDimensionalTimeClockScreen screen) {
            this.screen = screen;
        }

        public void reset() {
            this.isUpdated = false;
            this.numberToUpdate = 0;
        }

        public void setDirty() {
            this.isUpdated = false;
            if (this.screen != null) {
                this.screen.deleteAllTemporaryWidgets();
            }
        }

        public void setUpdated(int index) {
            if (index == this.numberToUpdate) {
                ++this.numberToUpdate;
                this.isUpdated = true;
            } else if (index == this.numberToUpdate - 1) {
                this.isUpdated = true;
            }
        }

        public boolean shouldUpdate(int index) {
            return !this.isUpdated || index == this.numberToUpdate;
        }
    }

    public static class AdminButton
    extends Button {
        public MercenaryData mercenaryData = null;
        public int index = -1;
        public static final Button.CreateNarration DEFAULT_NARRATION = Supplier::get;

        public AdminButton(int pX, int pY, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress, String tooltip) {
            super(pX, pY, pWidth, pHeight, pMessage, pOnPress, DEFAULT_NARRATION);
            if (tooltip != null) {
                this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)tooltip)));
            }
        }

        public AdminButton(int index, int pX, int pY, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress, String tooltip) {
            super(pX, pY, pWidth, pHeight, pMessage, pOnPress, DEFAULT_NARRATION);
            this.index = index;
            if (tooltip != null) {
                this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)tooltip)));
            }
        }

        public AdminButton(MercenaryData mercenaryData, int pX, int pY, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress, String tooltip) {
            super(pX, pY, pWidth, pHeight, pMessage, pOnPress, DEFAULT_NARRATION);
            this.mercenaryData = mercenaryData;
            if (tooltip != null) {
                this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)tooltip)));
            }
        }

        public AdminButton(int index, MercenaryData mercenaryData, int pX, int pY, int pWidth, int pHeight, Component pMessage, Button.OnPress pOnPress, String tooltip) {
            super(pX, pY, pWidth, pHeight, pMessage, pOnPress, DEFAULT_NARRATION);
            this.index = index;
            this.mercenaryData = mercenaryData;
            if (tooltip != null) {
                this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)tooltip)));
            }
        }

        public void setMercenaryData(MercenaryData m) {
            this.mercenaryData = m;
        }

        public MercenaryData getMercenaryData() {
            return this.mercenaryData;
        }
    }
}

