/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.screen.dtc;

import io.github.sluggly.timemercenaries.client.data.MercenaryData;
import io.github.sluggly.timemercenaries.client.data.ModuleData;
import io.github.sluggly.timemercenaries.client.data.StatisticsData;
import io.github.sluggly.timemercenaries.client.handler.ButtonHandler;
import io.github.sluggly.timemercenaries.client.screen.dtc.AbstractDimensionalTimeClockScreen;
import io.github.sluggly.timemercenaries.missions.MissionItem;
import io.github.sluggly.timemercenaries.utils.Utils;
import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class DimensionalTimeClockGuideMainScreen
extends AbstractDimensionalTimeClockScreen {
    public static final String screenType = "GuideMainScreen";
    public static String section = "GettingStarted";
    public static String previousSection;
    public static Button gettingStartedSectionButton;
    public static Button mercenariesSectionButton;
    public static Button modulesSectionButton;
    public static Button previousMercenaryButton;
    public static Button nextMercenaryButton;
    public static int currentRecruitIndex;
    public static MercenaryData[] mercenariesData;
    public static ModuleData moduleData;
    public static final int[][] moduleGrid;
    private static int currentMercenaryInfoPanelIndex;
    private static final String[] MERCENARY_INFO_PANELS;
    private static Button previousInfoButton;
    private static Button nextInfoButton;
    public static int itemScrollOffset;
    private static Button scrollUpButton;
    private static Button scrollDownButton;
    private static final int ITEMS_PER_ROW = 10;
    private static final int MAX_ROWS_DISPLAYED = 3;

    public DimensionalTimeClockGuideMainScreen() {
        this.imageWidth = 256;
        this.imageHeight = 256;
        this.TEXTURE = new ResourceLocation("timemercenaries", "textures/gui/dimensional_time_clock_screen.png");
        mapTypeToScreenClass.put(screenType, ((Object)((Object)this)).getClass());
        previousSection = "None";
    }

    protected void m_7856_() {
        this.commonInit(false);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)ButtonHandler.Back, ButtonHandler::handleBackButton).m_252987_(this.leftPos + 8, this.topPos + 8, 40, 20).m_253136_());
        gettingStartedSectionButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ButtonHandler.GettingStarted, ButtonHandler::handleChangeSection).m_252987_(this.leftPos + 8, this.topPos + 30, 80, 20).m_253136_());
        mercenariesSectionButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ButtonHandler.Mercenaries, ButtonHandler::handleChangeSection).m_252987_(this.leftPos + 88, this.topPos + 30, 80, 20).m_253136_());
        modulesSectionButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ButtonHandler.Modules, ButtonHandler::handleChangeSection).m_252987_(this.leftPos + 168, this.topPos + 30, 80, 20).m_253136_());
        previousMercenaryButton = Button.m_253074_((Component)ButtonHandler.Previous, ButtonHandler::previousMercenaryIndex).m_252987_(this.leftPos + 8, this.topPos + 60, 80, 20).m_253136_();
        nextMercenaryButton = Button.m_253074_((Component)ButtonHandler.Next, ButtonHandler::nextMercenaryIndex).m_252987_(this.leftPos + 168, this.topPos + 60, 80, 20).m_253136_();
        if (currentRecruitIndex == 0) {
            DimensionalTimeClockGuideMainScreen.previousMercenaryButton.f_93623_ = false;
        } else if (currentRecruitIndex == mercenariesData.length - 1) {
            DimensionalTimeClockGuideMainScreen.nextMercenaryButton.f_93623_ = false;
        }
        previousInfoButton = Button.m_253074_((Component)Component.m_237113_((String)"<"), btn -> this.switchInfoPanel(-1)).m_252987_(this.leftPos + 45, this.topPos + 160, 10, 10).m_253136_();
        nextInfoButton = Button.m_253074_((Component)Component.m_237113_((String)">"), btn -> this.switchInfoPanel(1)).m_252987_(this.leftPos + 55, this.topPos + 160, 10, 10).m_253136_();
        scrollUpButton = Button.m_253074_((Component)Component.m_237113_((String)"^"), btn -> this.scrollItems(-1)).m_252987_(this.leftPos + 3, this.topPos + 200, 10, 10).m_253136_();
        scrollDownButton = Button.m_253074_((Component)Component.m_237113_((String)"v"), btn -> this.scrollItems(1)).m_252987_(this.leftPos + 3, this.topPos + 210, 10, 10).m_253136_();
    }

    private void switchInfoPanel(int direction) {
        if ((currentMercenaryInfoPanelIndex += direction) < 0) {
            currentMercenaryInfoPanelIndex = MERCENARY_INFO_PANELS.length - 1;
        } else if (currentMercenaryInfoPanelIndex >= MERCENARY_INFO_PANELS.length) {
            currentMercenaryInfoPanelIndex = 0;
        }
        itemScrollOffset = 0;
        update.setDirty();
    }

    public void renderGettingStartedSection(@NotNull GuiGraphics graphics) {
        graphics.m_280137_(this.f_96547_, "Welcome to the Guide section of this mod.", this.leftPos + this.imageWidth / 2, this.topPos + 70, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "The Dimensional Time Clock item is tied to your", this.leftPos + 4, this.topPos + 85, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "player globally, if you lose it your progress is", this.leftPos + 4, this.topPos + 95, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "still saved.", this.leftPos + 4, this.topPos + 105, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Once you recruit a mercenary you have to send", this.leftPos + 4, this.topPos + 120, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "it on a mission or skip to recruit a new one.", this.leftPos + 4, this.topPos + 130, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "You cannot go back to the recruit screen to see", this.leftPos + 4, this.topPos + 145, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "other mercenaries missions, you need the", this.leftPos + 4, this.topPos + 155, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Scouting Module for this.", this.leftPos + 4, this.topPos + 165, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Modules are permanent upgrades to your clock,", this.leftPos + 4, this.topPos + 180, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "those are also saved if you lose the item.", this.leftPos + 4, this.topPos + 190, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "Click on the Modules section to see what is", this.leftPos + 4, this.topPos + 205, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "available for your Dimensional Time Clock.", this.leftPos + 4, this.topPos + 215, 0xFFFFFF);
    }

    public void renderMercenariesStatisticsSubSection(@NotNull GuiGraphics graphics) {
        StatisticsData stats = DimensionalTimeClockGuideMainScreen.mercenariesData[DimensionalTimeClockGuideMainScreen.currentRecruitIndex].statisticsData;
        int leftCol = this.leftPos + 10;
        int rightCol = this.leftPos + 130;
        int y = this.topPos + 148;
        graphics.m_280488_(this.f_96547_, MERCENARY_INFO_PANELS[0], leftCol + 65, y += 12, 0xFFFFFF);
        if (DimensionalTimeClockGuideMainScreen.mercenariesData[DimensionalTimeClockGuideMainScreen.currentRecruitIndex].name.equals("Vael")) {
            graphics.m_280488_(this.f_96547_, "Shop", leftCol, y += 12, 0xFFFF55);
            graphics.m_280488_(this.f_96547_, "Coins: " + stats.totalCoins, leftCol + 5, y += 12, 0x55FF55);
            graphics.m_280488_(this.f_96547_, "Common Items: " + stats.commonItems, leftCol + 5, y += 12, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "Uncommon Items: " + stats.uncommonItems, leftCol + 5, y += 12, 0x55FF55);
            graphics.m_280488_(this.f_96547_, "Rare Items: " + stats.rareItems, leftCol + 5, y += 12, 0x5555FF);
            graphics.m_280488_(this.f_96547_, "Epic Items: " + stats.epicItems, leftCol + 5, y += 12, 0xFF55FF);
            graphics.m_280488_(this.f_96547_, "Legendary Items: " + stats.legendaryItems, leftCol + 5, y + 12, 16755712);
            y = this.topPos + 160;
            graphics.m_280488_(this.f_96547_, "Quests", rightCol, y += 12, 0xFFFF55);
            graphics.m_280488_(this.f_96547_, "Quests: " + stats.totalQuests, rightCol + 5, y += 12, 0xFF5555);
            graphics.m_280488_(this.f_96547_, "Success: " + stats.questsSuccess, rightCol + 5, y + 12, 0xFF5555);
        } else {
            graphics.m_280488_(this.f_96547_, "Missions", leftCol, y += 12, 0xFFFF55);
            graphics.m_280488_(this.f_96547_, "Common: " + stats.commonSuccess + " / " + stats.commonStarted + " (" + stats.getSuccessRate(stats.commonStarted, stats.commonSuccess) + ")", leftCol + 5, y += 12, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "Uncommon: " + stats.uncommonSuccess + " / " + stats.uncommonStarted + " (" + stats.getSuccessRate(stats.uncommonStarted, stats.uncommonSuccess) + ")", leftCol + 5, y += 12, 0x55FF55);
            graphics.m_280488_(this.f_96547_, "Rare: " + stats.rareSuccess + " / " + stats.rareStarted + " (" + stats.getSuccessRate(stats.rareStarted, stats.rareSuccess) + ")", leftCol + 5, y += 12, 0x5555FF);
            graphics.m_280488_(this.f_96547_, "Epic: " + stats.epicSuccess + " / " + stats.epicStarted + " (" + stats.getSuccessRate(stats.epicStarted, stats.epicSuccess) + ")", leftCol + 5, y += 12, 0xFF55FF);
            graphics.m_280488_(this.f_96547_, "Legendary: " + stats.legendarySuccess + " / " + stats.legendaryStarted + " (" + stats.getSuccessRate(stats.legendaryStarted, stats.legendarySuccess) + ")", leftCol + 5, y += 12, 16755712);
            graphics.m_280488_(this.f_96547_, "Total: " + stats.getTotalMissionsSuccess() + " / " + stats.getTotalMissionsStarted() + " (" + stats.getSuccessRate(stats.getTotalMissionsStarted(), stats.getTotalMissionsSuccess()) + ")", leftCol + 5, y + 12, 0xFFFFFF);
            y = this.topPos + 160;
            graphics.m_280488_(this.f_96547_, "General", rightCol, y += 12, 0xFFFF55);
            graphics.m_280488_(this.f_96547_, "Missions Failed: " + stats.fails, rightCol + 5, y += 12, 0xFF5555);
            graphics.m_280488_(this.f_96547_, "Deaths: " + stats.deaths, rightCol + 5, y += 12, 0xFF5555);
            graphics.m_280488_(this.f_96547_, "Damage Taken: " + stats.damageTaken, rightCol + 5, y += 12, 0xFFFFFF);
            graphics.m_280488_(this.f_96547_, "Bribes Used: " + stats.bribes, rightCol + 5, y += 12, 0x55FF55);
            graphics.m_280488_(this.f_96547_, "Totems Used: " + stats.totemsUsed, rightCol + 5, y + 12, 0x55FF55);
        }
    }

    public void renderMercenariesRewardsSubSection(@NotNull GuiGraphics graphics) {
        int xStart = this.leftPos + 8;
        int yStart = this.topPos + 148;
        int offset = 22;
        int y = yStart;
        graphics.m_280488_(this.f_96547_, MERCENARY_INFO_PANELS[1], xStart + 65, y += 12, 0xFFFFFF);
        if (Utils.unformatString(DimensionalTimeClockGuideMainScreen.mercenariesData[DimensionalTimeClockGuideMainScreen.currentRecruitIndex].name).equals("chaos")) {
            graphics.m_280488_(this.f_96547_, "EVERYTHING", xStart + 65, y + 50, 0xFF0000);
        } else {
            int itemsToSkip = itemScrollOffset * 10;
            int itemsToRender = 30;
            int itemsRendered = 0;
            for (MissionItem item : DimensionalTimeClockGuideMainScreen.mercenariesData[DimensionalTimeClockGuideMainScreen.currentRecruitIndex].statisticsData.allRewardItems) {
                if (itemsToSkip > 0) {
                    --itemsToSkip;
                    continue;
                }
                if (itemsRendered >= itemsToRender) {
                    return;
                }
                int row = itemsRendered / 10;
                int col = itemsRendered % 10;
                int x = xStart + 12 + col * offset;
                y = yStart + offset + 4 + row * offset;
                graphics.m_280480_(item.itemStack, x, y);
                ++itemsRendered;
            }
        }
    }

    public void renderMercenariesSection(@NotNull GuiGraphics graphics) {
        this.renderMercenaryInfo(graphics, 3, 85, 1, mercenariesData[currentRecruitIndex], this.screenData);
        graphics.m_280137_(this.f_96547_, "%d/%d".formatted(currentRecruitIndex + 1, mercenariesData.length), this.leftPos + 126, this.topPos + 65, 0xFFFFFF);
        if (currentMercenaryInfoPanelIndex == 0) {
            this.renderMercenariesStatisticsSubSection(graphics);
        } else if (currentMercenaryInfoPanelIndex == 1) {
            this.renderMercenariesRewardsSubSection(graphics);
        }
    }

    public void renderModulesSection(@NotNull GuiGraphics graphics) {
        this.renderCustomTextureProps(graphics, GRAY_BACKGROUND, this.leftPos + 5, this.topPos + 59, 0, 243, 48);
        this.renderCustomTextureProps(graphics, GREEN_BACKGROUND, this.leftPos + 5, this.topPos + 107, 0, 243, 48);
        this.renderCustomTextureProps(graphics, BLUE_BACKGROUND, this.leftPos + 5, this.topPos + 155, 0, 243, 48);
        this.renderCustomTextureProps(graphics, RED_BACKGROUND, this.leftPos + 5, this.topPos + 203, 0, 243, 48);
        for (int i = 0; i < DimensionalTimeClockGuideMainScreen.moduleData.moduleUnlocks.length; ++i) {
            if (DimensionalTimeClockGuideMainScreen.moduleData.moduleUnlocks[i]) {
                this.renderItemWithBackground(graphics, DimensionalTimeClockGuideMainScreen.moduleData.textures[i], UNLOCKED_BACKGROUND, this.leftPos + 10 + DimensionalTimeClockGuideMainScreen.moduleData.columns[i] * 24, this.topPos + 64 + DimensionalTimeClockGuideMainScreen.moduleData.rows[i] * 24);
            } else {
                this.renderItem(graphics, DimensionalTimeClockGuideMainScreen.moduleData.textures[i], this.leftPos + 10 + DimensionalTimeClockGuideMainScreen.moduleData.columns[i] * 24, this.topPos + 64 + DimensionalTimeClockGuideMainScreen.moduleData.rows[i] * 24);
            }
            for (int indexReq : DimensionalTimeClockGuideMainScreen.moduleData.requirementLinesIndex[i]) {
                int startX = this.leftPos + 10 + DimensionalTimeClockGuideMainScreen.moduleData.columns[i] * 24 + 7;
                int endX = this.leftPos + 10 + DimensionalTimeClockGuideMainScreen.moduleData.columns[indexReq] * 24 + 7;
                int startY = this.topPos + 64 + DimensionalTimeClockGuideMainScreen.moduleData.rows[indexReq] * 24 + 18;
                int endY = this.topPos + 64 + DimensionalTimeClockGuideMainScreen.moduleData.rows[i] * 24 - 2;
                int width = Math.abs(endX - startX);
                int height = endY - startY;
                if (startX == endX) {
                    this.renderCustomTextureProps(graphics, BLACK_BACKGROUND, startX, startY, 300, 2, height);
                    continue;
                }
                this.renderCustomTextureProps(graphics, BLACK_BACKGROUND, startX, startY + height / 2, 300, 2, height / 2);
                this.renderCustomTextureProps(graphics, BLACK_BACKGROUND, endX, startY, 300, 2, height / 2);
                this.renderCustomTextureProps(graphics, BLACK_BACKGROUND, Math.min(startX, endX), startY + height / 2, 300, width, 2);
            }
        }
    }

    public void updateSectionsRender() {
        DimensionalTimeClockGuideMainScreen.gettingStartedSectionButton.f_93623_ = !section.equals("GettingStarted");
        DimensionalTimeClockGuideMainScreen.mercenariesSectionButton.f_93623_ = !section.equals("Mercenaries");
        DimensionalTimeClockGuideMainScreen.modulesSectionButton.f_93623_ = !section.equals("Modules");
        this.deleteAllTemporaryWidgets();
        if (previousSection.equals("Mercenaries")) {
            this.removeWidget(previousMercenaryButton);
            this.removeWidget(nextMercenaryButton);
            this.removeWidget(previousInfoButton);
            this.removeWidget(nextInfoButton);
            this.removeWidget(scrollUpButton);
            this.removeWidget(scrollDownButton);
        }
        if (section.equals("Mercenaries")) {
            this.m_142416_((GuiEventListener)previousMercenaryButton);
            this.m_142416_((GuiEventListener)nextMercenaryButton);
            this.m_142416_((GuiEventListener)previousInfoButton);
            this.m_142416_((GuiEventListener)nextInfoButton);
            if (currentMercenaryInfoPanelIndex == 1) {
                int totalItems = DimensionalTimeClockGuideMainScreen.mercenariesData[DimensionalTimeClockGuideMainScreen.currentRecruitIndex].statisticsData.allRewardItems.size();
                int totalRows = (int)Math.ceil((double)totalItems / 10.0);
                if (totalRows > 3) {
                    this.m_142416_((GuiEventListener)scrollUpButton);
                    this.m_142416_((GuiEventListener)scrollDownButton);
                    DimensionalTimeClockGuideMainScreen.scrollUpButton.f_93623_ = itemScrollOffset > 0;
                    DimensionalTimeClockGuideMainScreen.scrollDownButton.f_93623_ = itemScrollOffset < totalRows - 3;
                }
                int itemsToSkip = itemScrollOffset * 10;
                int itemsToRender = 30;
                int itemsRendered = 0;
                int xStart = this.leftPos + 8;
                int yStart = this.topPos + 172;
                int offset = 22;
                for (int i = 0; i < DimensionalTimeClockGuideMainScreen.mercenariesData[DimensionalTimeClockGuideMainScreen.currentRecruitIndex].statisticsData.allRewardItemsButtons.length && itemsRendered < itemsToRender; ++i) {
                    if (itemsToSkip > 0) {
                        --itemsToSkip;
                        continue;
                    }
                    int row = itemsRendered / 10;
                    int col = itemsRendered % 10;
                    int x = xStart + 10 + col * offset;
                    int y = yStart + row * offset;
                    DimensionalTimeClockGuideMainScreen.mercenariesData[DimensionalTimeClockGuideMainScreen.currentRecruitIndex].statisticsData.allRewardItemsButtons[i].m_264152_(x, y);
                    this.renderWidget((AbstractWidget)DimensionalTimeClockGuideMainScreen.mercenariesData[DimensionalTimeClockGuideMainScreen.currentRecruitIndex].statisticsData.allRewardItemsButtons[i]);
                    ++itemsRendered;
                }
            }
        }
        if (section.equals("Modules")) {
            for (int i = 0; i < DimensionalTimeClockGuideMainScreen.moduleData.buttonsModule.length; ++i) {
                DimensionalTimeClockGuideMainScreen.moduleData.buttonsModule[i].m_264152_(this.leftPos + 8 + DimensionalTimeClockGuideMainScreen.moduleData.columns[i] * 24, this.topPos + 62 + DimensionalTimeClockGuideMainScreen.moduleData.rows[i] * 24);
                this.renderWidget((AbstractWidget)DimensionalTimeClockGuideMainScreen.moduleData.buttonsModule[i]);
            }
        }
        previousSection = section;
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.commonRender(graphics);
        if (!section.equals(previousSection) || update.shouldUpdate(0)) {
            this.updateSectionsRender();
        }
        switch (section) {
            case "GettingStarted": {
                this.renderGettingStartedSection(graphics);
                break;
            }
            case "Mercenaries": {
                this.renderMercenariesSection(graphics);
                break;
            }
            case "Modules": {
                this.renderModulesSection(graphics);
            }
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private void scrollItems(int direction) {
        int maxScroll = 0;
        if (mercenariesData != null && currentRecruitIndex < mercenariesData.length) {
            int totalItems = DimensionalTimeClockGuideMainScreen.mercenariesData[DimensionalTimeClockGuideMainScreen.currentRecruitIndex].statisticsData.allRewardItems.size();
            int totalRows = (int)Math.ceil((double)totalItems / 10.0);
            maxScroll = Math.max(0, totalRows - 3);
        }
        itemScrollOffset = Mth.m_14045_((int)(itemScrollOffset + direction), (int)0, (int)maxScroll);
        update.setDirty();
    }

    static {
        currentRecruitIndex = 0;
        for (int[] integers : moduleGrid = new int[8][10]) {
            Arrays.fill(integers, -1);
        }
        currentMercenaryInfoPanelIndex = 0;
        MERCENARY_INFO_PANELS = new String[]{"Statistics", "Possible Rewards"};
        itemScrollOffset = 0;
    }
}

