/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.screen.dtc;

import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.client.data.MercenaryData;
import io.github.sluggly.timemercenaries.client.data.ModuleData;
import io.github.sluggly.timemercenaries.client.data.QuestData;
import io.github.sluggly.timemercenaries.client.data.ShopData;
import io.github.sluggly.timemercenaries.client.handler.ButtonHandler;
import io.github.sluggly.timemercenaries.client.screen.dtc.AbstractDimensionalTimeClockScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class DimensionalTimeClockQuestScreen
extends AbstractDimensionalTimeClockScreen {
    public static final String screenType = "RecruitScreen";
    public static MercenaryData mercenaryData;
    public static ModuleData moduleData;
    public static ShopData shopData;
    public static QuestData[] questsData;
    Button skipQuestsButton;
    Button abandonQuestButton;

    public DimensionalTimeClockQuestScreen() {
        this.imageWidth = 256;
        this.imageHeight = 256;
        this.TEXTURE = new ResourceLocation("timemercenaries", "textures/gui/dimensional_time_clock_screen.png");
        mapTypeToScreenClass.put(screenType, ((Object)((Object)this)).getClass());
    }

    protected void m_7856_() {
        this.commonInit(true);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)ButtonHandler.Back, ButtonHandler::handleOpenRecruitScreen).m_252987_(this.leftPos + 211, this.topPos + 10, 40, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)ButtonHandler.Skip, ButtonHandler::handleShopSkipButton).m_252987_(this.leftPos + 211, this.topPos + 35, 40, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Skipping the shop will bring you back to the Recruit Screen with new mercenaries to hire after waiting 150 seconds."))).m_253136_());
        this.skipQuestsButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ButtonHandler.SkipQuests, ButtonHandler::handleShopSkipButton).m_252987_(this.leftPos + 171, this.topPos + 60, 80, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Skipping the Quests will bring you back to the Recruit Screen with new mercenaries to hire after waiting 150 seconds. New Quests will be available next time you meet Vael."))).m_253136_());
        this.abandonQuestButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ButtonHandler.AbandonQuest, ButtonHandler::handleShopAbandonQuestButton).m_252987_(this.leftPos + 171, this.topPos + 60, 80, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Abandoning your current Quest will bring you back to the Recruit Screen with new mercenaries to hire after waiting 150 seconds. New Quests will be available next time you meet Vael."))).m_253136_());
        if (Admin.CLIENT_IS_ADMIN_MODE_ACTIVATED) {
            this.m_142416_((GuiEventListener)new AbstractDimensionalTimeClockScreen.AdminButton(1, mercenaryData, this.leftPos + 256, this.topPos + 10, 50, 20, (Component)Component.m_237113_((String)"REROLL 1"), ButtonHandler::handleAdminRerollQuest, null));
            this.m_142416_((GuiEventListener)new AbstractDimensionalTimeClockScreen.AdminButton(2, mercenaryData, this.leftPos + 256, this.topPos + 30, 50, 20, (Component)Component.m_237113_((String)"REROLL 2"), ButtonHandler::handleAdminRerollQuest, null));
            this.m_142416_((GuiEventListener)new AbstractDimensionalTimeClockScreen.AdminButton(3, mercenaryData, this.leftPos + 256, this.topPos + 50, 50, 20, (Component)Component.m_237113_((String)"REROLL 3"), ButtonHandler::handleAdminRerollQuest, null));
            this.m_142416_((GuiEventListener)new AbstractDimensionalTimeClockScreen.AdminButton(mercenaryData, this.leftPos + 256, this.topPos + 70, 50, 20, (Component)Component.m_237113_((String)"+1 PROGRESS"), ButtonHandler::handleAdminAddQuestProgress, null));
        }
    }

    public void renderButtons() {
        boolean hasPlayerAcceptedQuest = DimensionalTimeClockQuestScreen.questsData[0].isChosenQuest || DimensionalTimeClockQuestScreen.questsData[1].isChosenQuest || DimensionalTimeClockQuestScreen.questsData[2].isChosenQuest;
        this.skipQuestsButton.f_93624_ = !hasPlayerAcceptedQuest;
        this.skipQuestsButton.f_93623_ = !hasPlayerAcceptedQuest;
        this.abandonQuestButton.f_93623_ = hasPlayerAcceptedQuest;
        this.abandonQuestButton.f_93624_ = hasPlayerAcceptedQuest;
    }

    public void renderQuestInfo(@NotNull GuiGraphics graphics, int x, int y, int updateIndex, QuestData questData) {
        graphics.m_280163_(MISSION_INFO_TEXTURE, this.leftPos + x, this.topPos + y, 0.0f, 0.0f, 81, 144, 256, 256);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)"Objective:").m_130940_(ChatFormatting.GOLD), this.leftPos + x + 2, this.topPos + y + 2, 0xFFFFFF, false);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237113_((String)questData.requirementDescription), this.leftPos + x + 2, this.topPos + y + 12, 73, 0xFFFFFF);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)"Reward:").m_130940_(ChatFormatting.GOLD), this.leftPos + x + 2, this.topPos + y + 60, 0xFFFFFF, false);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237113_((String)questData.rewardDescription), this.leftPos + x + 2, this.topPos + y + 70, 73, 0xFFFFFF);
        if (questData.isChosenQuest && !questData.shouldRenderCompleteQuestButton) {
            String progressText = "%d/%d".formatted(questData.progress, questData.requirementNumber);
            graphics.m_280056_(this.f_96547_, "Done: " + progressText, this.leftPos + x + 2, this.topPos + y + 120, ChatFormatting.AQUA.m_126665_().intValue(), false);
        }
        if (update.shouldUpdate(updateIndex)) {
            if (questData.shouldRenderAcceptQuestButton) {
                questData.buttonAcceptQuest.m_264152_(this.leftPos + x + 15, this.topPos + y + 120);
                questData.buttonAcceptQuest.f_93623_ = true;
                this.renderWidget((AbstractWidget)questData.buttonAcceptQuest);
            }
            if (questData.shouldRenderCompleteQuestButton) {
                questData.buttonCompleteQuest.m_264152_(this.leftPos + x + 15, this.topPos + y + 120);
                questData.buttonCompleteQuest.f_93623_ = true;
                this.renderWidget((AbstractWidget)questData.buttonCompleteQuest);
            }
            update.setUpdated(updateIndex);
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.commonRender(graphics);
        this.renderMercenaryInfo(graphics, 3, 34, 0, mercenaryData, this.screenData);
        this.renderButtons();
        this.renderQuestInfo(graphics, 3, 108, 1, questsData[0]);
        this.renderQuestInfo(graphics, 87, 108, 2, questsData[1]);
        this.renderQuestInfo(graphics, 171, 108, 3, questsData[2]);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }
}

