/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.screen.dtc;

import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.client.data.MercenaryData;
import io.github.sluggly.timemercenaries.client.data.ModuleData;
import io.github.sluggly.timemercenaries.client.data.ShopData;
import io.github.sluggly.timemercenaries.client.handler.ButtonHandler;
import io.github.sluggly.timemercenaries.client.screen.dtc.AbstractDimensionalTimeClockScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class DimensionalTimeClockShopScreen
extends AbstractDimensionalTimeClockScreen {
    public static final String screenType = "RecruitScreen";
    public static MercenaryData mercenaryData;
    public static ModuleData moduleData;
    public static ShopData shopData;

    public DimensionalTimeClockShopScreen() {
        this.imageWidth = 256;
        this.imageHeight = 256;
        this.TEXTURE = new ResourceLocation("timemercenaries", "textures/gui/dimensional_time_clock_screen.png");
        mapTypeToScreenClass.put(screenType, ((Object)((Object)this)).getClass());
    }

    protected void m_7856_() {
        this.commonInit(true);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)ButtonHandler.Back, ButtonHandler::handleOpenRecruitScreen).m_252987_(this.leftPos + 208, this.topPos + 8, 40, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)ButtonHandler.Skip, ButtonHandler::handleShopSkipButton).m_252987_(this.leftPos + 208, this.topPos + 120, 40, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Skipping the shop will bring you back to the Recruit Screen with new mercenaries to hire after waiting 150 seconds."))).m_253136_());
        if (Admin.CLIENT_IS_ADMIN_MODE_ACTIVATED) {
            this.m_142416_((GuiEventListener)new AbstractDimensionalTimeClockScreen.AdminButton(mercenaryData, this.leftPos + 256, this.topPos + 10, 80, 20, (Component)Component.m_237113_((String)"ADMIN LEVEL UP"), ButtonHandler::handleAdminLevelUpMercenary, null));
            this.m_142416_((GuiEventListener)new AbstractDimensionalTimeClockScreen.AdminButton(mercenaryData, this.leftPos + 256, this.topPos + 30, 50, 20, (Component)Component.m_237113_((String)"RESET COINS"), ButtonHandler::handleAdminResetCoins, null));
            this.m_142416_((GuiEventListener)new AbstractDimensionalTimeClockScreen.AdminButton(mercenaryData, this.leftPos + 256, this.topPos + 50, 50, 20, (Component)Component.m_237113_((String)"+50 COINS"), ButtonHandler::handleAdminAddCoins, null));
            this.m_142416_((GuiEventListener)new AbstractDimensionalTimeClockScreen.AdminButton(mercenaryData, this.leftPos + 256, this.topPos + 70, 50, 20, (Component)Component.m_237113_((String)"REROLL SHOP"), ButtonHandler::handleAdminRerollShop, null));
        }
    }

    public void renderShopItems(@NotNull GuiGraphics graphics, int x, int y, int updateIndex, ShopData shopData) {
        int i;
        for (i = 0; i < shopData.shopButtons.length; ++i) {
            if (i < shopData.numberOfItemsToDisplay) {
                if (shopData.shopStatus[i] == 1) {
                    this.renderCustomTexture(graphics, texture_checkmark, this.leftPos + x + i % shopData.itemsPerRow * 46 + 2, this.topPos + y + 46 * (i / shopData.itemsPerRow) + 2);
                } else {
                    this.renderItemAndCount(graphics, shopData.shopItems[i].itemStack, this.leftPos + x + i % shopData.itemsPerRow * 46 + 2, this.topPos + y + 46 * (i / shopData.itemsPerRow) + 2, "%d".formatted(shopData.shopItems[i].number), 0xFFFFFF);
                }
                graphics.m_280488_(this.f_96547_, "%d".formatted(shopData.shopItems[i].price), this.leftPos + x + i % shopData.itemsPerRow * 46, this.topPos + y + 46 * (i / shopData.itemsPerRow) + 25, 0xFFFFFF);
                int textWidth = this.f_96547_.m_92895_("%d".formatted(shopData.shopItems[i].price));
                graphics.m_280163_(COIN, this.leftPos + x + i % shopData.itemsPerRow * 46 + 2 + textWidth, this.topPos + y + 46 * (i / shopData.itemsPerRow) + 25, 0.0f, 0.0f, 9, 9, 9, 9);
                continue;
            }
            this.renderItemAndCount(graphics, null, this.leftPos + x + i % shopData.itemsPerRow * 46 + 2, this.topPos + y + 46 * (i / shopData.itemsPerRow) + 2, "", 0xFFFFFF);
        }
        if (update.shouldUpdate(updateIndex)) {
            for (i = 0; i < shopData.shopButtons.length; ++i) {
                shopData.shopButtons[i].m_264152_(this.leftPos + x + i % shopData.itemsPerRow * 46, this.topPos + y + 46 * (i / shopData.itemsPerRow));
                this.renderWidget((AbstractWidget)shopData.shopButtons[i]);
            }
            update.setUpdated(updateIndex);
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.commonRender(graphics);
        this.renderMercenaryInfo(graphics, 3, 34, 0, mercenaryData, this.screenData);
        int textWidth = this.f_96547_.m_92895_("You have %d".formatted(DimensionalTimeClockShopScreen.shopData.playerCoins));
        graphics.m_280163_(COIN, this.leftPos + 28 + textWidth, this.topPos + 130, 0.0f, 0.0f, 9, 9, 9, 9);
        graphics.m_280488_(this.f_96547_, "You have %d".formatted(DimensionalTimeClockShopScreen.shopData.playerCoins), this.leftPos + 26, this.topPos + 130, 0xFFFFFF);
        this.renderShopItems(graphics, 26, 150, 1, shopData);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }
}

