/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.screen.dtc;

import io.github.sluggly.timemercenaries.client.data.MercenaryData;
import io.github.sluggly.timemercenaries.client.data.TraitData;
import io.github.sluggly.timemercenaries.client.handler.ButtonHandler;
import io.github.sluggly.timemercenaries.client.screen.dtc.AbstractDimensionalTimeClockScreen;
import io.github.sluggly.timemercenaries.mercenary.Trait;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class DimensionalTimeClockTraitScreen
extends AbstractDimensionalTimeClockScreen {
    public static final String screenType = "TraitScreen";
    public static MercenaryData mercenaryData;
    public static TraitData traitData;
    public static Button buttonResetTraits;
    public static boolean canReset;
    public static String resetItemTooltip;
    public static ItemStack resetItemTexture;
    public static int resetItemNumber;

    public DimensionalTimeClockTraitScreen() {
        this.imageWidth = 256;
        this.imageHeight = 256;
        this.TEXTURE = new ResourceLocation("timemercenaries", "textures/gui/dimensional_time_clock_end_mission_screen.png");
        mapTypeToScreenClass.put(screenType, ((Object)((Object)this)).getClass());
    }

    protected void m_7856_() {
        this.commonInit(true);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)ButtonHandler.Back, ButtonHandler::handleBackButton).m_252987_(this.leftPos + 88, this.topPos + 226, 80, 20).m_253136_());
        Button buttonResetTraitsDescription = (Button)this.m_169394_((Renderable)Button.m_253074_((Component)ButtonHandler.ResetTraits, ButtonHandler::doNothing).m_252987_(this.leftPos + 170, this.topPos + 67, 65, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)"This will reset all manually allocated traits AND all randomly gained traits thanks to the scavenge trait."))).m_253136_());
        buttonResetTraitsDescription.f_93623_ = false;
        buttonResetTraits = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ButtonHandler.Empty, ButtonHandler::handleResetTraitsButton).m_252987_(this.leftPos + 233, this.topPos + 67, 20, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237113_((String)resetItemTooltip))).m_253136_());
        DimensionalTimeClockTraitScreen.buttonResetTraits.f_93623_ = canReset;
    }

    public void updateTraitButtonsRender() {
        this.deleteAllTemporaryWidgets();
        int i = 0;
        for (Trait trait : Trait.getTraits()) {
            TraitData.TraitButton traitButton = DimensionalTimeClockTraitScreen.traitData.mapTraitButton.get(trait.name);
            traitButton.m_264152_(this.leftPos + 10 + i % 8 * 30, this.topPos + 115 + i / 8 * 30);
            this.renderWidget((AbstractWidget)traitButton);
            ++i;
        }
        DimensionalTimeClockTraitScreen.buttonResetTraits.f_93623_ = canReset;
        buttonResetTraits.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)resetItemTooltip)));
    }

    public void renderTraitButton(@NotNull GuiGraphics graphics) {
        int i = 0;
        for (Trait trait : Trait.getTraits()) {
            this.renderItemAndCount(graphics, trait.itemTexture.m_7968_(), this.leftPos + 12 + i % 8 * 30, this.topPos + 117 + i / 8 * 30, "%d".formatted(mercenaryData.getTraitLevel(trait.name)), 0xFFFFFF);
            ++i;
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.commonRender(graphics);
        if (update.shouldUpdate(0)) {
            this.updateTraitButtonsRender();
        }
        this.renderMercenaryInfo(graphics, 3, 34, 1, mercenaryData, this.screenData);
        graphics.m_280488_(this.f_96547_, "Traits Available:", this.leftPos + 170, this.topPos + 47, 0xFFFFFF);
        graphics.m_280488_(this.f_96547_, "%d".formatted(DimensionalTimeClockTraitScreen.mercenaryData.numberTraitAvailable), this.leftPos + 210, this.topPos + 57, 0xFFFFFF);
        this.renderTraitButton(graphics);
        this.renderItemAndCount(graphics, resetItemTexture, this.leftPos + 235, this.topPos + 69, "%d".formatted(resetItemNumber), 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }
}

