/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.screen.dtc;

import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.client.data.LoreData;
import io.github.sluggly.timemercenaries.client.handler.ButtonHandler;
import io.github.sluggly.timemercenaries.client.screen.dtc.AbstractDimensionalTimeClockScreen;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DimensionalTimeClockTutorialScreen
extends AbstractDimensionalTimeClockScreen {
    public static final String screenType = "TutorialScreen";
    public static LoreData loreData;
    private long countdownStartTime = -1L;
    private Button renderedButton;

    public DimensionalTimeClockTutorialScreen() {
        this.imageWidth = 256;
        this.imageHeight = 256;
        this.TEXTURE = new ResourceLocation("timemercenaries", "textures/gui/dimensional_time_clock_screen.png");
        mapTypeToScreenClass.put(screenType, ((Object)((Object)this)).getClass());
    }

    public void initAdminButtons() {
        if (Admin.CLIENT_IS_ADMIN_MODE_ACTIVATED) {
            this.adminButtons.clear();
            this.adminButtons.add((AbstractDimensionalTimeClockScreen.AdminButton)this.m_142416_((GuiEventListener)new AbstractDimensionalTimeClockScreen.AdminButton(this.leftPos + 256, this.topPos + 10, 50, 20, (Component)Component.m_237113_((String)"SKIP TUTORIAL"), ButtonHandler::handleAdminSkipTutorial, null)));
            this.adminButtons.add((AbstractDimensionalTimeClockScreen.AdminButton)this.m_142416_((GuiEventListener)new AbstractDimensionalTimeClockScreen.AdminButton(this.leftPos + 256, this.topPos + 30, 50, 20, (Component)Component.m_237113_((String)"NEXT STEP"), ButtonHandler::handleAdminNextLoreStep, null)));
            this.adminButtons.add((AbstractDimensionalTimeClockScreen.AdminButton)this.m_142416_((GuiEventListener)new AbstractDimensionalTimeClockScreen.AdminButton(1, this.leftPos + 256, this.topPos + 50, 50, 20, (Component)Component.m_237113_((String)"+ COUNT"), ButtonHandler::handleAdminChangeLoreCount, null)));
            this.adminButtons.add((AbstractDimensionalTimeClockScreen.AdminButton)this.m_142416_((GuiEventListener)new AbstractDimensionalTimeClockScreen.AdminButton(-1, this.leftPos + 256 + 50, this.topPos + 50, 50, 20, (Component)Component.m_237113_((String)"- COUNT"), ButtonHandler::handleAdminChangeLoreCount, null)));
        }
    }

    protected void m_7856_() {
        this.commonInit(false);
        this.updateRenderButtons(0);
        this.initAdminButtons();
    }

    public void m_86600_() {
        super.m_86600_();
        if (loreData == null) {
            return;
        }
        assert (this.f_96541_ != null && this.f_96541_.f_91074_ != null);
        if (DimensionalTimeClockTutorialScreen.loreData.progress == 0.1f) {
            boolean conditionsMet = this.f_96541_.f_91074_.m_20186_() >= 200.0 && this.f_96541_.f_91074_.m_9236_().m_46472_() == Level.f_46428_;
            this.updateCountdown("gui.timemercenaries.tutorial.altitude.button.success", "gui.timemercenaries.tutorial.altitude.button.fail", 5, conditionsMet);
        } else if (DimensionalTimeClockTutorialScreen.loreData.progress == 0.2f) {
            boolean conditionsMet = this.f_96541_.f_91074_.m_20186_() < 0.0 && this.f_96541_.f_91074_.m_9236_().m_46472_() == Level.f_46428_;
            this.updateCountdown("gui.timemercenaries.tutorial.resonance.button.success", "gui.timemercenaries.tutorial.resonance.button.fail", 5, conditionsMet);
        } else if (DimensionalTimeClockTutorialScreen.loreData.progress == 0.3f) {
            boolean conditionsMet = this.f_96541_.f_91074_.m_5842_();
            this.updateCountdown("gui.timemercenaries.tutorial.quench.button.success", "gui.timemercenaries.tutorial.quench.button.fail", 3, conditionsMet);
        }
    }

    private void updateCountdown(String successMessage, String failMessage, int duration, boolean conditionsMet) {
        if (conditionsMet) {
            long elapsedMillis;
            int remainingSeconds;
            if (this.countdownStartTime == -1L) {
                this.countdownStartTime = System.currentTimeMillis();
            }
            if ((remainingSeconds = duration - (int)((elapsedMillis = System.currentTimeMillis() - this.countdownStartTime) / 1000L)) > 0) {
                DimensionalTimeClockTutorialScreen.loreData.completeStepButton.f_93623_ = false;
                DimensionalTimeClockTutorialScreen.loreData.completeStepButton.m_93666_((Component)Component.m_237113_((String)(remainingSeconds + "...")));
            } else {
                DimensionalTimeClockTutorialScreen.loreData.completeStepButton.f_93623_ = true;
                DimensionalTimeClockTutorialScreen.loreData.completeStepButton.m_93666_((Component)Component.m_237113_((String)successMessage));
            }
        } else {
            this.countdownStartTime = -1L;
            DimensionalTimeClockTutorialScreen.loreData.completeStepButton.f_93623_ = false;
            DimensionalTimeClockTutorialScreen.loreData.completeStepButton.m_93666_((Component)Component.m_237113_((String)failMessage));
        }
    }

    public void renderFirstLoreStep(@NotNull GuiGraphics graphics) {
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.timemercenaries.tutorial.powerup.title"), this.leftPos + this.imageWidth / 2, this.topPos + 40, 0xFF5555);
        int textLeft = this.leftPos + 15;
        int textWidth = this.imageWidth - 30;
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.powerup.desc1"), textLeft, this.topPos + 60, textWidth, 0xFFFFFF);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.powerup.desc2"), textLeft, this.topPos + 110, textWidth, 0xFFFFFF);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.powerup.desc3"), textLeft, this.topPos + 160, textWidth, 0xFFFF55);
        this.renderItemAndCount(graphics, Items.f_42451_.m_7968_(), this.leftPos + 112, this.topPos + 200, "10", 0xFFFFFF);
    }

    public void renderSecondLoreStep(@NotNull GuiGraphics graphics) {
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.timemercenaries.tutorial.altitude.title"), this.leftPos + this.imageWidth / 2, this.topPos + 40, 0xFFFF55);
        int textLeft = this.leftPos + 15;
        int textWidth = this.imageWidth - 30;
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.altitude.desc1"), textLeft, this.topPos + 60, textWidth, 0xFFFFFF);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.altitude.desc2"), textLeft, this.topPos + 120, textWidth, 0xFFFFFF);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.altitude.desc3"), textLeft, this.topPos + 170, textWidth, 0x55FFFF);
    }

    public void renderThirdLoreStep(@NotNull GuiGraphics graphics) {
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.timemercenaries.tutorial.resonance.title"), this.leftPos + this.imageWidth / 2, this.topPos + 40, 0xFFFF55);
        int textLeft = this.leftPos + 15;
        int textWidth = this.imageWidth - 30;
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.resonance.desc1"), textLeft, this.topPos + 60, textWidth, 0xFFFFFF);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.resonance.desc2"), textLeft, this.topPos + 120, textWidth, 0xFFFFFF);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.resonance.desc3"), textLeft, this.topPos + 170, textWidth, 0x55FFFF);
    }

    public void renderFourthLoreStep(@NotNull GuiGraphics graphics) {
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.timemercenaries.tutorial.quench.title"), this.leftPos + this.imageWidth / 2, this.topPos + 40, 0xFFFF55);
        int textLeft = this.leftPos + 15;
        int textWidth = this.imageWidth - 30;
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.quench.desc1"), textLeft, this.topPos + 60, textWidth, 0xFFFFFF);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.quench.desc2"), textLeft, this.topPos + 120, textWidth, 0xFFFFFF);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.quench.desc3"), textLeft, this.topPos + 170, textWidth, 0x55FFFF);
    }

    public void renderFifthLoreStep(@NotNull GuiGraphics graphics) {
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.timemercenaries.tutorial.offering.title"), this.leftPos + this.imageWidth / 2, this.topPos + 40, 0xFFFF55);
        int textLeft = this.leftPos + 15;
        int textWidth = this.imageWidth - 30;
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.offering.desc1"), textLeft, this.topPos + 60, textWidth, 0xFFFFFF);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.offering.desc2"), textLeft, this.topPos + 120, textWidth, 0xFFFFFF);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.offering.desc3"), textLeft, this.topPos + 170, textWidth, 0x55FFFF);
        String progressText = DimensionalTimeClockTutorialScreen.loreData.count + " / 3";
        ChatFormatting color = DimensionalTimeClockTutorialScreen.loreData.count >= 3 ? ChatFormatting.GREEN : ChatFormatting.YELLOW;
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.timemercenaries.tutorial.offering.counter"), this.leftPos + this.imageWidth / 2, this.topPos + 200, 0xFFFFFF);
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)progressText).m_130940_(color), this.leftPos + this.imageWidth / 2, this.topPos + 210, 0xFFFFFF);
    }

    public void renderSixthLoreStep(@NotNull GuiGraphics graphics) {
        this.renderDialogPortrait(graphics, 4, 20, 0, loreData);
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.timemercenaries.tutorial.contract.title"), this.leftPos + this.imageWidth / 2, this.topPos + 40, 4367861);
        int textLeft = this.leftPos + 15;
        int textWidth = this.imageWidth - 30;
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.contract.desc1"), textLeft, this.topPos + 80, textWidth, 0xFFFFFF);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.contract.desc2"), textLeft, this.topPos + 140, textWidth, 0xFFFFFF);
        graphics.m_280554_(this.f_96547_, (FormattedText)Component.m_237115_((String)"gui.timemercenaries.tutorial.contract.desc3"), textLeft, this.topPos + 190, textWidth, 0x55FFFF);
        this.renderItemAndCount(graphics, Items.f_42516_.m_7968_(), this.leftPos + 112, this.topPos + 220, "1", 0xFFFFFF);
    }

    public void updateRenderButtons(int updateIndex) {
        if (this.renderedButton != null) {
            this.removeWidget(this.renderedButton);
        }
        this.deleteAllTemporaryWidgets();
        if (DimensionalTimeClockTutorialScreen.loreData.completeStepButton != null) {
            if (DimensionalTimeClockTutorialScreen.loreData.progress == 0.0f) {
                DimensionalTimeClockTutorialScreen.loreData.completeStepButton.m_264152_(this.leftPos + 110, this.topPos + 198);
            } else if (DimensionalTimeClockTutorialScreen.loreData.progress >= 0.1f && DimensionalTimeClockTutorialScreen.loreData.progress <= 0.4f) {
                DimensionalTimeClockTutorialScreen.loreData.completeStepButton.m_264152_(this.leftPos + 88, this.topPos + 226);
            } else if (DimensionalTimeClockTutorialScreen.loreData.progress == 0.5f) {
                DimensionalTimeClockTutorialScreen.loreData.completeStepButton.m_264152_(this.leftPos + 110, this.topPos + 218);
            }
            this.renderedButton = (Button)this.m_142416_((GuiEventListener)DimensionalTimeClockTutorialScreen.loreData.completeStepButton);
        }
        update.setUpdated(updateIndex);
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.commonRender(graphics);
        if (update.shouldUpdate(0)) {
            this.updateRenderButtons(0);
        }
        if (DimensionalTimeClockTutorialScreen.loreData.progress == 0.0f) {
            this.renderFirstLoreStep(graphics);
        } else if (DimensionalTimeClockTutorialScreen.loreData.progress == 0.1f) {
            this.renderSecondLoreStep(graphics);
        } else if (DimensionalTimeClockTutorialScreen.loreData.progress == 0.2f) {
            this.renderThirdLoreStep(graphics);
        } else if (DimensionalTimeClockTutorialScreen.loreData.progress == 0.3f) {
            this.renderFourthLoreStep(graphics);
        } else if (DimensionalTimeClockTutorialScreen.loreData.progress == 0.4f) {
            this.renderFifthLoreStep(graphics);
        } else if (DimensionalTimeClockTutorialScreen.loreData.progress == 0.5f) {
            this.renderSixthLoreStep(graphics);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }
}

