/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.screen.dtc;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.client.data.MercenaryData;
import io.github.sluggly.timemercenaries.client.data.MissionData;
import io.github.sluggly.timemercenaries.client.data.ModuleData;
import io.github.sluggly.timemercenaries.client.handler.ButtonHandler;
import io.github.sluggly.timemercenaries.client.screen.dtc.AbstractDimensionalTimeClockScreen;
import io.github.sluggly.timemercenaries.item.DimensionalTimeClock;
import io.github.sluggly.timemercenaries.missions.Mission;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class DimensionalTimeClockWaitingMissionScreen
extends AbstractDimensionalTimeClockScreen {
    public static final String screenType = "WaitingScreen";
    public static MercenaryData mercenaryData;
    public static ModuleData moduleData;
    public static MissionData missionData;
    public static int currentTimeLeft;
    public static long lastUpdate;
    public static Button buttonGenerateMissionResult;
    public static Button buttonSkippingReturn;
    private static final ResourceLocation DEFAULT_SCROLLING_MISSION_TEXTURE;
    private static final ResourceLocation BACKGROUND_TEXTURE_BORDER;
    private static ResourceLocation BACKGROUND_TEXTURE;
    private static int BG_IMAGE_WIDTH;
    private static final int BG_IMAGE_HEIGHT = 68;
    private static final int BG_DISPLAY_WIDTH = 166;
    private static final int BG_SCROLL_SPEED = 1;
    private static int MERCENARY_IMAGE_WIDTH;
    private static int MERCENARY_IMAGE_HEIGHT;
    private static int MERCENARY_DISPLAY_WIDTH;
    private static final double MERCENARY_SCROLL_SPEED = 0.5;
    private static final int MERCENARY_NUMBER_FRAMES = 4;

    public DimensionalTimeClockWaitingMissionScreen() {
        this.imageWidth = 256;
        this.imageHeight = 256;
        this.TEXTURE = new ResourceLocation("timemercenaries", "textures/gui/dimensional_time_clock_screen.png");
        mapTypeToScreenClass.put(screenType, ((Object)((Object)this)).getClass());
    }

    protected void m_7856_() {
        this.commonInit(true);
        currentTimeLeft = DimensionalTimeClock.mapMercenaryTimeLeft.getOrDefault(DimensionalTimeClockWaitingMissionScreen.mercenaryData.name, 0);
        if (moduleData.hasModule("Skipping Module")) {
            buttonSkippingReturn = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ButtonHandler.Back, ButtonHandler::handleSkippingReturn).m_252987_(this.leftPos + 208, this.topPos + 10, 40, 20).m_253136_());
        }
        buttonGenerateMissionResult = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)ButtonHandler.Waiting, ButtonHandler::handleGenerateMissionResult).m_252987_(this.leftPos + 88, this.topPos + 226, 80, 20).m_253136_());
        DimensionalTimeClockWaitingMissionScreen.buttonGenerateMissionResult.f_93623_ = false;
        if (currentTimeLeft == 0) {
            DimensionalTimeClockWaitingMissionScreen.buttonGenerateMissionResult.f_93623_ = true;
            if (missionData == null) {
                buttonGenerateMissionResult.m_93666_(ButtonHandler.Next);
            } else {
                buttonGenerateMissionResult.m_93666_(ButtonHandler.Results);
            }
        }
        if (Admin.CLIENT_IS_ADMIN_MODE_ACTIVATED) {
            this.m_142416_((GuiEventListener)new AbstractDimensionalTimeClockScreen.AdminButton(mercenaryData, this.leftPos + 256, this.topPos + 30, 50, 20, (Component)Component.m_237113_((String)"SUCCESS"), ButtonHandler::handleAdminSuccessMission, null));
            this.m_142416_((GuiEventListener)new AbstractDimensionalTimeClockScreen.AdminButton(mercenaryData, this.leftPos + 256, this.topPos + 50, 50, 20, (Component)Component.m_237113_((String)"FAIL"), ButtonHandler::handleAdminFailMission, null));
        }
        BACKGROUND_TEXTURE = missionData != null && DimensionalTimeClockWaitingMissionScreen.missionData.backgroundTexture != null ? DimensionalTimeClockWaitingMissionScreen.missionData.backgroundTexture : (mercenaryData != null && DimensionalTimeClockWaitingMissionScreen.mercenaryData.backgroundTexture != null ? DimensionalTimeClockWaitingMissionScreen.mercenaryData.backgroundTexture : DEFAULT_SCROLLING_MISSION_TEXTURE);
        AbstractTexture textureBackground = Minecraft.m_91087_().m_91097_().m_118506_(BACKGROUND_TEXTURE);
        RenderSystem.bindTexture((int)textureBackground.m_117963_());
        BG_IMAGE_WIDTH = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4096);
        if (mercenaryData != null && DimensionalTimeClockWaitingMissionScreen.mercenaryData.walkingTexture != null) {
            AbstractTexture textureWalking = Minecraft.m_91087_().m_91097_().m_118506_(DimensionalTimeClockWaitingMissionScreen.mercenaryData.walkingTexture);
            RenderSystem.bindTexture((int)textureWalking.m_117963_());
            MERCENARY_IMAGE_WIDTH = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4096);
            MERCENARY_IMAGE_HEIGHT = GlStateManager._getTexLevelParameter((int)3553, (int)0, (int)4097);
            MERCENARY_DISPLAY_WIDTH = MERCENARY_IMAGE_WIDTH / 4;
        }
    }

    public void renderWaitingScreenMissionData(@NotNull GuiGraphics graphics) {
        if (missionData != null) {
            this.renderMissionInfo(graphics, 171, 35, 1, missionData, mercenaryData, moduleData);
        }
        if (currentTimeLeft > 0) {
            if (missionData == null) {
                graphics.m_280137_(this.f_96547_, DimensionalTimeClockWaitingMissionScreen.mercenaryData.name + " has been skipped.", this.leftPos + 125, this.topPos + 190, 0xFFFFFF);
            } else {
                graphics.m_280137_(this.f_96547_, DimensionalTimeClockWaitingMissionScreen.mercenaryData.name + " is currently on a mission.", this.leftPos + 125, this.topPos + 190, 0xFFFFFF);
            }
            String timeLeftString = Mission.getMissionLengthString(currentTimeLeft);
            int timeLeftColor = Mission.getMissionDurationColor(timeLeftString);
            if (moduleData.hasModule("Planner Module")) {
                graphics.m_280137_(this.f_96547_, "Time left : %ds".formatted(currentTimeLeft), this.leftPos + 125, this.topPos + 215, timeLeftColor);
            } else {
                graphics.m_280137_(this.f_96547_, "Time left : " + timeLeftString, this.leftPos + 125, this.topPos + 215, timeLeftColor);
            }
        } else if (missionData == null) {
            graphics.m_280137_(this.f_96547_, DimensionalTimeClockWaitingMissionScreen.mercenaryData.name + " is ready to get replaced.", this.leftPos + 125, this.topPos + 210, 0xFFFFFF);
        } else {
            graphics.m_280137_(this.f_96547_, DimensionalTimeClockWaitingMissionScreen.mercenaryData.name + " has finished his mission.", this.leftPos + 125, this.topPos + 210, 0xFFFFFF);
        }
    }

    public void renderScrollingBackground(@NotNull GuiGraphics graphics, float partialTicks) {
        assert (Minecraft.m_91087_().f_91073_ != null);
        long time = Minecraft.m_91087_().f_91073_.m_46467_();
        float scrollOffset = ((float)time + partialTicks) * 1.0f;
        int mercenary_frame = (int)((double)((float)time + partialTicks) * 0.5) % 4;
        int u = (int)(scrollOffset % (float)(BG_IMAGE_WIDTH - 166));
        int x = this.leftPos + 3;
        int y = this.topPos + 110;
        graphics.m_280163_(BACKGROUND_TEXTURE_BORDER, x - 1, y - 1, 0.0f, 0.0f, 168, 70, BG_IMAGE_WIDTH + 2, 70);
        graphics.m_280163_(BACKGROUND_TEXTURE, x, y, (float)u, 0.0f, 166, 68, BG_IMAGE_WIDTH, 68);
        if (mercenaryData != null && DimensionalTimeClockWaitingMissionScreen.mercenaryData.walkingTexture != null) {
            graphics.m_280163_(DimensionalTimeClockWaitingMissionScreen.mercenaryData.walkingTexture, x + 83, y + 50 - MERCENARY_IMAGE_HEIGHT, (float)(mercenary_frame * MERCENARY_DISPLAY_WIDTH), 0.0f, MERCENARY_DISPLAY_WIDTH, MERCENARY_IMAGE_HEIGHT, MERCENARY_IMAGE_WIDTH, MERCENARY_IMAGE_HEIGHT);
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (currentTimeLeft > 0) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            assert (level != null);
            long currentTime = level.m_46467_();
            if (currentTime % 20L == 0L && lastUpdate != currentTime) {
                lastUpdate = currentTime;
                if (--currentTimeLeft == 0) {
                    DimensionalTimeClockWaitingMissionScreen.buttonGenerateMissionResult.f_93623_ = true;
                    if (missionData == null) {
                        buttonGenerateMissionResult.m_93666_(ButtonHandler.Next);
                    } else {
                        buttonGenerateMissionResult.m_93666_(ButtonHandler.Results);
                    }
                }
            }
        }
        this.commonRender(graphics);
        this.renderMercenaryInfo(graphics, 3, 35, 0, mercenaryData, this.screenData);
        this.renderWaitingScreenMissionData(graphics);
        this.renderScrollingBackground(graphics, partialTicks);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    static {
        lastUpdate = 0L;
        DEFAULT_SCROLLING_MISSION_TEXTURE = new ResourceLocation("timemercenaries", "textures/gui/plain_background.png");
        BACKGROUND_TEXTURE_BORDER = new ResourceLocation("timemercenaries", "textures/gui/background_border.png");
    }
}

