/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.client.screen.lene;

import io.github.sluggly.timemercenaries.client.KeyBindings;
import io.github.sluggly.timemercenaries.client.data.LoreData;
import io.github.sluggly.timemercenaries.client.handler.ClientHooks;
import io.github.sluggly.timemercenaries.item.DimensionalTimeClock;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDialogScreen
extends Screen {
    public static final Component TITLE = Component.m_237115_((String)"gui.dimensional_time_mod_screen");
    public ResourceLocation TEXTURE;
    public int leftPos;
    public int topPos;
    public int imageWidth;
    public int imageHeight;
    public static String screenType;
    public static final BooleanWrapper update;
    public final ArrayList<AbstractWidget> temporaryWidgets = new ArrayList();

    protected AbstractDialogScreen() {
        super(TITLE);
    }

    public void commonInit() {
        super.m_7856_();
        if (this.f_96541_ == null) {
            return;
        }
        if (this.f_96541_.f_91073_ == null) {
            return;
        }
        update.reset();
        update.setScreen(this);
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
    }

    public void commonRender(@NotNull GuiGraphics graphics) {
        this.m_280273_(graphics);
        graphics.m_280218_(this.TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void renderWidget(AbstractWidget widget) {
        this.temporaryWidgets.add(widget);
        this.m_142416_((GuiEventListener)widget);
    }

    public void deleteAllTemporaryWidgets() {
        for (AbstractWidget widget : this.temporaryWidgets) {
            this.m_169411_((GuiEventListener)widget);
        }
        this.temporaryWidgets.clear();
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_6574_(@NotNull Minecraft minecraft, int width, int height) {
        super.m_6574_(minecraft, width, height);
        update.setDirty();
    }

    public void renderDialogPortrait(@NotNull GuiGraphics graphics, int x, int y, int updateIndex, LoreData loreData) {
        graphics.m_280163_(loreData.texture, this.leftPos + x + 2, this.topPos + y + 2, 0.0f, 0.0f, 49, 42, 256, 256);
        if (update.shouldUpdate(updateIndex)) {
            loreData.nameWidget.m_264152_(this.leftPos + x + 2, this.topPos + y + 3);
            this.renderWidget((AbstractWidget)loreData.nameWidget);
            update.setUpdated(updateIndex);
        }
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == KeyBindings.INSTANCE.useDimensionalTimeClockKey.getKey().m_84873_()) {
            assert (Minecraft.m_91087_().f_91073_ != null);
            DimensionalTimeClock.lastSentTick = Minecraft.m_91087_().f_91073_.m_46467_();
            ClientHooks.closeCurrentScreen();
            return true;
        }
        if (pKeyCode == Minecraft.m_91087_().f_91066_.f_92092_.getKey().m_84873_()) {
            ClientHooks.closeCurrentScreen();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    static {
        update = new BooleanWrapper();
    }

    public static class BooleanWrapper {
        public boolean isUpdated = false;
        int numberToUpdate = 0;
        AbstractDialogScreen screen = null;

        public void setScreen(AbstractDialogScreen screen) {
            this.screen = screen;
        }

        public void reset() {
            this.isUpdated = false;
            this.numberToUpdate = 0;
        }

        public void setDirty() {
            this.isUpdated = false;
            if (this.screen != null) {
                this.screen.deleteAllTemporaryWidgets();
            }
        }

        public void setUpdated(int index) {
            if (index == this.numberToUpdate) {
                ++this.numberToUpdate;
                this.isUpdated = true;
            } else if (index == this.numberToUpdate - 1) {
                this.isUpdated = true;
            }
        }

        public boolean shouldUpdate(int index) {
            return !this.isUpdated || index == this.numberToUpdate;
        }
    }
}

