/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.compat;

import io.github.sluggly.timemercenaries.item.DimensionalTimeClock;
import io.github.sluggly.timemercenaries.item.artefacts.ForgeheartCharm;
import io.github.sluggly.timemercenaries.item.artefacts.GuildBearersSeal;
import io.github.sluggly.timemercenaries.item.artefacts.TalismanOfTheWilds;
import io.github.sluggly.timemercenaries.item.artefacts.VolatileConcoctionCasing;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosCompat {
    private static final List<Class<? extends Item>> CURIO_ITEM_CLASSES = List.of(DimensionalTimeClock.class, VolatileConcoctionCasing.class, GuildBearersSeal.class, TalismanOfTheWilds.class, ForgeheartCharm.class);

    public static boolean isACurioItem(Item item) {
        for (Class<? extends Item> cls : CURIO_ITEM_CLASSES) {
            if (!cls.isInstance(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasItemEquippedAsCurio(Player player, Item item) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(handler -> handler.findFirstCurio(item).isPresent()).orElse(false);
    }

    public static void attachCapability(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (!CuriosCompat.isACurioItem(stack.m_41720_())) {
            return;
        }
        event.addCapability(new ResourceLocation("timemercenaries", "curio"), (ICapabilityProvider)new CurioProvider(stack));
    }

    public static void handleAttachCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        Item item = ((ItemStack)event.getObject()).m_41720_();
        if (CuriosCompat.isACurioItem(item) && ModList.get().isLoaded("curios")) {
            CuriosCompat.attachCapability(event);
        }
    }

    public static void repairAllEquippedCurios(ServerPlayer player) {
        CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(inventory -> {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getEquippedCurios().getStackInSlot(i);
                if (!stack.m_41763_()) continue;
                stack.m_41721_(0);
            }
        });
    }

    private static class CurioProvider
    implements ICapabilityProvider {
        private final ItemStack stack;
        private final LazyOptional<ICurio> curio;

        public CurioProvider(ItemStack stack) {
            this.stack = stack;
            this.curio = LazyOptional.of(() -> new Curio(this.stack));
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return CuriosCapability.ITEM.orEmpty(cap, this.curio);
        }
    }

    private static class Curio
    implements ICurio {
        private final ItemStack stack;

        public Curio(ItemStack stack) {
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void curioTick(SlotContext slotContext) {
            if (slotContext.entity() != null) {
                this.stack.m_41720_().m_6883_(this.stack, slotContext.entity().m_9236_(), (Entity)slotContext.entity(), -1, false);
            }
        }

        public void onEquip(SlotContext slotContext, ItemStack prevStack) {
            LivingEntity livingEntity;
            if (this.stack.m_41720_() instanceof DimensionalTimeClock && (livingEntity = slotContext.entity()) instanceof Player) {
                Player player = (Player)livingEntity;
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11675_, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.m_146850_(GameEvent.f_157811_);
            }
        }
    }
}

