/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.config;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ServerConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> DISABLED_MERCENARIES;
    private static boolean isLoaded;

    public static boolean isMercenaryEnabled(String name) {
        return !((List)DISABLED_MERCENARIES.get()).contains(name);
    }

    public static void initServerConfig() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SPEC, "timemercenaries-server.toml");
    }

    public static void markLoaded() {
        isLoaded = true;
    }

    public static boolean isLoaded() {
        return isLoaded;
    }

    static {
        isLoaded = false;
        BUILDER.push("Mercenaries");
        DISABLED_MERCENARIES = BUILDER.comment("List of disabled mercenaries. Add or remove names to control availability.").defineList("disabledMercenaries", List.of(), obj -> obj instanceof String);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

