/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.data;

import io.github.sluggly.timemercenaries.data.DataUpdate;
import io.github.sluggly.timemercenaries.data.PlayerData;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class DataTester {
    public static PlayerData getVersion_0_9_0_PlayerData() {
        CompoundTag customData = new CompoundTag();
        customData.m_128359_("State", "WaitingMission");
        customData.m_128359_("ChosenRecruit", "Stroman");
        customData.m_128405_("ChosenMission", -1);
        CompoundTag mercenaries = new CompoundTag();
        String[] mercenariesArray = new String[]{"Brock", "Grizzle", "Harisson", "Liquarius", "Orion", "Sam", "Steve", "Stroman", "Zu'jin"};
        String[] traitsArray = new String[]{"Death", "Double", "Experience", "Fail", "Random", "Speed"};
        for (String mercenaryName : mercenariesArray) {
            CompoundTag tmpMercenary = new CompoundTag();
            tmpMercenary.m_128405_("Exp", 0);
            tmpMercenary.m_128379_("Totem", false);
            CompoundTag tmpTraits = new CompoundTag();
            for (String traitName : traitsArray) {
                tmpTraits.m_128405_(traitName, 0);
            }
            tmpMercenary.m_128365_("Traits", (Tag)tmpTraits);
            tmpMercenary.m_128365_("RandomTraits", (Tag)tmpTraits);
            mercenaries.m_128365_(mercenaryName, (Tag)tmpMercenary);
        }
        customData.m_128365_("Mercenaries", (Tag)mercenaries);
        CompoundTag recruitsAvailable = new CompoundTag();
        recruitsAvailable.m_128359_("Recruit1", "Stroman");
        recruitsAvailable.m_128359_("Recruit2", "Steve");
        recruitsAvailable.m_128359_("Recruit3", "Harisson");
        customData.m_128365_("RecruitsAvailable", (Tag)recruitsAvailable);
        customData.m_128385_("MissionsAvailable", new int[]{11, 6, 33});
        customData.m_128359_("MissionStatus", "Skipped");
        customData.m_128405_("Seed", 91481);
        customData.m_128405_("TimeLeft", 150);
        customData.m_128405_("TotalTime", 150);
        return new PlayerData(null, customData);
    }

    public static void runTests() {
        HashMap<String, PlayerData> mapVersionData = new HashMap<String, PlayerData>();
        PlayerData Version090 = DataTester.getVersion_0_9_0_PlayerData();
        DataUpdate.checkAndUpdatePlayerCustomData(Version090);
        mapVersionData.put("0.9.0", Version090);
        PlayerData currentData = new PlayerData(null, null);
        for (String version : mapVersionData.keySet()) {
            PlayerData oldData = (PlayerData)mapVersionData.get(version);
            System.out.println("Current Data " + String.valueOf(currentData.playerDataTag));
            System.out.println("Old Data " + String.valueOf(oldData.playerDataTag));
            System.out.println("START CHECK MISSING. VERSION : " + version);
            if (DataTester.checkIfAnyTagMissing(currentData.playerDataTag, oldData.playerDataTag, "")) {
                System.out.println("VERSION : " + version + " CHECK MISSING : OK");
            } else {
                System.out.println("VERSION : " + version + " CHECK MISSING : FAILED");
            }
            System.out.println("START CHECK SHOULD NOT EXIST. VERSION : " + version);
            if (DataTester.checkIfAnyTagMissing(oldData.playerDataTag, currentData.playerDataTag, "")) {
                System.out.println("VERSION : " + version + " CHECK SHOULD NOT EXIST : OK");
                continue;
            }
            System.out.println("VERSION : " + version + " CHECK SHOULD NOT EXIST : FAILED");
        }
    }

    public static boolean checkIfAnyTagMissing(CompoundTag currentData, CompoundTag oldData, String path) {
        boolean isCheckOk = true;
        for (String key : currentData.m_128431_()) {
            if (!oldData.m_128441_(key)) {
                System.out.println("Missing tag : " + path + key);
                isCheckOk = false;
                continue;
            }
            Tag tag = currentData.m_128423_(key);
            assert (tag != null);
            if (tag.m_6458_() != Objects.requireNonNull(oldData.m_128423_(key)).m_6458_()) {
                System.out.println("Tag wrong type : " + path + key);
                isCheckOk = false;
                continue;
            }
            if (!(tag instanceof CompoundTag) || DataTester.checkIfAnyTagMissing(currentData.m_128469_(key), oldData.m_128469_(key), path + key)) continue;
            isCheckOk = false;
        }
        return isCheckOk;
    }
}

