/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.data;

import io.github.sluggly.timemercenaries.admin.Admin;
import io.github.sluggly.timemercenaries.capability.IPlayerData;
import io.github.sluggly.timemercenaries.capability.PlayerCapability;
import io.github.sluggly.timemercenaries.capability.PlayerDataProvider;
import io.github.sluggly.timemercenaries.data.DataUpdate;
import io.github.sluggly.timemercenaries.mercenary.Mercenary;
import io.github.sluggly.timemercenaries.mercenary.MercenaryManager;
import io.github.sluggly.timemercenaries.mercenary.MercenaryPlayerData;
import io.github.sluggly.timemercenaries.missions.MissionManager;
import io.github.sluggly.timemercenaries.module.Module;
import io.github.sluggly.timemercenaries.module.ModuleManager;
import io.github.sluggly.timemercenaries.network.PacketHandler;
import io.github.sluggly.timemercenaries.network.SyncMercenariesPacket;
import io.github.sluggly.timemercenaries.network.SyncMissionsPacket;
import io.github.sluggly.timemercenaries.network.SyncModulesPacket;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PlayerData {
    public static PlayerData globalPlayerData = null;
    public CompoundTag playerDataTag;
    public Player player;
    public final Map<String, Integer> missionTimeLeft = new HashMap<String, Integer>();
    public transient long lastUpdate = 0L;

    public PlayerData(Player player, CompoundTag customData) {
        this.player = player;
        if (customData != null) {
            this.playerDataTag = customData;
            MercenaryPlayerData.loadMercenaryMissionTimersFromNBT(this.missionTimeLeft, this.playerDataTag);
        } else {
            this.playerDataTag = new CompoundTag();
            this.generateAndAttachBaseModData(this.playerDataTag);
            MercenaryPlayerData.generateAndAttachBaseMercenaryCompoundTag(this, this.playerDataTag);
            Module.generateAndAttachBaseModuleCompoundTag(this.playerDataTag);
            this.generateAndAttachBaseLoreCompoundTag(this.playerDataTag);
            this.generateAndAttachBasePlayerCompoundTag(this.playerDataTag);
        }
    }

    public static void playerScoutingReturn(ServerPlayer player) {
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (playerData == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (!Module.isModuleActive(playerData, "Scouting Module")) {
            Admin.playerRequestError((Player)player, "Scouting Module is not active.");
            return;
        }
        if (!playerData.getCurrentState().equals("SendingMission")) {
            Admin.playerRequestError((Player)player, "Wrong State, expected SendingMission received " + playerData.getCurrentState() + ".");
            return;
        }
        playerData.setState("Recruiting");
        MercenaryPlayerData.setCurrentMercenary(playerData, "None");
        PacketHandler.sendToPlayer("OpenRecruitScreen", playerData, player);
    }

    public static void playerSkippingReturn(ServerPlayer player) {
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (playerData == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (!Module.isModuleActive(playerData, "Skipping Module")) {
            Admin.playerRequestError((Player)player, "Skipping Module is not active.");
            return;
        }
        playerData.setState("Recruiting");
        MercenaryPlayerData.setCurrentMercenary(playerData, "None");
        PacketHandler.sendToPlayer("OpenRecruitScreen", playerData, player);
    }

    public static void playerGoToWaitingScreen(ServerPlayer player, String mercenaryName) {
        PlayerData playerData = PlayerData.getPlayerData((Player)player);
        if (playerData == null) {
            Admin.playerRequestError((Player)player, "Player Data is null.");
            return;
        }
        if (!Module.isModuleActive(playerData, "Skipping Module")) {
            Admin.playerRequestError((Player)player, "Skipping Module is not active.");
            return;
        }
        if (!playerData.getCurrentState().equals("Recruiting")) {
            Admin.playerRequestError((Player)player, "Wrong State, expected Recruiting received " + playerData.getCurrentState() + ".");
            return;
        }
        playerData.setState("WaitingMission");
        MercenaryPlayerData.setCurrentMercenary(playerData, mercenaryName);
        PacketHandler.sendToPlayer("OpenWaitingMissionScreen", playerData, player);
    }

    public void readNBT(CompoundTag nbt) {
        if (nbt != null) {
            this.playerDataTag = nbt.m_6426_();
            MercenaryPlayerData.loadMercenaryMissionTimersFromNBT(this.missionTimeLeft, this.playerDataTag);
        }
    }

    public static PlayerData getPlayerData(Player player) {
        if (player == null) {
            return globalPlayerData;
        }
        return player.getCapability(PlayerCapability.PLAYER_DATA).map(IPlayerData::getPlayerData).orElse(null);
    }

    public static void logCustomData(Player player, boolean serverSide) {
        if (serverSide) {
            PlayerData.logCustomData(PlayerData.getPlayerData(player));
        } else {
            PlayerData.logCustomData(globalPlayerData);
        }
    }

    public static void logCustomData(PlayerData playerData) {
        if (playerData == null) {
            System.out.println("Logged PlayerData is null");
            return;
        }
        PlayerData.logCustomData(playerData.getCompoundTag());
    }

    public static void logCustomData(CompoundTag customData) {
        if (customData == null) {
            System.out.println("Logged CompoundTag is null");
            return;
        }
        System.out.println(customData);
    }

    public void generateAndAttachBaseModData(CompoundTag playerData) {
        if (playerData.m_128441_("Version")) {
            playerData.m_128473_("Version");
        }
        playerData.m_128405_("Version", 5);
        if (playerData.m_128441_("ModVersion")) {
            playerData.m_128473_("ModVersion");
        }
        playerData.m_128359_("ModVersion", "0.14.3");
    }

    public void generateAndAttachBaseLoreCompoundTag(CompoundTag playerData) {
        if (playerData.m_128441_("Lore")) {
            playerData.m_128473_("Lore");
        }
        CompoundTag lore = new CompoundTag();
        lore.m_128350_("Progress", 0.0f);
        lore.m_128405_("Count", 0);
        playerData.m_128365_("Lore", (Tag)lore);
    }

    public void generateAndAttachBasePlayerCompoundTag(CompoundTag playerData) {
        CompoundTag playerInfo = new CompoundTag();
        playerInfo.m_128405_("HatCoinCount", 0);
        playerInfo.m_128356_("HatLastTradeDay", 0L);
        playerData.m_128365_("Player", (Tag)playerInfo);
    }

    public CompoundTag getPlayerInformation() {
        return this.playerDataTag.m_128469_("Player");
    }

    public CompoundTag getCompoundTag() {
        MercenaryPlayerData.saveMercenaryMissionTimersToNBT(this.missionTimeLeft, this.playerDataTag);
        return this.playerDataTag;
    }

    public void setState(String state) {
        this.playerDataTag.m_128359_("State", state);
    }

    public String getCurrentState() {
        return this.playerDataTag.m_128461_("State");
    }

    public int getNumberOfQuests() {
        return 3;
    }

    public int getNumberOfMissions() {
        return 3;
    }

    public void checkNBTSize() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            NbtIo.m_128941_((CompoundTag)this.playerDataTag, (DataOutput)dataOutputStream);
            dataOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.printf("NBT Size: %d%n", byteArrayOutputStream.size());
    }

    public static void initializeRuntimeTimers(ServerPlayer player) {
        player.getCapability(PlayerCapability.PLAYER_DATA).ifPresent(cap -> {
            PlayerData playerData = cap.getPlayerData();
            if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                System.out.println(player.m_6302_() + " entity initialized. Setting up runtime mission timers.");
            }
            playerData.missionTimeLeft.clear();
            for (String mercenaryName : Mercenary.getMercenariesName()) {
                String status = MercenaryPlayerData.getMercenaryMissionStatus(playerData, mercenaryName);
                if (!status.equals("Ongoing") && !status.equals("Skipped")) continue;
                int timeLeft = MercenaryPlayerData.getMercenaryMissionTimeLeft(playerData, mercenaryName);
                playerData.missionTimeLeft.put(mercenaryName, timeLeft);
            }
            PacketHandler.sendToPlayer("AddMercenariesToMap", playerData, player);
        });
    }

    public static void handlePlayerDataLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SyncMercenariesPacket mercenariesPacket = new SyncMercenariesPacket(MercenaryManager.getMercenaryManager().getEnabledMercenaries());
            PacketHandler.sendToPlayer(mercenariesPacket, serverPlayer);
            SyncMissionsPacket missionsPacket = new SyncMissionsPacket(MissionManager.getMissionManager().getEnabledMissions());
            PacketHandler.sendToPlayer(missionsPacket, serverPlayer);
            SyncModulesPacket modulesPacket = new SyncModulesPacket(ModuleManager.getModuleManager().getAllModules());
            PacketHandler.sendToPlayer(modulesPacket, serverPlayer);
            if (Admin.ADMIN_RESET_ON_LOGIN) {
                serverPlayer.getCapability(PlayerCapability.PLAYER_DATA).ifPresent(cap -> {
                    PlayerData freshData = new PlayerData((Player)serverPlayer, null);
                    cap.getPlayerData().playerDataTag = freshData.playerDataTag;
                    if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                        System.out.println(serverPlayer.m_6302_() + " logged in. Forced Admin Reset.");
                    }
                });
            }
            serverPlayer.getCapability(PlayerCapability.PLAYER_DATA).ifPresent(cap -> {
                PlayerData playerData;
                CompoundTag customData = (CompoundTag)serverPlayer.getPersistentData().m_128423_("TimeMercenaries");
                if (customData != null) {
                    playerData = new PlayerData((Player)serverPlayer, customData);
                    cap.getPlayerData().playerDataTag = playerData.playerDataTag;
                    serverPlayer.getPersistentData().m_128473_("TimeMercenaries");
                    DataUpdate.checkAndUpdatePlayerCustomData(playerData);
                } else {
                    playerData = cap.getPlayerData();
                    DataUpdate.checkAndUpdatePlayerCustomData(playerData);
                    PlayerData.initializeRuntimeTimers(serverPlayer);
                }
                if (Admin.ADMIN_SERVER_CONSOLE_LOG) {
                    PlayerData.logCustomData(playerData);
                    playerData.checkNBTSize();
                }
            });
        }
    }

    public static void handlePlayerDataCloneEvent(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        try {
            event.getOriginal().getCapability(PlayerCapability.PLAYER_DATA).ifPresent(oldStore -> event.getEntity().getCapability(PlayerCapability.PLAYER_DATA).ifPresent(newStore -> newStore.loadNBTData(oldStore.saveNBTData())));
        }
        finally {
            event.getOriginal().invalidateCaps();
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer newServerPlayer = (ServerPlayer)player;
            PlayerData.initializeRuntimeTimers(newServerPlayer);
        }
    }

    public static void handleAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("timemercenaries", "player_data"), (ICapabilityProvider)new PlayerDataProvider((Player)event.getObject()));
        }
    }
}

