/*
 * Decompiled with CFR 0.152.
 */
package io.github.sluggly.timemercenaries.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class FlyingItem
extends Entity {
    private static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(FlyingItem.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Integer> DATA_TARGET_ID = SynchedEntityData.m_135353_(FlyingItem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Entity target;
    private int life = 500;
    private static final int TRAVEL_TIME_TICKS = 30;
    private boolean initialDistanceCalculated = false;
    private double speed = 0.0;

    public FlyingItem(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public void setItem(ItemStack item) {
        this.m_20088_().m_135381_(DATA_ITEM_STACK, (Object)item.m_41777_());
    }

    public ItemStack getItem() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    public void setTarget(Entity entity) {
        this.m_20088_().m_135381_(DATA_TARGET_ID, (Object)entity.m_19879_());
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> pKey) {
        super.m_7350_(pKey);
    }

    public void m_8119_() {
        int targetId;
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            return;
        }
        if (this.target == null && (targetId = ((Integer)this.m_20088_().m_135370_(DATA_TARGET_ID)).intValue()) != 0) {
            this.target = this.m_9236_().m_6815_(targetId);
        }
        if (this.target == null || !this.target.m_6084_() || this.life-- <= 0) {
            this.m_146870_();
            return;
        }
        Vec3 targetPos = this.target.m_20182_().m_82520_(0.0, (double)this.target.m_20206_() / 2.0, 0.0);
        Vec3 currentPos = this.m_20182_();
        Vec3 moveVector = targetPos.m_82546_(currentPos);
        if (!this.initialDistanceCalculated) {
            this.speed = moveVector.m_82553_() / 30.0;
            this.initialDistanceCalculated = true;
        }
        if (moveVector.m_82556_() < 0.5) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11852_, this.m_5720_(), 0.4f, 2.0f, false);
            this.m_146870_();
            return;
        }
        this.m_20256_(moveVector.m_82541_().m_82490_(this.speed));
        this.m_146884_(currentPos.m_82549_(this.m_20184_()));
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.m_20088_().m_135372_(DATA_TARGET_ID, (Object)0);
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128425_("Item", 10)) {
            this.setItem(ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("Item")));
        }
    }

    protected void m_7380_(@NotNull CompoundTag pCompound) {
        if (!this.getItem().m_41619_()) {
            pCompound.m_128365_("Item", (Tag)this.getItem().m_41739_(new CompoundTag()));
        }
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

